/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.scripts.triggers.core.ChatTrigger;
import com.denizenscript.denizen.scripts.triggers.core.ClickTrigger;
import com.denizenscript.denizen.scripts.triggers.core.DamageTrigger;
import com.denizenscript.denizen.scripts.triggers.core.ProximityTrigger;
import com.denizenscript.denizen.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;

public class TriggerRegistry {
    private Map<String, AbstractTrigger> instances = new HashMap<String, AbstractTrigger>();
    private Map<Class<? extends AbstractTrigger>, String> classes = new HashMap<Class<? extends AbstractTrigger>, String>();
    Map<String, Map<String, Long>> playerCooldown = new HashMap<String, Map<String, Long>>();

    public void disableCoreMembers() {
        for (AbstractTrigger member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                Debug.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                Debug.echoError(e);
            }
        }
    }

    public <T extends AbstractTrigger> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((AbstractTrigger)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    public AbstractTrigger get(String triggerName) {
        return this.instances.getOrDefault(triggerName.toUpperCase(), null);
    }

    public Map<String, AbstractTrigger> list() {
        return this.instances;
    }

    public void register(String triggerName, AbstractTrigger instance) {
        this.instances.put(triggerName.toUpperCase(), instance);
        this.classes.put(instance.getClass(), triggerName.toUpperCase());
    }

    public void registerCoreMembers() {
        new ClickTrigger().activate().as("Click");
        new ChatTrigger().activate().as("Chat");
        new DamageTrigger().activate().as("Damage");
        new ProximityTrigger().activate().as("Proximity");
        Debug.echoApproval("Loaded core triggers: " + this.instances.keySet().toString());
    }

    public boolean checkCooldown(NPC npc, PlayerTag player, AbstractTrigger triggerClass) {
        if (!this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
            return true;
        }
        if (!this.playerCooldown.get(player.getName() + "/" + npc.getId()).containsKey(triggerClass.name)) {
            return true;
        }
        return System.currentTimeMillis() > this.playerCooldown.get(player.getName() + "/" + npc.getId()).get(triggerClass.name);
    }

    public void setCooldown(NPC npc, PlayerTag player, AbstractTrigger triggerClass, double seconds) {
        boolean noCooldown;
        Map<Object, Object> triggerMap = new HashMap<String, Long>();
        boolean bl = noCooldown = seconds <= 0.0;
        if (this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
            triggerMap = this.playerCooldown.get(player.getName() + "/" + npc.getId());
        }
        if (noCooldown && this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
            triggerMap.remove(player.getName() + "/" + npc.getId());
        } else {
            triggerMap.put(triggerClass.name, System.currentTimeMillis() + (long)(seconds * 1000.0));
        }
        this.playerCooldown.put(player.getName() + "/" + npc.getId(), triggerMap);
    }
}

