/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.npc.DenizenNPCHelper;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.DenizenFlagsTrait;
import com.denizenscript.denizen.npc.traits.FishingTrait;
import com.denizenscript.denizen.npc.traits.NicknameTrait;
import com.denizenscript.denizen.npc.traits.PushableTrait;
import com.denizenscript.denizen.npc.traits.SittingTrait;
import com.denizenscript.denizen.npc.traits.SleepingTrait;
import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.npc.EngageCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.Pose;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class NPCTag
implements ObjectTag,
Adjustable,
InventoryHolder,
EntityFormObject,
FlaggableObject {
    public NPC npc;
    private String prefix = "npc";
    public static ObjectTagProcessor<NPCTag> tagProcessor = new ObjectTagProcessor();

    public static NPCRegistry getRegistryByName(String name) {
        NPCRegistry registry = CitizensAPI.getNamedNPCRegistry((String)name);
        if (registry != null) {
            return registry;
        }
        for (NPCRegistry possible : CitizensAPI.getNPCRegistries()) {
            if (!possible.getName().equals(name)) continue;
            return possible;
        }
        return null;
    }

    public static NPCTag fromEntity(Entity entity) {
        return new NPCTag(((NPCHolder)entity).getNPC());
    }

    @Deprecated
    public static NPCTag valueOf(String string) {
        return NPCTag.valueOf(string, null);
    }

    @Fetchable(value="n")
    public static NPCTag valueOf(String string, TagContext context) {
        NPCRegistry registry;
        if (string == null) {
            return null;
        }
        if (string.startsWith("n@")) {
            string = string.substring("n@".length());
        }
        int commaIndex = string.indexOf(44);
        String idText = string;
        if (commaIndex == -1) {
            registry = CitizensAPI.getNPCRegistry();
        } else {
            registry = NPCTag.getRegistryByName(string.substring(commaIndex + 1));
            if (registry == null) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Unknown NPC registry for '" + string + "'.");
                }
                return null;
            }
            idText = string.substring(0, commaIndex);
        }
        if (ArgumentHelper.matchesInteger(idText)) {
            int id = Integer.parseInt(idText);
            NPC npc = registry.getById(id);
            if (npc != null) {
                return new NPCTag(npc);
            }
            if (context == null || context.showErrors()) {
                Debug.echoError("NPC '" + id + "' does not exist in " + registry.getName() + ".");
            }
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("n@")) {
            return true;
        }
        return NPCTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public boolean isValid() {
        return this.npc != null && this.npc.getOwningRegistry().getById(this.npc.getId()) != null;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return ((DenizenFlagsTrait)this.npc.getOrAddTrait(DenizenFlagsTrait.class)).fullFlagData;
    }

    public boolean hasFlag(String flag) {
        DenizenFlagsTrait flagTrait = (DenizenFlagsTrait)this.npc.getTraitNullable(DenizenFlagsTrait.class);
        if (flagTrait == null) {
            return false;
        }
        return flagTrait.fullFlagData.hasFlag(flag);
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public NPCTag(NPC citizensNPC) {
        this.npc = citizensNPC;
    }

    public NPC getCitizen() {
        return this.npc;
    }

    public Entity getEntity() {
        try {
            return this.getCitizen().getEntity();
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC entity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public LivingEntity getLivingEntity() {
        try {
            if (this.getCitizen().getEntity() instanceof LivingEntity) {
                return (LivingEntity)this.getCitizen().getEntity();
            }
            Debug.log("Uh oh! Tried to get the living entity of a non-living NPC!");
            return null;
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC livingEntity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    @Override
    public EntityTag getDenizenEntity() {
        try {
            return new EntityTag(this.getCitizen().getEntity());
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC EntityTag. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public org.bukkit.inventory.Inventory getInventory() {
        return DenizenNPCHelper.getInventory(this.getCitizen());
    }

    public InventoryTag getDenizenInventory() {
        return new InventoryTag(this.getInventory(), this);
    }

    public EntityType getEntityType() {
        return this.getCitizen().getEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.npc.getId();
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public List<InteractScriptContainer> getInteractScripts() {
        return InteractScriptHelper.getInteractScripts(this);
    }

    public List<InteractScriptContainer> getInteractScripts(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScripts(this, player, true, triggerType);
    }

    public List<InteractScriptContainer> getInteractScriptsQuietly(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScripts(this, player, false, triggerType);
    }

    public void destroy() {
        this.getCitizen().destroy();
    }

    @Override
    public LocationTag getLocation() {
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public LocationTag getEyeLocation() {
        if (this.isSpawned() && this.getCitizen().getEntity() instanceof LivingEntity) {
            return new LocationTag(((LivingEntity)this.getCitizen().getEntity()).getEyeLocation());
        }
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.identify();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        return this.npc.isSpawned();
    }

    public UUID getOwner() {
        return ((Owner)this.getCitizen().getOrAddTrait(Owner.class)).getOwnerId();
    }

    public Equipment getEquipmentTrait() {
        return (Equipment)this.getCitizen().getOrAddTrait(Equipment.class);
    }

    public NicknameTrait getNicknameTrait() {
        return (NicknameTrait)this.getCitizen().getOrAddTrait(NicknameTrait.class);
    }

    public FishingTrait getFishingTrait() {
        return (FishingTrait)this.getCitizen().getOrAddTrait(FishingTrait.class);
    }

    public Inventory getInventoryTrait() {
        return (Inventory)this.getCitizen().getOrAddTrait(Inventory.class);
    }

    public PushableTrait getPushableTrait() {
        return (PushableTrait)this.getCitizen().getOrAddTrait(PushableTrait.class);
    }

    public LookClose getLookCloseTrait() {
        return (LookClose)this.getCitizen().getOrAddTrait(LookClose.class);
    }

    public TriggerTrait getTriggerTrait() {
        return (TriggerTrait)this.getCitizen().getOrAddTrait(TriggerTrait.class);
    }

    public ListTag action(String actionName, PlayerTag player, Map<String, ObjectTag> context) {
        ListTag result = new ListTag();
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            for (AssignmentScriptContainer container : ((AssignmentTrait)this.getCitizen().getOrAddTrait(AssignmentTrait.class)).containerCache) {
                ListTag singleResult;
                if (container == null || (singleResult = Denizen.getInstance().npcHelper.getActionHandler().doAction(actionName, this, player, container, context)) == null) continue;
                result.addAll(singleResult);
            }
        }
        return result;
    }

    public ListTag action(String actionName, PlayerTag player) {
        return this.action(actionName, player, null);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        if (this.npc.getOwningRegistry() == CitizensAPI.getNPCRegistry()) {
            return "<G>n@<Y>" + this.npc.getId() + "<GR> (" + this.getName() + "<GR>)";
        }
        return "<G>n@<Y>" + this.npc.getId() + "<G>," + this.npc.getOwningRegistry().getName() + "<GR> (" + this.getName() + "<GR>)";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "NPC";
    }

    @Override
    public String identify() {
        if (this.npc.getOwningRegistry() == CitizensAPI.getNPCRegistry()) {
            return "n@" + this.npc.getId();
        }
        return "n@" + this.npc.getId() + "," + this.npc.getOwningRegistry().getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public NPCTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NPCTag)) {
            return false;
        }
        return this.getId() == ((NPCTag)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "is_npc", (attribute, object) -> new ElementTag(true), new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "location", (attribute, object) -> {
            if (attribute.startsWith("previous_location", 2)) {
                attribute.fulfill(1);
                Deprecations.npcPreviousLocationTag.warn(attribute.context);
                return NPCTagBase.previousLocations.get(object.getId());
            }
            if (object.isSpawned()) {
                return new EntityTag((NPCTag)object).doLocationTag(attribute);
            }
            return object.getLocation();
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "previous_location", (attribute, object) -> NPCTagBase.previousLocations.get(object.getId()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "eye_location", (attribute, object) -> object.getEyeLocation(), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_nickname", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            return new ElementTag(citizen.hasTrait(NicknameTrait.class) && ((NicknameTrait)citizen.getOrAddTrait(NicknameTrait.class)).hasNickname());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_sitting", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            return new ElementTag(citizen.hasTrait(SittingTrait.class) && ((SittingTrait)citizen.getOrAddTrait(SittingTrait.class)).isSitting());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_sleeping", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            return new ElementTag(citizen.hasTrait(SleepingTrait.class) && ((SleepingTrait)citizen.getOrAddTrait(SleepingTrait.class)).isSleeping());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "nickname", (attribute, object) -> new ElementTag(object.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)object.getCitizen().getOrAddTrait(NicknameTrait.class)).getNickname() : object.getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> {
            if (attribute.startsWith("nickname", 2)) {
                Deprecations.npcNicknameTag.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)object.getCitizen().getOrAddTrait(NicknameTrait.class)).getNickname() : object.getName());
            }
            return new ElementTag(object.getName());
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "traits", (attribute, object) -> {
            ArrayList<String> list = new ArrayList<String>();
            for (Trait trait : object.getCitizen().getTraits()) {
                list.add(trait.getName());
            }
            return new ListTag((List<String>)list);
        }, "list_traits");
        tagProcessor.registerTag(ElementTag.class, "has_trait", (attribute, object) -> {
            Class trait;
            if (attribute.hasParam() && (trait = CitizensAPI.getTraitFactory().getTraitClass(attribute.getParam())) != null) {
                return new ElementTag(object.getCitizen().hasTrait(trait));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "pushable", (attribute, object) -> new ElementTag(object.getPushableTrait().isPushable()), "is_pushable");
        tagProcessor.registerTag(ElementTag.class, "has_trigger", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            if (!object.getCitizen().hasTrait(TriggerTrait.class)) {
                return new ElementTag(false);
            }
            TriggerTrait trait = (TriggerTrait)object.getCitizen().getOrAddTrait(TriggerTrait.class);
            return new ElementTag(trait.hasTrigger(attribute.getParam()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_anchors", (attribute, object) -> new ElementTag(((Anchors)object.getCitizen().getOrAddTrait(Anchors.class)).getAnchors().size() > 0), new String[0]);
        tagProcessor.registerTag(ListTag.class, "list_anchors", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Anchor anchor : ((Anchors)object.getCitizen().getOrAddTrait(Anchors.class)).getAnchors()) {
                list.add(anchor.getName());
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "anchor", (attribute, object) -> {
            Anchors trait = (Anchors)object.getCitizen().getOrAddTrait(Anchors.class);
            if (attribute.hasParam()) {
                Anchor anchor = trait.getAnchor(attribute.getParam());
                if (anchor != null) {
                    return new LocationTag(anchor.getLocation());
                }
                attribute.echoError("NPC Anchor '" + attribute.getParam() + "' is not defined.");
                return null;
            }
            if (attribute.startsWith("list", 2)) {
                attribute.fulfill(1);
                Deprecations.npcAnchorListTag.warn(attribute.context);
                ListTag list = new ListTag();
                for (Anchor anchor : trait.getAnchors()) {
                    list.add(anchor.getName());
                }
                return list;
            }
            attribute.echoError("npc.anchor[...] tag must have an input.");
            return null;
        }, "anchors");
        tagProcessor.registerTag(ElementTag.class, "constant", (attribute, object) -> {
            if (attribute.hasParam()) {
                if (object.getCitizen().hasTrait(ConstantsTrait.class) && ((ConstantsTrait)object.getCitizen().getOrAddTrait(ConstantsTrait.class)).getConstant(attribute.getParam()) != null) {
                    return new ElementTag(((ConstantsTrait)object.getCitizen().getOrAddTrait(ConstantsTrait.class)).getConstant(attribute.getParam()));
                }
                return null;
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_pose", (attribute, object) -> {
            if (attribute.hasParam()) {
                return new ElementTag(((Poses)object.getCitizen().getOrAddTrait(Poses.class)).hasPose(attribute.getParam()));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "pose", (attribute, object) -> {
            if (attribute.hasParam()) {
                Pose pose = ((Poses)object.getCitizen().getOrAddTrait(Poses.class)).getPose(attribute.getParam());
                return new LocationTag((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0, pose.getYaw(), pose.getPitch());
            }
            return null;
        }, "get_pose");
        tagProcessor.registerTag(ObjectTag.class, "name_hologram_npc", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(HologramTrait.class)) {
                return null;
            }
            HologramTrait hologram = (HologramTrait)object.getCitizen().getTraitNullable(HologramTrait.class);
            ArmorStand entity = hologram.getNameEntity();
            if (entity == null) {
                return null;
            }
            return new EntityTag((Entity)entity).getDenizenObject();
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "hologram_npcs", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(HologramTrait.class)) {
                return null;
            }
            HologramTrait hologram = (HologramTrait)object.getCitizen().getTraitNullable(HologramTrait.class);
            Collection stands = hologram.getHologramEntities();
            if (stands == null || stands.isEmpty()) {
                return null;
            }
            ListTag output = new ListTag();
            for (ArmorStand stand : stands) {
                output.addObject(new EntityTag((Entity)stand).getDenizenObject());
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "hologram_lines", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(HologramTrait.class)) {
                return null;
            }
            HologramTrait hologram = (HologramTrait)object.getCitizen().getTraitNullable(HologramTrait.class);
            return new ListTag(hologram.getLines());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "hologram_direction", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(HologramTrait.class)) {
                return null;
            }
            HologramTrait hologram = (HologramTrait)object.getCitizen().getTraitNullable(HologramTrait.class);
            return new ElementTag(hologram.getDirection().name());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "hologram_line_height", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(HologramTrait.class)) {
                return null;
            }
            HologramTrait hologram = (HologramTrait)object.getCitizen().getTraitNullable(HologramTrait.class);
            return new ElementTag(hologram.getLineHeight());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_sneaking", (attribute, object) -> {
            if (!object.isSpawned() && object.getEntity() instanceof Player) {
                return null;
            }
            return new ElementTag(((Player)object.getEntity()).isSneaking());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "engaged", (attribute, object) -> new ElementTag(object.isEngaged()), "is_engaged");
        tagProcessor.registerTag(ElementTag.class, "invulnerable", (attribute, object) -> new ElementTag((Boolean)object.getCitizen().data().get("protected", (Object)true)), "vulnerable");
        tagProcessor.registerTag(ElementTag.class, "id", (attribute, object) -> new ElementTag(object.getId()), new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "owner", (attribute, object) -> {
            UUID owner = object.getOwner();
            if (owner == null) {
                return null;
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)owner);
            if (player.hasPlayedBefore()) {
                return new PlayerTag(player);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_skin", (attribute, object) -> new ElementTag(object.getCitizen().hasTrait(SkinTrait.class) && ((SkinTrait)object.getCitizen().getOrAddTrait(SkinTrait.class)).getSkinName() != null), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "skin_blob", (attribute, object) -> {
            if (object.getCitizen().hasTrait(SkinTrait.class)) {
                SkinTrait skin = (SkinTrait)object.getCitizen().getOrAddTrait(SkinTrait.class);
                String tex = skin.getTexture();
                String sign = "";
                if (skin.getSignature() != null) {
                    sign = ";" + skin.getSignature();
                }
                return new ElementTag(tex + sign);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "skull_skin", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(SkinTrait.class)) {
                return null;
            }
            SkinTrait skin = (SkinTrait)object.getCitizen().getOrAddTrait(SkinTrait.class);
            return new ElementTag(skin.getSkinName() + "|" + skin.getTexture());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "skin", (attribute, object) -> {
            if (object.getCitizen().hasTrait(SkinTrait.class)) {
                return new ElementTag(((SkinTrait)object.getCitizen().getOrAddTrait(SkinTrait.class)).getSkinName());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "auto_update_skin", (attribute, object) -> {
            if (object.getCitizen().hasTrait(SkinTrait.class)) {
                return new ElementTag(((SkinTrait)object.getCitizen().getOrAddTrait(SkinTrait.class)).shouldUpdateSkins());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(InventoryTag.class, "inventory", (attribute, object) -> object.getDenizenInventory(), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_spawned", (attribute, object) -> new ElementTag(object.isSpawned()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_protected", (attribute, object) -> new ElementTag(object.getCitizen().isProtected()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "lookclose", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            if (citizen.hasTrait(LookClose.class)) {
                String lookclose = ((LookClose)citizen.getOrAddTrait(LookClose.class)).toString();
                lookclose = lookclose.substring(10, lookclose.length() - 1);
                return new ElementTag(Boolean.valueOf(lookclose));
            }
            return new ElementTag(false);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "controllable", (attribute, object) -> {
            if (object.getCitizen().hasTrait(Controllable.class)) {
                return new ElementTag(((Controllable)object.getCitizen().getOrAddTrait(Controllable.class)).isEnabled());
            }
            return new ElementTag(false);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "targetable", (attribute, object) -> {
            boolean targetable = (Boolean)object.getCitizen().data().get("protected-target", (Object)((Boolean)object.getCitizen().data().get("protected", (Object)true)));
            return new ElementTag(targetable);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "teleport_on_stuck", (attribute, object) -> new ElementTag(object.getNavigator().getDefaultParameters().stuckAction() == TeleportStuckAction.INSTANCE), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_script", (attribute, object) -> {
            Deprecations.hasScriptTags.warn(attribute.context);
            NPC citizen = object.getCitizen();
            return new ElementTag(citizen.hasTrait(AssignmentTrait.class));
        }, new String[0]);
        tagProcessor.registerTag(ScriptTag.class, "script", (attribute, object) -> {
            Deprecations.npcScriptSingle.warn(attribute.context);
            NPC citizen = object.getCitizen();
            if (!citizen.hasTrait(AssignmentTrait.class)) {
                return null;
            }
            for (AssignmentScriptContainer container : ((AssignmentTrait)citizen.getOrAddTrait(AssignmentTrait.class)).containerCache) {
                if (container == null) continue;
                return new ScriptTag(container);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "scripts", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            if (!citizen.hasTrait(AssignmentTrait.class)) {
                return null;
            }
            ListTag result = new ListTag();
            for (AssignmentScriptContainer container : ((AssignmentTrait)citizen.getOrAddTrait(AssignmentTrait.class)).containerCache) {
                if (container == null) continue;
                result.addObject(new ScriptTag(container));
            }
            return result;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "distance_margin", (attribute, object) -> new ElementTag(object.getNavigator().getDefaultParameters().distanceMargin()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "path_distance_margin", (attribute, object) -> new ElementTag(object.getNavigator().getDefaultParameters().pathDistanceMargin()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_navigating", (attribute, object) -> new ElementTag(object.getNavigator().isNavigating()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "speed", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().speed()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "range", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().range()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "attack_range", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().attackRange()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "attack_strategy", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().attackStrategy().toString()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "speed_modifier", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().speedModifier()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "base_speed", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().baseSpeed()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "avoid_water", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().avoidWater()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "target_location", (attribute, object) -> {
            if (object.getNavigator().getTargetAsLocation() == null) {
                return null;
            }
            return new LocationTag(object.getNavigator().getTargetAsLocation());
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "navigator_look_at", (attribute, object) -> {
            if (object.getNavigator().getLocalParameters().lookAtFunction() == null) {
                return null;
            }
            Location res = (Location)object.getNavigator().getLocalParameters().lookAtFunction().apply((Object)object.getNavigator());
            if (res == null) {
                return null;
            }
            return new LocationTag(res);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_fighting", (attribute, object) -> new ElementTag(object.getNavigator().getEntityTarget() != null && object.getNavigator().getEntityTarget().isAggressive()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "target_type", (attribute, object) -> {
            if (object.getNavigator().getTargetType() == null) {
                return null;
            }
            return new ElementTag(object.getNavigator().getTargetType().toString());
        }, new String[0]);
        tagProcessor.registerTag(EntityTag.class, "target_entity", (attribute, object) -> {
            if (object.getNavigator().getEntityTarget() == null || object.getNavigator().getEntityTarget().getTarget() == null) {
                return null;
            }
            return new EntityTag(object.getNavigator().getEntityTarget().getTarget());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "registry_name", (attribute, object) -> new ElementTag(object.getCitizen().getOwningRegistry().getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "citizens_data", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Object val = object.getCitizen().data().get(attribute.getParam());
            if (val == null) {
                return null;
            }
            return new ElementTag(val.toString());
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "citizens_data_keys", (attribute, object) -> {
            MemoryDataKey holder = new MemoryDataKey();
            object.getCitizen().data().saveTo((DataKey)holder);
            ListTag result = new ListTag();
            for (DataKey key : holder.getSubKeys()) {
                result.addObject(new ElementTag(key.name(), true));
            }
            return result;
        }, new String[0]);
        tagProcessor.registerTag(NPCTag.class, "navigator", (attribute, object) -> {
            Deprecations.oldNPCNavigator.warn(attribute.context);
            return object;
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        if (this.getEntity() != null) {
            return new EntityTag(this);
        }
        return new ElementTag(this.identify());
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to an NPC!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Waypoints wp;
        SkinTrait skinTrait;
        HologramTrait hologram;
        Trait trait;
        if (mechanism.matches("set_assignment") && mechanism.requireObject(ScriptTag.class)) {
            trait = (AssignmentTrait)this.getCitizen().getOrAddTrait(AssignmentTrait.class);
            trait.clearAssignments(null);
            trait.addAssignmentScript((AssignmentScriptContainer)mechanism.valueAsType(ScriptTag.class).getContainer(), null);
        }
        if (mechanism.matches("add_assignment") && mechanism.requireObject(ScriptTag.class)) {
            ((AssignmentTrait)this.getCitizen().getOrAddTrait(AssignmentTrait.class)).addAssignmentScript((AssignmentScriptContainer)mechanism.valueAsType(ScriptTag.class).getContainer(), null);
        }
        if (mechanism.matches("remove_assignment") && this.npc.hasTrait(AssignmentTrait.class)) {
            if (mechanism.hasValue()) {
                trait = (AssignmentTrait)this.getCitizen().getOrAddTrait(AssignmentTrait.class);
                trait.removeAssignmentScript(mechanism.getValue().asString(), null);
                trait.checkAutoRemove();
            } else {
                Deprecations.assignmentRemove.warn(mechanism.context);
                ((AssignmentTrait)this.getCitizen().getOrAddTrait(AssignmentTrait.class)).clearAssignments(null);
                this.npc.removeTrait(AssignmentTrait.class);
            }
        }
        if (mechanism.matches("clear_assignments") && this.npc.hasTrait(AssignmentTrait.class)) {
            ((AssignmentTrait)this.getCitizen().getOrAddTrait(AssignmentTrait.class)).clearAssignments(null);
            this.npc.removeTrait(AssignmentTrait.class);
        }
        if (mechanism.matches("hologram_lines") && mechanism.requireObject(ListTag.class)) {
            hologram = (HologramTrait)this.getCitizen().getOrAddTrait(HologramTrait.class);
            hologram.clear();
            for (String str : mechanism.valueAsType(ListTag.class)) {
                hologram.addLine(str);
            }
        }
        if (mechanism.matches("hologram_direction") && mechanism.requireEnum(false, (Enum<?>[])HologramTrait.HologramDirection.values())) {
            hologram = (HologramTrait)this.getCitizen().getOrAddTrait(HologramTrait.class);
            hologram.setDirection(HologramTrait.HologramDirection.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("hologram_line_height") && mechanism.requireDouble()) {
            hologram = (HologramTrait)this.getCitizen().getOrAddTrait(HologramTrait.class);
            hologram.setLineHeight(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("set_nickname")) {
            this.getNicknameTrait().setNickname(mechanism.getValue().asString());
        }
        if (mechanism.matches("remove_nickname")) {
            this.getNicknameTrait().removeNickname();
        }
        if (mechanism.matches("set_entity_type") && mechanism.requireObject(EntityTag.class)) {
            this.getCitizen().setBukkitEntityType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
        }
        if (mechanism.matches("name") || mechanism.matches("set_name")) {
            this.getCitizen().setName(mechanism.getValue().asString().length() > 64 ? mechanism.getValue().asString().substring(0, 64) : mechanism.getValue().asString());
        }
        if (mechanism.matches("owner")) {
            if (PlayerTag.matches(mechanism.getValue().asString())) {
                ((Owner)this.getCitizen().getOrAddTrait(Owner.class)).setOwner((CommandSender)mechanism.valueAsType(PlayerTag.class).getPlayerEntity());
            } else {
                ((Owner)this.getCitizen().getOrAddTrait(Owner.class)).setOwner(mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin_blob")) {
            if (!mechanism.hasValue()) {
                if (this.getCitizen().hasTrait(SkinTrait.class)) {
                    ((SkinTrait)this.getCitizen().getOrAddTrait(SkinTrait.class)).clearTexture();
                    if (this.getCitizen().isSpawned()) {
                        this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                        this.getCitizen().spawn(this.getCitizen().getStoredLocation());
                    }
                }
            } else {
                skinTrait = (SkinTrait)this.getCitizen().getOrAddTrait(SkinTrait.class);
                String[] dat = mechanism.getValue().asString().split(";");
                if (dat.length < 2) {
                    Debug.echoError("Invalid skin_blob input. Must specify texture;signature;name in full.");
                    return;
                }
                skinTrait.setSkinPersistent(dat.length > 2 ? dat[2] : UUID.randomUUID().toString(), dat[1], dat[0]);
                if (this.getCitizen().isSpawned() && this.getCitizen().getEntity() instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.getCitizen().getEntity()).getSkinTracker().notifySkinChange(true);
                }
            }
        }
        if (mechanism.matches("skin")) {
            if (!mechanism.hasValue()) {
                if (this.getCitizen().hasTrait(SkinTrait.class)) {
                    ((SkinTrait)this.getCitizen().getOrAddTrait(SkinTrait.class)).clearTexture();
                }
            } else {
                skinTrait = (SkinTrait)this.getCitizen().getOrAddTrait(SkinTrait.class);
                skinTrait.setSkinName(mechanism.getValue().asString());
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("auto_update_skin") && mechanism.requireBoolean()) {
            ((SkinTrait)this.getCitizen().getOrAddTrait(SkinTrait.class)).setShouldUpdateSkins(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("item_type") && mechanism.requireObject(ItemTag.class)) {
            ItemTag item = mechanism.valueAsType(ItemTag.class);
            Material mat = item.getMaterial().getMaterial();
            switch (this.getEntity().getType()) {
                case DROPPED_ITEM: {
                    ((Item)this.getEntity()).getItemStack().setType(mat);
                    break;
                }
                case ITEM_FRAME: {
                    ((ItemFrame)this.getEntity()).getItem().setType(mat);
                    break;
                }
                case FALLING_BLOCK: {
                    this.getCitizen().data().setPersistent("item-type-id", (Object)mat.name());
                    this.getCitizen().data().setPersistent("item-type-data", (Object)0);
                    break;
                }
                default: {
                    Debug.echoError("NPC is the not an item type!");
                }
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn();
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("spawn")) {
            Deprecations.npcSpawnMechanism.warn(mechanism.context);
            if (mechanism.requireObject("Invalid LocationTag specified. Assuming last known NPC location.", LocationTag.class)) {
                this.getCitizen().spawn((Location)mechanism.valueAsType(LocationTag.class));
            } else {
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().range(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("attack_range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().attackRange((double)mechanism.getValue().asFloat());
        }
        if (mechanism.matches("speed") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().speedModifier(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("despawn")) {
            Deprecations.npcDespawnMech.warn(mechanism.context);
            this.getCitizen().despawn(DespawnReason.PLUGIN);
        }
        if (mechanism.matches("set_sneaking") && mechanism.requireBoolean()) {
            if (!this.getCitizen().hasTrait(SneakingTrait.class)) {
                this.getCitizen().addTrait(SneakingTrait.class);
            }
            if ((trait = (SneakingTrait)this.getCitizen().getOrAddTrait(SneakingTrait.class)).isSneaking() && !mechanism.getValue().asBoolean()) {
                trait.stand();
            } else if (!trait.isSneaking() && mechanism.getValue().asBoolean()) {
                trait.sneak();
            }
        }
        if (mechanism.matches("set_protected") && mechanism.requireBoolean()) {
            this.getCitizen().setProtected(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("lookclose") && mechanism.requireBoolean()) {
            this.getLookCloseTrait().lookClose(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("controllable") && mechanism.requireBoolean()) {
            ((Controllable)this.getCitizen().getOrAddTrait(Controllable.class)).setEnabled(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("targetable") && mechanism.requireBoolean()) {
            this.getCitizen().data().setPersistent("protected-target", (Object)mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("teleport_on_stuck") && mechanism.requireBoolean()) {
            if (mechanism.getValue().asBoolean()) {
                this.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
            } else {
                this.getNavigator().getDefaultParameters().stuckAction(null);
            }
        }
        if ((mechanism.matches("distance_margin") || mechanism.matches("set_distance")) && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().distanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("path_distance_margin") && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().pathDistanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("navigator_look_at")) {
            if (mechanism.hasValue() && mechanism.requireObject(LocationTag.class)) {
                LocationTag loc = mechanism.valueAsType(LocationTag.class);
                this.getNavigator().getLocalParameters().lookAtFunction(n -> loc);
            } else {
                this.getNavigator().getLocalParameters().lookAtFunction(null);
            }
        }
        if (mechanism.matches("name_visible")) {
            this.getCitizen().data().setPersistent("nameplate-visible", (Object)mechanism.getValue().asString());
        }
        if (mechanism.matches("glow_color") && mechanism.requireEnum(false, (Enum<?>[])ChatColor.values())) {
            ((ScoreboardTrait)this.getCitizen().getOrAddTrait(ScoreboardTrait.class)).setColor(ChatColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("clear_waypoints")) {
            wp = (Waypoints)this.getCitizen().getOrAddTrait(Waypoints.class);
            if (wp.getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).clear();
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                List locs = ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres();
                for (Location loc : locs) {
                    locs.remove(loc);
                }
            }
        }
        if (mechanism.matches("add_waypoint") && mechanism.requireObject(LocationTag.class)) {
            wp = (Waypoints)this.getCitizen().getOrAddTrait(Waypoints.class);
            if (wp.getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).add(new Waypoint((Location)mechanism.valueAsType(LocationTag.class)));
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres().add((Location)mechanism.valueAsType(LocationTag.class));
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled() && this.isSpawned()) {
            new EntityTag(this.getEntity()).adjust(mechanism);
        }
    }

    @Override
    public boolean advancedMatches(String matcher) {
        return this.isSpawned() && BukkitScriptEvent.tryEntity(this.getDenizenEntity(), matcher);
    }
}

