/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.plugin.Plugin;

public class CreateWorldCommand
extends AbstractCommand
implements Holdable {
    public static HashSet<String> excludedExtensionsForCopyFrom = new HashSet<String>(Collections.singleton("lock"));
    public static AsciiMatcher forbiddenSymbols = new AsciiMatcher("");

    public CreateWorldCommand() {
        this.setName("createworld");
        this.setSyntax("createworld [<name>] (generator:<id>) (worldtype:<type>) (environment:<environment>) (copy_from:<world>) (seed:<seed>) (settings:<json>)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        if (arg.startsWith("environment:")) {
            for (World.Environment environment : World.Environment.values()) {
                addOne.accept("environment:" + environment);
            }
        }
        if (arg.startsWith("worldtype:")) {
            for (World.Environment environment : WorldType.values()) {
                addOne.accept("worldtype:" + environment);
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("generator") && arg.matchesPrefix("generator", "g")) {
                scriptEntry.addObject("generator", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("worldtype") && arg.matchesPrefix("worldtype") && arg.matchesEnum((Enum<?>[])WorldType.values())) {
                scriptEntry.addObject("worldtype", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("environment") && arg.matchesPrefix("environment") && arg.matchesEnum((Enum<?>[])World.Environment.values())) {
                scriptEntry.addObject("environment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("copy_from") && arg.matchesPrefix("copy_from")) {
                scriptEntry.addObject("copy_from", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("settings") && arg.matchesPrefix("settings")) {
                scriptEntry.addObject("settings", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("seed") && arg.matchesPrefix("seed", "s") && arg.matchesInteger()) {
                scriptEntry.addObject("seed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world_name")) {
                scriptEntry.addObject("world_name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world_name")) {
            throw new InvalidArgumentsException("Must specify a world name.");
        }
        if (!scriptEntry.hasObject("worldtype")) {
            scriptEntry.addObject("worldtype", new ElementTag("NORMAL"));
        }
        scriptEntry.defaultObject("environment", new ElementTag("NORMAL"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag worldName = scriptEntry.getElement("world_name");
        ElementTag generator = scriptEntry.getElement("generator");
        ElementTag worldType = scriptEntry.getElement("worldtype");
        ElementTag environment = scriptEntry.getElement("environment");
        ElementTag copy_from = scriptEntry.getElement("copy_from");
        ElementTag settings = scriptEntry.getElement("settings");
        ElementTag seed = scriptEntry.getElement("seed");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), worldName, generator, environment, copy_from, settings, worldType, seed);
        }
        if (Bukkit.getWorld((String)worldName.asString()) != null) {
            Debug.echoDebug((Debuggable)scriptEntry, "CreateWorld doing nothing, world by that name already loaded.");
            scriptEntry.setFinished(true);
            return;
        }
        if (!Settings.cache_createWorldSymbols && forbiddenSymbols.containsAnyMatch(worldName.asString())) {
            Debug.echoError("Cannot use world names with non-alphanumeric symbols due to security settings in Denizen/config.yml.");
            scriptEntry.setFinished(true);
            return;
        }
        File newFolder = new File(Bukkit.getWorldContainer(), worldName.asString());
        if (!Utilities.canWriteToFile(newFolder)) {
            Debug.echoError("Cannot copy to that new folder path due to security settings in Denizen/config.yml.");
            scriptEntry.setFinished(true);
            return;
        }
        Supplier<Boolean> copyRunnable = () -> {
            try {
                File file2;
                if (!Settings.cache_createWorldSymbols && forbiddenSymbols.containsAnyMatch(copy_from.asString())) {
                    Debug.echoError("Cannot use copy_from world names with non-alphanumeric symbols due to security settings in Denizen/config.yml.");
                    return false;
                }
                File folder = new File(Bukkit.getWorldContainer(), copy_from.asString().replace("w@", ""));
                if (!Utilities.canReadFile(folder)) {
                    Debug.echoError("Cannot copy from that folder path due to security settings in Denizen/config.yml.");
                    return false;
                }
                if (!folder.exists() || !folder.isDirectory()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid copy from world folder - does not exist!");
                    return false;
                }
                if (newFolder.exists()) {
                    Debug.echoError("Cannot copy to new world - that folder already exists.");
                    return false;
                }
                CoreUtilities.copyDirectory(folder, newFolder, excludedExtensionsForCopyFrom);
                Debug.echoDebug((Debuggable)scriptEntry, "Copied " + folder.getName() + " to " + newFolder.getName());
                File file = new File(Bukkit.getWorldContainer(), worldName.asString() + "/uid.dat");
                if (file.exists()) {
                    file.delete();
                }
                if ((file2 = new File(Bukkit.getWorldContainer(), worldName.asString() + "/session.lock")).exists()) {
                    file2.delete();
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
                return false;
            }
            return true;
        };
        Runnable createRunnable = () -> {
            World world;
            WorldCreator worldCreator = WorldCreator.name((String)worldName.asString()).environment(World.Environment.valueOf((String)environment.asString().toUpperCase())).type(WorldType.valueOf((String)worldType.asString().toUpperCase()));
            if (generator != null) {
                worldCreator.generator(generator.asString());
            }
            if (seed != null) {
                worldCreator.seed(seed.asLong());
            }
            if (settings != null) {
                worldCreator.generatorSettings(settings.asString());
            }
            if ((world = Bukkit.getServer().createWorld(worldCreator)) == null) {
                Debug.echoError("World is null, something went wrong in creation!");
            } else {
                Debug.echoDebug((Debuggable)scriptEntry, "Created new world " + world.getName());
            }
            scriptEntry.setFinished(true);
        };
        if (scriptEntry.shouldWaitFor() && copy_from != null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Denizen.getInstance(), () -> {
                if (!((Boolean)copyRunnable.get()).booleanValue()) {
                    scriptEntry.setFinished(true);
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), createRunnable);
            });
        } else {
            if (copy_from != null && !copyRunnable.get().booleanValue()) {
                return;
            }
            createRunnable.run();
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CreateWorldCommand.forbiddenSymbols.accepted[i] = !(i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 95 || i == 45 || i == 32);
        }
    }
}

