/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.Set;
import org.bukkit.block.data.type.BrewingStand;

public class MaterialBrewingStand
implements Property {
    public static final String[] handledMechs = new String[]{"bottles"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof BrewingStand;
    }

    public static MaterialBrewingStand getFrom(ObjectTag _material) {
        if (!MaterialBrewingStand.describes(_material)) {
            return null;
        }
        return new MaterialBrewingStand((MaterialTag)_material);
    }

    private MaterialBrewingStand(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ListTag.class, "bottles", (attribute, material) -> material.getBottleBooleans(), new String[0]);
    }

    public BrewingStand getBrewingStand() {
        return (BrewingStand)this.material.getModernData();
    }

    public int getMaxBottles() {
        return this.getBrewingStand().getMaximumBottles();
    }

    public Set<Integer> getBottles() {
        return this.getBrewingStand().getBottles();
    }

    public ListTag getBottleBooleans() {
        ListTag result = new ListTag();
        for (int i = 0; i < this.getMaxBottles(); ++i) {
            result.addObject(new ElementTag(this.hasBottle(i)));
        }
        return result;
    }

    public boolean hasBottle(int index) {
        return this.getBrewingStand().hasBottle(index);
    }

    public void setBottle(int index, boolean hasBottle) {
        this.getBrewingStand().setBottle(index, hasBottle);
    }

    public void resetBottles() {
        for (int i : this.getBottles()) {
            this.setBottle(i, false);
        }
    }

    @Override
    public String getPropertyString() {
        return this.getBottleBooleans().identify();
    }

    @Override
    public String getPropertyId() {
        return "bottles";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("bottles")) {
            ListTag bottles = mechanism.valueAsType(ListTag.class);
            if (bottles.size() > this.getMaxBottles()) {
                mechanism.echoError("Too many values specified! Brewing stand has a maximum of " + this.getMaxBottles() + " bottles.");
                return;
            }
            this.resetBottles();
            for (int i = 0; i < bottles.size(); ++i) {
                this.setBottle(i, new ElementTag(bottles.get(i)).asBoolean());
            }
        }
    }
}

