/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;

public class EntityCannotEnterHive
implements Property {
    public static final String[] handledTags = new String[]{"cannot_enter_hive"};
    public static final String[] handledMechs = new String[]{"cannot_enter_hive"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof Bee;
    }

    public static EntityCannotEnterHive getFrom(ObjectTag entity) {
        if (!EntityCannotEnterHive.describes(entity)) {
            return null;
        }
        return new EntityCannotEnterHive((EntityTag)entity);
    }

    private EntityCannotEnterHive(EntityTag entity) {
        this.entity = entity;
    }

    public Bee getBee() {
        return (Bee)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        return new DurationTag((long)this.getBee().getCannotEnterHiveTicks()).identify();
    }

    @Override
    public String getPropertyId() {
        return "flower";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("cannot_enter_hive")) {
            return new DurationTag((long)this.getBee().getCannotEnterHiveTicks()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("cannot_enter_hive") && mechanism.requireObject(DurationTag.class)) {
            this.getBee().setCannotEnterHiveTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
    }
}

