/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.block.data.type.Cake;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.block.data.type.Snow;

public class MaterialLevel
implements Property {
    public static final String[] handledMechs = new String[]{"level"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Levelled || data instanceof Cake || data instanceof Snow || data instanceof Farmland || data instanceof Beehive;
    }

    public static MaterialLevel getFrom(ObjectTag _material) {
        if (!MaterialLevel.describes(_material)) {
            return null;
        }
        return new MaterialLevel((MaterialTag)_material);
    }

    private MaterialLevel(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "maximum_level", (attribute, material) -> new ElementTag(material.getMax()), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "minimum_level", (attribute, material) -> new ElementTag(material.getMin()), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "level", (attribute, material) -> new ElementTag(material.getCurrent()), new String[0]);
    }

    public Levelled getLevelled() {
        return (Levelled)this.material.getModernData();
    }

    public boolean isCake() {
        return this.material.getModernData() instanceof Cake;
    }

    public Cake getCake() {
        return (Cake)this.material.getModernData();
    }

    public boolean isSnow() {
        return this.material.getModernData() instanceof Snow;
    }

    public Snow getSnow() {
        return (Snow)this.material.getModernData();
    }

    public boolean isHive() {
        return this.material.getModernData() instanceof Beehive;
    }

    public Beehive getHive() {
        return (Beehive)this.material.getModernData();
    }

    public boolean isFarmland() {
        return this.material.getModernData() instanceof Farmland;
    }

    public Farmland getFarmland() {
        return (Farmland)this.material.getModernData();
    }

    public int getCurrent() {
        if (this.isCake()) {
            return this.getCake().getBites();
        }
        if (this.isSnow()) {
            return this.getSnow().getLayers();
        }
        if (this.isHive()) {
            return this.getHive().getHoneyLevel();
        }
        if (this.isFarmland()) {
            return this.getFarmland().getMoisture();
        }
        return this.getLevelled().getLevel();
    }

    public int getMax() {
        if (this.isCake()) {
            return this.getCake().getMaximumBites();
        }
        if (this.isSnow()) {
            return this.getSnow().getMaximumLayers();
        }
        if (this.isHive()) {
            return this.getHive().getMaximumHoneyLevel();
        }
        if (this.isFarmland()) {
            return this.getFarmland().getMaximumMoisture();
        }
        return this.getLevelled().getMaximumLevel();
    }

    public int getMin() {
        if (this.isSnow()) {
            return this.getSnow().getMinimumLayers();
        }
        return 0;
    }

    public void setCurrent(int level) {
        if (this.isCake()) {
            this.getCake().setBites(level);
            return;
        }
        if (this.isSnow()) {
            this.getSnow().setLayers(level);
            return;
        }
        if (this.isHive()) {
            this.getHive().setHoneyLevel(level);
            return;
        }
        if (this.isFarmland()) {
            this.getFarmland().setMoisture(level);
            return;
        }
        this.getLevelled().setLevel(level);
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "level";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            int level = mechanism.getValue().asInt();
            if (level < this.getMin() || level > this.getMax()) {
                mechanism.echoError("Level value '" + level + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + " for material '" + this.material.name() + "'.");
                return;
            }
            this.setCurrent(level);
        }
    }
}

