/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCommand {
    public static HashSet<String> noErrorCommandNames = new HashSet<String>(Arrays.asList("case", "default"));
    public String syntax = "No usage defined! See documentation for more information!";
    public List<String> docFlagArgs = new ArrayList<String>();
    public List<String> docPrefixes = new ArrayList<String>();
    private boolean preparseArgs = true;
    public boolean forceHold = false;
    public int minimumArguments = 0;
    public int maximumArguments = Integer.MAX_VALUE;
    public HashSet<String> prefixesHandled = new HashSet();
    public HashSet<String> rawValuesHandled = new HashSet();
    public HashMap<String, String> prefixRemapper = new HashMap();
    public boolean allowedDynamicPrefixes = false;
    public boolean anyPrefixSymbolAllowed = false;
    public boolean isProcedural = false;
    protected String name;

    public void setSyntax(String syntax) {
        this.syntax = syntax;
        int firstSpace = syntax.indexOf(32);
        if (firstSpace < 0) {
            return;
        }
        String cleaned = syntax.substring(firstSpace).replace("/", " ");
        cleaned = cleaned.replace("[", "").replace("]", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "");
        List<String> args = CoreUtilities.split(cleaned, ' ');
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            int colonIndex = arg.indexOf(58);
            if (colonIndex > 0) {
                String prefix = arg.substring(0, colonIndex);
                if (prefix.contains("<")) continue;
                this.docPrefixes.add(prefix);
                continue;
            }
            if (arg.contains("<") || arg.contains("|")) continue;
            this.docFlagArgs.add(arg);
        }
        if (Debug.verbose) {
            Debug.log("Command syntax '" + syntax + "' parsed to flat args: ( " + String.join((CharSequence)", ", this.docFlagArgs) + " ) and prefixes ( " + String.join((CharSequence)", ", this.docPrefixes) + " ).");
        }
    }

    public void addCustomTabCompletions(TabCompletionsBuilder tab) {
    }

    public void addRemappedPrefixes(String realName, String ... alts) {
        this.prefixesHandled.add(realName);
        this.prefixesHandled.addAll(Arrays.asList(alts));
        for (String alt : alts) {
            this.prefixRemapper.put(alt, realName);
        }
    }

    public void setPrefixesHandled(String ... prefixes) {
        this.prefixesHandled.addAll(Arrays.asList(prefixes));
    }

    public void setRawValuesHandled(String ... values) {
        this.rawValuesHandled.addAll(Arrays.asList(values));
    }

    public void setBooleansHandled(String ... boolNames) {
        this.setPrefixesHandled(boolNames);
        this.setRawValuesHandled(boolNames);
    }

    public static String db(String prefix, boolean value) {
        return "<G>" + prefix + "='<Y>" + value + "<G>'  ";
    }

    public static String db(String prefix, Object value) {
        if (value == null) {
            return "";
        }
        return ArgumentHelper.debugObj(prefix, value);
    }

    public void setRequiredArguments(int min, int max) {
        this.minimumArguments = min;
        this.maximumArguments = max == -1 ? Integer.MAX_VALUE : max;
    }

    public void setParseArgs(boolean parse) {
        this.preparseArgs = parse;
    }

    public boolean shouldPreParse() {
        return this.preparseArgs;
    }

    public void setName(String commandName) {
        this.name = commandName.toUpperCase();
    }

    public String getName() {
        return this.name;
    }

    public String getUsageHint() {
        return this.syntax;
    }

    public void onDisable() {
    }

    @Deprecated
    public void withOptions(String usageHint, int numberOfRequiredArgs) {
        this.minimumArguments = numberOfRequiredArgs;
        this.setSyntax(usageHint);
    }

    public abstract void execute(ScriptEntry var1);

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            arg.reportUnhandled();
        }
    }

    public static class TabCompletionsBuilder {
        public String arg;
        public ArrayList<String> completions = new ArrayList();

        public final void addWithPrefix(String prefix, Set<String> values) {
            if (this.arg.startsWith(prefix)) {
                for (String val : values) {
                    this.add(prefix + val);
                }
            }
        }

        public final void addWithPrefix(String prefix, Enum<?>[] values) {
            if (this.arg.startsWith(prefix)) {
                for (Enum<?> val : values) {
                    this.add(prefix + val.name());
                }
            }
        }

        public final void add(String text) {
            if (CoreUtilities.toLowerCase(text).startsWith(this.arg)) {
                this.completions.add(text);
            }
        }

        public final void add(String a, String ... values) {
            this.add(a);
            for (String val : values) {
                this.add(val);
            }
        }

        public final void add(Set<String> values) {
            for (String val : values) {
                this.add(val);
            }
        }

        public final void add(Enum<?>[] values) {
            for (Enum<?> val : values) {
                this.add(val.name());
            }
        }

        public final void addNotesOfType(Class<? extends Notable> type) {
            for (Notable note : NoteManager.notesByType.get(type)) {
                this.add(NoteManager.getSavedId(note));
            }
        }

        public final void addScriptsOfType(Class<? extends ScriptContainer> type) {
            for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
                if (!type.isAssignableFrom(script.getClass())) continue;
                this.add(script.getName());
            }
        }
    }
}

