/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class PlayerChangesWorldScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerChangesWorldScriptEvent instance;
    public WorldTag origin_world;
    public WorldTag destination_world;
    public PlayerChangedWorldEvent event;

    public PlayerChangesWorldScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player changes world");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String[] data = path.eventArgsLower;
        for (int index = 3; index < data.length; ++index) {
            if (!(data[index].equals("from") ? !PlayerChangesWorldScriptEvent.tryWorld(this.origin_world, data[index + 1]) : data[index].equals("to") && !PlayerChangesWorldScriptEvent.tryWorld(this.destination_world, data[index + 1]))) continue;
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerChangesWorld";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("origin_world")) {
            return this.origin_world;
        }
        if (name.equals("destination_world")) {
            return this.destination_world;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerChangesWorld(PlayerChangedWorldEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.origin_world = new WorldTag(event.getFrom());
        this.destination_world = new WorldTag(event.getPlayer().getWorld());
        this.event = event;
        this.fire((Event)event);
    }
}

