/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SidebarCommand
extends AbstractCommand {
    private static final Map<UUID, Sidebar> sidebars = new HashMap<UUID, Sidebar>();

    public SidebarCommand() {
        this.setName("sidebar");
        this.setSyntax("sidebar (add/remove/{set}/set_line) (title:<title>) (scores:<#>|...) (values:<line>|...) (start:<#>/{num_of_lines}) (increment:<#>/{-1}) (players:<player>|...) (per_player)");
        this.setRequiredArguments(1, 8);
        this.setParseArgs(false);
        Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)new SidebarEvents(), (Plugin)Denizen.getInstance());
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.SET;
        for (Argument arg : ArgumentHelper.interpret(scriptEntry, scriptEntry.getOriginalArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                action = Action.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "t", "objective", "obj", "o")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("scores") && arg.matchesPrefix("scores", "score", "lines", "line", "l")) {
                scriptEntry.addObject("scores", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("value", "values", "val", "v")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("increment") && arg.matchesPrefix("increment", "inc", "i")) {
                scriptEntry.addObject("increment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("start") && arg.matchesPrefix("start", "s")) {
                scriptEntry.addObject("start", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("players", "player", "p")) {
                scriptEntry.addObject("players", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("per_player") && arg.matches("per_player")) {
                scriptEntry.addObject("per_player", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (action == Action.ADD && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) for that action!");
        }
        if (!(action != Action.SET || scriptEntry.hasObject("value") || scriptEntry.hasObject("title") || scriptEntry.hasObject("increment") || scriptEntry.hasObject("start"))) {
            throw new InvalidArgumentsException("Must specify at least one of: value(s), title, increment, or start for that action!");
        }
        if (action == Action.SET && scriptEntry.hasObject("scores") && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) when setting scores!");
        }
        scriptEntry.addObject("action", new ElementTag(action.name()));
        scriptEntry.defaultObject("per_player", new ElementTag(false));
        scriptEntry.defaultObject("players", new ElementTag(Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).identify() : "li@"));
    }

    public static boolean hasScoreAlready(List<Sidebar.SidebarLine> lines, int score) {
        for (Sidebar.SidebarLine line : lines) {
            if (line.score != score) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(ScriptEntry scriptEntry) {
        action = scriptEntry.getElement("action");
        elTitle = scriptEntry.getElement("title");
        elScores = scriptEntry.getElement("scores");
        elValue = scriptEntry.getElement("value");
        elIncrement = scriptEntry.getElement("increment");
        elStart = scriptEntry.getElement("start");
        elPlayers = scriptEntry.getElement("players");
        elPerPlayer = scriptEntry.getElement("per_player");
        players = ListTag.valueOf(TagManager.tag(elPlayers.asString(), scriptEntry.getContext()), scriptEntry.getContext());
        per_player = elPerPlayer.asBoolean();
        perTitle = null;
        perScores = null;
        perValue = null;
        perIncrement = null;
        perStart = null;
        title = null;
        scores = null;
        value = null;
        increment = null;
        start = null;
        if (per_player) {
            if (elTitle != null) {
                perTitle = elTitle.asString();
            }
            if (elScores != null) {
                perScores = elScores.asString();
            }
            if (elValue != null) {
                perValue = elValue.asString();
            }
            if (elIncrement != null) {
                perIncrement = elIncrement.asString();
            }
            if (elStart != null) {
                perStart = elStart.asString();
            }
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), new Object[]{action, elTitle, elScores, elValue, elIncrement, elStart, SidebarCommand.db("players", players)});
            }
        } else {
            context = (BukkitTagContext)scriptEntry.getContext();
            if (elTitle != null) {
                title = new ElementTag(TagManager.tag(elTitle.asString(), context));
            }
            if (elScores != null) {
                scores = ListTag.getListFor(TagManager.tagObject(elScores.asString(), context), context);
            }
            if (elValue != null) {
                value = ListTag.getListFor(TagManager.tagObject(elValue.asString(), context), context);
            }
            if (elIncrement != null) {
                increment = new ElementTag(TagManager.tag(elIncrement.asString(), context));
            }
            if (elStart != null) {
                start = new ElementTag(TagManager.tag(elStart.asString(), context));
            }
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), new Object[]{action, title, scores, value, increment, start, SidebarCommand.db("players", players)});
            }
        }
        switch (1.$SwitchMap$com$denizenscript$denizen$scripts$commands$player$SidebarCommand$Action[Action.valueOf(action.asString()).ordinal()]) {
            case 1: {
                for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        Debug.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        value = ListTag.getListFor(TagManager.tagObject(perValue, context), context);
                        if (perScores != null) {
                            scores = ListTag.getListFor(TagManager.tagObject(perScores, context), context);
                        }
                    }
                    try {
                        index = start != null ? start.asInt() : (current.size() > 0 ? current.get((int)(current.size() - 1)).score : value.size());
                        incr = increment != null ? increment.asInt() : -1;
                        i = 0;
                        while (i < value.size()) {
                            v0 = score = scores != null && i < scores.size() ? Integer.valueOf(scores.get(i)) : index;
                            while (SidebarCommand.hasScoreAlready(current, score)) {
                                score += incr == 0 ? 1 : incr;
                            }
                            current.add(new Sidebar.SidebarLine(value.get(i), score));
                            ++i;
                            index += incr;
                        }
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                        continue;
                    }
                    sidebar.setLines(current);
                    sidebar.sendUpdate();
                }
                break;
            }
            case 2: {
                for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        Debug.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = ListTag.getListFor(TagManager.tagObject(perValue, context), context);
                        }
                        if (perScores != null) {
                            scores = ListTag.getListFor(TagManager.tagObject(perScores, context), context);
                        }
                    }
                    removedAny = false;
                    if (scores != null) {
                        try {
                            for (String scoreString : scores) {
                                score = Integer.valueOf(scoreString);
                                for (i = 0; i < current.size(); ++i) {
                                    if (current.get((int)i).score != score) continue;
                                    current.remove(i--);
                                }
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        removedAny = true;
                    }
                    if (value != null) {
                        for (String line : value) {
                            for (i = 0; i < current.size(); ++i) {
                                if (!current.get((int)i).text.equalsIgnoreCase(line)) continue;
                                current.remove(i--);
                            }
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        removedAny = true;
                    }
                    if (removedAny) continue;
                    sidebar.remove();
                    SidebarCommand.sidebars.remove(player.getPlayerEntity().getUniqueId());
                }
                break;
            }
            case 3: {
                for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        Debug.echoError("Invalid player!");
                        continue;
                    }
                    if ((scores == null || scores.isEmpty()) && perScores == null) {
                        Debug.echoError("Missing or invalid 'scores' parameter.");
                        return;
                    }
                    if ((value == null || value.size() != scores.size()) && perValue == null) {
                        Debug.echoError("Missing or invalid 'values' parameter.");
                        return;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = ListTag.getListFor(TagManager.tagObject(perValue, context), context);
                        }
                        if (perScores != null) {
                            scores = ListTag.getListFor(TagManager.tagObject(perScores, context), context);
                        }
                    }
lbl153:
                    // 6 sources

                    try {
                        block23: for (i = 0; i < value.size(); ++i) {
                            if (!ArgumentHelper.matchesInteger(scores.get(i))) {
                                Debug.echoError("Sidebar command scores input contains not-a-valid-number: " + scores.get(i));
                                return;
                            }
                            score = Integer.parseInt(scores.get(i));
                            if (!SidebarCommand.hasScoreAlready(current, score)) ** GOTO lbl165
                            for (Sidebar.SidebarLine line : current) {
                                if (line.score != score) continue;
                                line.text = value.get(i);
                                continue block23;
                            }
                            ** GOTO lbl153
lbl165:
                            // 1 sources

                            current.add(new Sidebar.SidebarLine(value.get(i), score));
                        }
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                        continue;
                    }
                    sidebar.setLines(current);
                    sidebar.sendUpdate();
                }
                break;
            }
            case 4: {
                for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        Debug.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = new ArrayList<Sidebar.SidebarLine>();
                    if (per_player) {
                        context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = ListTag.getListFor(TagManager.tagObject(perValue, context), context);
                        }
                        if (perScores != null) {
                            scores = ListTag.getListFor(TagManager.tagObject(perScores, context), context);
                        }
                        if (perStart != null) {
                            start = new ElementTag(TagManager.tag(perStart, context));
                        }
                        if (perIncrement != null) {
                            increment = new ElementTag(TagManager.tag(perIncrement, context));
                        }
                        if (perTitle != null) {
                            title = new ElementTag(TagManager.tag(perTitle, context));
                        }
                    }
                    if (value != null) {
                        try {
                            index = start != null ? start.asInt() : value.size();
                            incr = increment != null ? increment.asInt() : -1;
                            i = 0;
                            while (i < value.size()) {
                                score = scores != null && i < scores.size() ? Integer.valueOf(scores.get(i)) : index;
                                current.add(new Sidebar.SidebarLine(value.get(i), score));
                                ++i;
                                index += incr;
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                    }
                    if (title != null) {
                        sidebar.setTitle(title.asString());
                    }
                    sidebar.sendUpdate();
                }
                break;
            }
        }
    }

    private static Sidebar createSidebar(PlayerTag denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        Player player = denizenPlayer.getPlayerEntity();
        UUID uuid = player.getUniqueId();
        if (!sidebars.containsKey(uuid)) {
            sidebars.put(uuid, NMSHandler.instance.createSidebar(player));
        }
        return sidebars.get(player.getUniqueId());
    }

    public static Sidebar getSidebar(PlayerTag denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        return sidebars.get(denizenPlayer.getPlayerEntity().getUniqueId());
    }

    public static class SidebarEvents
    implements Listener {
        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            sidebars.remove(uuid);
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET,
        SET_LINE;

    }
}

