/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.Deprecations;

public class ItemScript
implements Property {
    public static final String[] handledTags = new String[]{"has_script", "scriptname", "script"};
    public static final String[] handledMechs = new String[]{"script"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemScript getFrom(ObjectTag _item) {
        if (!ItemScript.describes(_item)) {
            return null;
        }
        return new ItemScript((ItemTag)_item);
    }

    private ItemScript(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        ItemScriptContainer container;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_script")) {
            Deprecations.hasScriptTags.warn(attribute.context);
            return new ElementTag(this.item.isItemscript()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("scriptname")) {
            Deprecations.hasScriptTags.warn(attribute.context);
            if (this.item.isItemscript()) {
                return new ElementTag(this.item.getScriptName()).getObjectAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("script") && (container = ItemScriptHelper.getItemScriptContainer(this.item.getItemStack())) != null) {
            return new ScriptTag(container).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        return this.item.getScriptName();
    }

    @Override
    public String getPropertyId() {
        return "script";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("script") && mechanism.requireObject(ScriptTag.class)) {
            ScriptTag script = mechanism.valueAsType(ScriptTag.class);
            if (script.getContainer() instanceof ItemScriptContainer) {
                this.item.setItemScript((ItemScriptContainer)script.getContainer());
            } else {
                mechanism.echoError("Script '" + script.getName() + "' is not an item script (but was specified as one).");
            }
        }
    }
}

