/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ReflectionHelper {
    private static final Map<Class, CheckingFieldMap> cachedFields = new HashMap<Class, CheckingFieldMap>();
    private static final Map<Class, Map<String, MethodHandle>> cachedFieldSetters = new HashMap<Class, Map<String, MethodHandle>>();
    private static Method ADD_OPENS;
    private static Method GET_MODULE;
    private static MethodHandles.Lookup LOOKUP;
    private static Field MODIFIERS_FIELD;
    private static Object UNSAFE;
    private static MethodHandle UNSAFE_FIELD_OFFSET;
    private static MethodHandle UNSAFE_PUT_OBJECT;
    private static MethodHandle UNSAFE_PUT_FLOAT;
    private static MethodHandle UNSAFE_PUT_DOUBLE;
    private static MethodHandle UNSAFE_PUT_INT;
    private static MethodHandle UNSAFE_PUT_LONG;
    private static MethodHandle UNSAFE_PUT_BOOL;
    private static MethodHandle UNSAFE_STATIC_FIELD_OFFSET;

    public static void setFieldValue(Class clazz, String fieldName, Object object, Object value) {
        try {
            ReflectionHelper.getFields(clazz).get(fieldName).set(object, value);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public static <T> T getFieldValue(Class clazz, String fieldName, Object object) {
        CheckingFieldMap cache = ReflectionHelper.getFields(clazz);
        try {
            Field field = (Field)cache.get(fieldName);
            if (field == null) {
                return null;
            }
            return (T)field.get(object);
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static CheckingFieldMap getFields(Class clazz) {
        CheckingFieldMap fields = cachedFields.get(clazz);
        if (fields != null) {
            return fields;
        }
        fields = new CheckingFieldMap(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            fields.put(field.getName(), field);
        }
        cachedFields.put(clazz, fields);
        return fields;
    }

    public static Method getMethod(Class<?> clazz, String method, Class<?> ... params) {
        Method f;
        block5: {
            f = null;
            try {
                if (method == null) {
                    for (Method possible : clazz.getDeclaredMethods()) {
                        if (possible.getParameterCount() != params.length || !Arrays.equals(possible.getParameterTypes(), params)) continue;
                        f = possible;
                        break block5;
                    }
                    break block5;
                }
                f = clazz.getDeclaredMethod(method, params);
                f.setAccessible(true);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
        }
        if (f == null) {
            String err = "Reflection method missing - Tried to read method '" + method + "' of class '" + clazz.getCanonicalName() + "'.";
            System.err.println("[Denizen] [ReflectionHelper]: " + err);
            Debug.echoError(err);
        }
        return f;
    }

    public static MethodHandle getConstructor(Class<?> clazz, Class<?> ... params) {
        try {
            Constructor<?> ctor = clazz.getDeclaredConstructor(params);
            ctor.setAccessible(true);
            MethodHandle result = LOOKUP.unreflectConstructor(ctor);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        String err = "[ReflectionHelper]: Cannot find constructor for class '" + clazz.getCanonicalName() + "' with params: [" + Arrays.stream(params).map(Class::getCanonicalName).collect(Collectors.joining(", ")) + "]";
        System.err.println("[Denizen] " + err);
        Debug.echoError(err);
        return null;
    }

    public static MethodHandle getMethodHandle(Class<?> clazz, String method, Class<?> ... params) {
        try {
            return LOOKUP.unreflect(ReflectionHelper.getMethod(clazz, method, params));
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static MethodHandle getFinalSetterForFirstOfType(Class<?> clazz, Class<?> fieldType) {
        Field field = ReflectionHelper.getFields(clazz).getFirstOfType(fieldType);
        if (field == null) {
            return null;
        }
        return ReflectionHelper.getFinalSetter(clazz, field.getName());
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String field) {
        return ReflectionHelper.getFinalSetter(clazz, field, null);
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String field, Class expected) {
        Map map = cachedFieldSetters.computeIfAbsent(clazz, k -> new HashMap());
        MethodHandle result = (MethodHandle)map.get(field);
        if (result != null) {
            return result;
        }
        Field f = ReflectionHelper.getFields(clazz).get(field);
        if (f == null) {
            Debug.echoError("Create get final setter for unknown field '" + field + "' (for class '" + clazz.getName() + "')");
            return null;
        }
        if (expected != null && f.getType() != expected) {
            Debug.echoError("[ReflectionHelper] field type mismatch in getFinalSetter: field '" + field + "' in class '" + clazz.getName() + "' returns type '" + f.getType().getCanonicalName() + "' but expected '" + expected.getCanonicalName() + "'");
        }
        int mod = f.getModifiers();
        try {
            if (MODIFIERS_FIELD == null) {
                ReflectionHelper.validateUnsafe();
                boolean isStatic = Modifier.isStatic(mod);
                long offset = (Long)(isStatic ? UNSAFE_STATIC_FIELD_OFFSET.invoke(f) : UNSAFE_FIELD_OFFSET.invoke(f));
                MethodHandle method = UNSAFE_PUT_OBJECT;
                if (f.getType().isPrimitive()) {
                    if (f.getType() == Float.TYPE) {
                        method = UNSAFE_PUT_FLOAT;
                    } else if (f.getType() == Double.TYPE) {
                        method = UNSAFE_PUT_DOUBLE;
                    } else if (f.getType() == Integer.TYPE) {
                        method = UNSAFE_PUT_INT;
                    } else if (f.getType() == Long.TYPE) {
                        method = UNSAFE_PUT_LONG;
                    } else if (f.getType() == Boolean.TYPE) {
                        method = UNSAFE_PUT_BOOL;
                    } else {
                        Debug.echoError("Cannot create a setter for primitive type '" + f.getType().getName() + "'");
                        return null;
                    }
                }
                result = isStatic ? MethodHandles.insertArguments(method, 0, clazz, offset) : MethodHandles.insertArguments(method, 1, offset);
            } else {
                if (Modifier.isFinal(mod)) {
                    MODIFIERS_FIELD.setInt(f, mod & 0xFFFFFFEF);
                }
                result = LOOKUP.unreflectSetter(f);
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
        if (result == null) {
            return null;
        }
        cachedFieldSetters.get(clazz).put(field, result);
        return result;
    }

    private static void validateUnsafe() {
        if (UNSAFE == null) {
            try {
                UNSAFE = ReflectionHelper.getFields(Class.forName("sun.misc.Unsafe")).get("theUnsafe").get(null);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            UNSAFE_STATIC_FIELD_OFFSET = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "staticFieldOffset", Field.class).bindTo(UNSAFE);
            UNSAFE_FIELD_OFFSET = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "objectFieldOffset", Field.class).bindTo(UNSAFE);
            UNSAFE_PUT_OBJECT = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putObject", Object.class, Long.TYPE, Object.class).bindTo(UNSAFE);
            UNSAFE_PUT_FLOAT = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putFloat", Object.class, Long.TYPE, Float.TYPE).bindTo(UNSAFE);
            UNSAFE_PUT_DOUBLE = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putDouble", Object.class, Long.TYPE, Double.TYPE).bindTo(UNSAFE);
            UNSAFE_PUT_INT = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putInt", Object.class, Long.TYPE, Integer.TYPE).bindTo(UNSAFE);
            UNSAFE_PUT_LONG = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putLong", Object.class, Long.TYPE, Long.TYPE).bindTo(UNSAFE);
            UNSAFE_PUT_BOOL = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putBoolean", Object.class, Long.TYPE, Boolean.TYPE).bindTo(UNSAFE);
        }
    }

    public static void giveReflectiveAccess(Class<?> from, Class<?> to) {
        try {
            if (GET_MODULE == null) {
                Class<?> module = Class.forName("java.lang.Module");
                GET_MODULE = Class.class.getMethod("getModule", new Class[0]);
                ADD_OPENS = module.getMethod("addOpens", String.class, module);
            }
            ADD_OPENS.invoke(GET_MODULE.invoke(from, new Object[0]), from.getPackage().getName(), GET_MODULE.invoke(to, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        ReflectionHelper.giveReflectiveAccess(Field.class, ReflectionHelper.class);
        MODIFIERS_FIELD = ReflectionHelper.getFields(Field.class).getNoCheck("modifiers");
        LOOKUP = MethodHandles.lookup();
    }

    public static class CheckingFieldMap
    extends HashMap<String, Field> {
        public Class<?> clazz;

        public CheckingFieldMap(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Field getFirstOfType(Class fieldClazz) {
            for (Field f : super.values()) {
                if (!f.getType().equals(fieldClazz)) continue;
                return f;
            }
            String err = "Reflection field missing - Tried to find field of type '" + fieldClazz.getCanonicalName() + "' of class '" + this.clazz.getCanonicalName() + "'.";
            System.err.println("[Denizen] [ReflectionHelper]: " + err);
            Debug.echoError(err);
            return null;
        }

        @Override
        public Field get(Object name) {
            Field f = (Field)super.get(name);
            if (f == null) {
                String err = "Reflection field missing - Tried to read field '" + name + "' of class '" + this.clazz.getCanonicalName() + "'.";
                System.err.println("[Denizen] [ReflectionHelper]: " + err);
                Debug.echoError(err);
            }
            return f;
        }

        public Field get(String name, Class expected) {
            Field f = this.get(name);
            if (f == null) {
                return null;
            }
            if (f.getType() != expected) {
                String err = "Reflection field incorrect type - read field '" + name + "' from class '" + this.clazz.getCanonicalName() + "', expected type '" + expected.getCanonicalName() + "' but is type '" + f.getType().getCanonicalName() + "'";
                System.err.println("[Denizen] [ReflectionHelper]: " + err);
                Debug.echoError(err);
            }
            return f;
        }

        public Field getNoCheck(String name) {
            return (Field)super.get(name);
        }
    }
}

