/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ListTag
implements List<String>,
ObjectTag {
    public static AsciiMatcher needsEscpingMatcher = new AsciiMatcher("&|");
    public final ArrayList<ObjectTag> objectForms;
    public boolean wasLegacy = false;
    private static HashSet<String> deduplicateHelper = new HashSet();
    private String prefix = "List";
    public static ObjectTagProcessor<ListTag> tagProcessor = new ObjectTagProcessor();

    public static String escapeEntry(String value) {
        if (!needsEscpingMatcher.containsAnyMatch(value)) {
            return value;
        }
        return value.replace("&", "&amp").replace("|", "&pipe");
    }

    public static String unescapeEntry(String value) {
        if (value.indexOf(38) == -1) {
            return value;
        }
        return value.replace("&pipe", "|").replace("&amp", "&");
    }

    @Override
    public boolean add(String addMe) {
        return this.objectForms.add(new ElementTag(addMe));
    }

    @Override
    public void add(int index, String addMe) {
        this.objectForms.add(index, new ElementTag(addMe));
    }

    @Override
    public boolean addAll(Collection<? extends String> addMe) {
        for (String string : addMe) {
            this.add(string);
        }
        return !addMe.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        for (String string : c) {
            this.add(index++, string);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean allGone = true;
        for (Object obj : c) {
            if (this.remove(obj)) continue;
            allGone = false;
        }
        return allGone;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.objectForms.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return new ListTagStringIterator(this, index);
    }

    @Override
    public Object[] toArray() {
        Object[] stringArr = new Object[this.size()];
        for (int i = 0; i < stringArr.length; ++i) {
            stringArr[i] = String.valueOf(this.getObject(i));
        }
        return stringArr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i;
        String[] stringArr = a instanceof String[] && a.length >= this.size() ? (String[])a : new String[this.size()];
        for (i = 0; i < this.size(); ++i) {
            stringArr[i] = String.valueOf(this.getObject(i));
        }
        for (i = this.size(); i < stringArr.length; ++i) {
            stringArr[i] = null;
        }
        return stringArr;
    }

    public ListTag subList(int fromIndex, int toIndex) {
        return new ListTag((Collection<? extends ObjectTag>)this.objectForms.subList(fromIndex, toIndex));
    }

    @Override
    public int indexOf(Object obj) {
        int size = this.size();
        if (obj == null) {
            for (int i = 0; i < size; ++i) {
                if (this.getObject(i) != null) continue;
                return i;
            }
        } else if (obj instanceof String) {
            for (int i = 0; i < size; ++i) {
                if (!obj.equals(String.valueOf(this.getObject(i)))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!obj.equals(this.getObject(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        int size = this.size() - 1;
        if (obj == null) {
            for (int i = size; i >= 0; --i) {
                if (this.getObject(i) != null) continue;
                return i;
            }
        } else if (obj instanceof String) {
            for (int i = size; i >= 0; --i) {
                if (!obj.equals(String.valueOf(this.getObject(i)))) continue;
                return i;
            }
        } else {
            for (int i = size; i >= 0; --i) {
                if (!obj.equals(this.getObject(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public ObjectTag removeObject(int index) {
        return this.objectForms.remove(index);
    }

    @Override
    public String remove(int index) {
        return String.valueOf(this.removeObject(index));
    }

    @Override
    public boolean remove(Object key) {
        int ind = this.indexOf(key);
        if (ind < 0 || ind >= this.size()) {
            return false;
        }
        this.remove(ind);
        return true;
    }

    @Override
    public int size() {
        return this.objectForms.size();
    }

    @Override
    public boolean isEmpty() {
        return this.objectForms.isEmpty();
    }

    @Override
    public boolean isTruthy() {
        return !this.isEmpty();
    }

    @Override
    public String get(int index) {
        return String.valueOf(this.objectForms.get(index));
    }

    @Override
    public String set(int index, String value) {
        return String.valueOf(this.setObject(index, new ElementTag(value)));
    }

    public boolean addAll(ListTag inp) {
        return this.objectForms.addAll(inp.objectForms);
    }

    public boolean addObject(ObjectTag obj) {
        return this.objectForms.add(obj);
    }

    public void addObject(int index, ObjectTag obj) {
        this.objectForms.add(index, obj);
    }

    public ObjectTag setObject(int index, ObjectTag obj) {
        return this.objectForms.set(index, obj);
    }

    public ObjectTag getObject(int id) {
        return this.objectForms.get(id);
    }

    @Deprecated
    public static ListTag valueOf(String string) {
        return ListTag.valueOf(string, null);
    }

    @Fetchable(value="li")
    public static ListTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("map@")) {
            MapTag map = MapTag.valueOf(string, context);
            ListTag list = new ListTag();
            if (map == null) {
                list.add(string);
            } else {
                list.addObject(map);
            }
            return list;
        }
        return new ListTag(string.startsWith("li@") ? string.substring("li@".length()) : string, context);
    }

    public static ListTag getListFor(ObjectTag inp, TagContext context) {
        if (inp instanceof ListTag) {
            return (ListTag)inp;
        }
        if (inp instanceof ElementTag) {
            return ListTag.valueOf(inp.toString(), context);
        }
        ListTag output = new ListTag(1);
        output.addObject(inp);
        return output;
    }

    public static boolean matches(String arg) {
        return true;
    }

    @Override
    public ListTag duplicate() {
        ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(this.size());
        for (ObjectTag obj : this.objectForms) {
            objs.add(obj == null ? null : obj.duplicate());
        }
        return new ListTag((Collection<? extends ObjectTag>)objs);
    }

    public ListTag(Collection<? extends ObjectTag> objectTagList) {
        this.objectForms = new ArrayList<ObjectTag>(objectTagList);
    }

    public ListTag(ObjectTag ... objects) {
        this((Collection<? extends ObjectTag>)Arrays.asList(objects));
    }

    public ListTag(int capacity) {
        this.objectForms = new ArrayList(capacity);
    }

    public ListTag() {
        this.objectForms = new ArrayList();
    }

    public ListTag(String items) {
        this(items, null);
    }

    public ListTag(String items, TagContext context) {
        this.objectForms = new ArrayList();
        if (items != null && items.length() > 0) {
            if (!items.contains("|")) {
                this.addObject(ObjectFetcher.pickObjectFor(items, context));
            } else if (items.endsWith("|")) {
                int pipe = items.indexOf(124);
                int lastPipe = 0;
                while (pipe != -1) {
                    String value = ListTag.unescapeEntry(items.substring(lastPipe, pipe));
                    ObjectTag object = ObjectFetcher.pickObjectFor(value, context);
                    this.addObject(object);
                    lastPipe = pipe + 1;
                    pipe = items.indexOf(124, lastPipe);
                }
            } else {
                this.wasLegacy = true;
                int brackets = 0;
                int start = 0;
                for (int i = 0; i < items.length(); ++i) {
                    char chr = items.charAt(i);
                    if (chr == '[') {
                        ++brackets;
                        continue;
                    }
                    if (chr == ']') {
                        if (brackets <= 0) continue;
                        --brackets;
                        continue;
                    }
                    if (brackets != 0 || chr != '|') continue;
                    this.addObject(ObjectFetcher.pickObjectFor(items.substring(start, i), context));
                    start = i + 1;
                }
                if (start < items.length()) {
                    this.addObject(ObjectFetcher.pickObjectFor(items.substring(start), context));
                }
            }
        }
    }

    public ListTag(ListTag input) {
        this.objectForms = new ArrayList<ObjectTag>(input.objectForms);
    }

    public ListTag(List<String> items, boolean isPlainText) {
        this.objectForms = new ArrayList(items.size());
        for (String str : items) {
            this.objectForms.add(new ElementTag(str, isPlainText));
        }
    }

    public ListTag(List<String> items) {
        this.objectForms = new ArrayList(items.size());
        for (String str : items) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(Set<?> items) {
        this.objectForms = new ArrayList(items.size());
        for (Object o : items) {
            if (o instanceof ObjectTag) {
                this.objectForms.add((ObjectTag)o);
                continue;
            }
            this.objectForms.add(new ElementTag(o.toString()));
        }
    }

    public ListTag(Stream<String> items) {
        this.objectForms = new ArrayList();
        items.forEach(s -> this.objectForms.add(new ElementTag((String)s)));
    }

    public ListTag addObjects(List<ObjectTag> objectTags) {
        this.objectForms.addAll(objectTags);
        return this;
    }

    public boolean containsObjectsFrom(Class<? extends ObjectTag> dClass) {
        for (ObjectTag testable : this.objectForms) {
            if (!CoreUtilities.canPossiblyBeType(testable, dClass)) continue;
            return true;
        }
        return false;
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (String string : this) {
            for (Enum value : values) {
                if (!CoreUtilities.equalsIgnoreCase(value.name(), string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, ScriptEntry entry) {
        return this.filter(dClass, entry == null ? CoreUtilities.basicContext : entry.getContext(), true);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, Debuggable debugger, boolean showFailure) {
        TagContext context = DenizenCore.implementation.getTagContext((ScriptEntry)null);
        context.debug = debugger.shouldDebug();
        return this.filter(dClass, context, showFailure);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context) {
        return this.filter(dClass, context, context == null || context.debug);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context, boolean showFailure) {
        ArrayList<T> results = new ArrayList<T>(this.objectForms.size());
        for (ObjectTag obj : this.objectForms) {
            try {
                if (CoreUtilities.canPossiblyBeType(obj, dClass)) {
                    T object = CoreUtilities.asType(obj, dClass, context);
                    if (object != null) {
                        results.add(object);
                        continue;
                    }
                    if (!showFailure) continue;
                    Debug.echoError("Cannot process list-entry '" + obj + "' as type '" + dClass.getSimpleName() + "' (conversion returned null).");
                    continue;
                }
                if (!showFailure) continue;
                Debug.echoError("Cannot process list-entry '" + obj + "' as type '" + dClass.getSimpleName() + "' (does not match expected type).");
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return results;
    }

    public ListTag deduplicate() {
        deduplicateHelper.clear();
        int size = this.size();
        ListTag list = new ListTag(size);
        for (int i = 0; i < size; ++i) {
            ObjectTag obj = this.objectForms.get(i);
            String entry = CoreUtilities.toLowerCase(String.valueOf(obj));
            if (deduplicateHelper.contains(entry)) continue;
            list.addObject(obj);
            deduplicateHelper.add(entry);
        }
        deduplicateHelper.clear();
        return list;
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ListTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isEmpty()) {
            return "<LG>li@ (Size <GR>0<LG>)";
        }
        StringBuilder debugText = new StringBuilder();
        debugText.append("<LG>li@ (Size <GR>").append(this.size()).append("<LG>): <Y>");
        for (ObjectTag item : this.objectForms) {
            debugText.append(item.debuggable()).append(" <LG>|<Y> ");
        }
        return debugText.substring(0, debugText.length() - " <LG>|<Y> ".length());
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    @Override
    public String identify() {
        return this.identifyList();
    }

    public String identifyList() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder output = new StringBuilder();
        output.append("li@");
        for (ObjectTag object : this.objectForms) {
            output.append(ListTag.escapeEntry(object.savable())).append('|');
        }
        return output.toString();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    private static String parseString(ListTag obj, String spacer) {
        StringBuilder dScriptArg = new StringBuilder();
        for (String item : obj) {
            dScriptArg.append(item);
            dScriptArg.append(spacer);
        }
        return dScriptArg.substring(0, dScriptArg.length() - spacer.length());
    }

    public int parseIndex(String index, Attribute attribute, boolean strict) {
        int integerIndex;
        int size = this.size();
        if (size == 0) {
            attribute.echoError("Invalid index parse, list is empty.");
            return -1;
        }
        if ((index = CoreUtilities.toLowerCase(index)).equals("last")) {
            return size - 1;
        }
        if (index.equals("first")) {
            return 0;
        }
        try {
            integerIndex = Integer.parseInt(index);
        }
        catch (NumberFormatException ex) {
            attribute.echoError("Invalid index '" + index + "': not a number.");
            return -1;
        }
        if (integerIndex < 0) {
            return Math.max(0, size + integerIndex);
        }
        if (integerIndex == 0) {
            attribute.echoError("Invalid index '0': lists start at index 1.");
            return 0;
        }
        if (strict && integerIndex > size) {
            attribute.echoError("Invalid index '" + index + "': list only has " + size + " entries in it.");
            return -1;
        }
        return Math.min(size, integerIndex) - 1;
    }

    public static void registerTags() {
        tagProcessor.registerStaticTag(ListTag.class, "combine", (attribute, object) -> {
            ListTag output = new ListTag();
            for (ObjectTag obj : object.objectForms) {
                output.addObjects(ListTag.getListFor((ObjectTag)obj, (TagContext)attribute.context).objectForms);
            }
            return output;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "sub_lists", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("list.sub_lists[...] tag must have an input.");
                return null;
            }
            int subListLength = Math.max(1, attribute.getIntParam());
            ListTag output = new ListTag();
            ListTag building = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                building.addObject(object.getObject(i));
                if (building.size() != subListLength) continue;
                output.addObject(building);
                building = new ListTag();
            }
            if (!building.isEmpty()) {
                output.addObject(building);
            }
            return output;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "space_separated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, " "));
        }, "as_string", "asstring");
        tagProcessor.registerStaticTag(ElementTag.class, "separated_by", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            String input = attribute.getParam();
            return new ElementTag(ListTag.parseString(object, input));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "comma_separated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, ", "));
        }, "ascslist", "as_cslist");
        tagProcessor.registerStaticTag(ElementTag.class, "unseparated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, ""));
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "get_sub_items", (attribute, object) -> {
            int index = -1;
            if (ArgumentHelper.matchesInteger(attribute.getParam())) {
                index = attribute.getIntParam() - 1;
            }
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            if (index < 0) {
                return null;
            }
            ListTag sub_list = new ListTag();
            for (String item : object) {
                String[] strings = item.split(Pattern.quote(split));
                if (strings.length > index) {
                    sub_list.add(strings[index]);
                    continue;
                }
                sub_list.add("null");
            }
            return sub_list;
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "map_get", (attribute, object) -> {
            Deprecations.listOldMapTags.warn(attribute.context);
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            ListTag input = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            ListTag result = new ListTag();
            for (String key : input) {
                for (String item : object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[0].equalsIgnoreCase(key)) continue;
                    result.add(strings[1]);
                }
            }
            if (input.size() == 1 && result.size() == 1) {
                return new ElementTag(result.get(0));
            }
            if (input.size() > 1) {
                if (result.size() != input.size()) {
                    return null;
                }
                return result;
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "map_find_key", (attribute, object) -> {
            Deprecations.listOldMapTags.warn(attribute.context);
            String input = attribute.getParam();
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            for (String item : object) {
                String[] strings = item.split(Pattern.quote(split), 2);
                if (strings.length <= 1 || !strings[1].equalsIgnoreCase(input)) continue;
                return new ElementTag(strings[0]);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "merge_maps", (attribute, object) -> {
            MapTag map = new MapTag();
            for (ObjectTag entry : object.objectForms) {
                MapTag subMap = MapTag.getMapFor(entry, attribute.context);
                if (subMap == null) {
                    attribute.echoError("Invalid map '" + entry + "' for merge_maps tag.");
                    return null;
                }
                map.map.putAll(subMap.map);
            }
            return map;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "to_map", (attribute, object) -> {
            String symbol = "/";
            if (attribute.hasParam()) {
                symbol = attribute.getParam();
            }
            MapTag map = new MapTag();
            for (String entry : object) {
                int slash = entry.indexOf(symbol);
                if (slash == -1) {
                    return null;
                }
                String key = entry.substring(0, slash);
                String value = entry.substring(slash + symbol.length());
                map.putObject(key, new ElementTag(value));
            }
            return map;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "map_with", (attribute, object) -> {
            ListTag inputList = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            if (object.size() != inputList.size()) {
                attribute.echoError("List.map_with tag failed: lists must be the same size!");
                return null;
            }
            MapTag map = new MapTag();
            for (int i = 0; i < object.size(); ++i) {
                map.putObject(object.get(i), inputList.getObject(i));
            }
            return map;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "size", (attribute, object) -> new ElementTag(object.size()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "is_empty", (attribute, object) -> new ElementTag(object.isEmpty()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "any", (attribute, object) -> new ElementTag(!object.isEmpty()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "insert", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.insert[...] must have a value.");
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2), attribute, false);
                if (index == -1) {
                    return null;
                }
                for (int i = 0; i < items.size(); ++i) {
                    result.addObject(index + i, items.getObject(i));
                }
                attribute.fulfill(1);
                return result;
            }
            Debug.echoError("The tag ListTag.insert[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "set", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.set[...] must have a value.");
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2), attribute, false);
                if (index == -1) {
                    return null;
                }
                attribute.fulfill(1);
                if (!result.isEmpty()) {
                    result.removeObject(index);
                }
                for (int i = 0; i < items.size(); ++i) {
                    result.addObject(index + i, items.objectForms.get(i));
                }
                return result;
            }
            Debug.echoError("The tag ListTag.set[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "set_single", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.set_single[...] must have a value.");
                return null;
            }
            ObjectTag value = attribute.getParamObject();
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2), attribute, false);
                attribute.fulfill(1);
                if (index == -1) {
                    return null;
                }
                if (!result.isEmpty()) {
                    result.removeObject(index);
                }
                result.addObject(index, value);
                return result;
            }
            Debug.echoError("The tag ListTag.set_single[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "overwrite", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.overwrite[...] must have a value.");
                return null;
            }
            if (object.isEmpty()) {
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2), attribute, false);
                attribute.fulfill(1);
                if (index == -1) {
                    return null;
                }
                for (int i = 0; i < items.size(); ++i) {
                    if (index + i >= result.size()) {
                        result.addObject(items.objectForms.get(i));
                        continue;
                    }
                    result.setObject(index + i, items.objectForms.get(i));
                }
                return result;
            }
            Debug.echoError("The tag ListTag.overwrite[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "include_single", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.include_single[...] must have a value.");
                return null;
            }
            ListTag copy = new ListTag((ListTag)object);
            copy.addObject(attribute.getParamObject());
            return copy;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "include", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.include[...] must have a value.");
                return null;
            }
            ListTag copy = new ListTag((ListTag)object);
            copy.addAll(ListTag.getListFor(attribute.getParamObject(), attribute.context));
            return copy;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "exclude", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.exclude[...] must have a value.");
                return null;
            }
            ListTag exclusions = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            HashSet<String> toExclude = new HashSet<String>(exclusions.size() * 2);
            for (String str : exclusions) {
                toExclude.add(CoreUtilities.toLowerCase(str));
            }
            int max = Integer.MAX_VALUE;
            if (attribute.startsWith("max", 2) && attribute.hasContext(2)) {
                max = attribute.getIntContext(2);
                attribute = attribute.fulfill(1);
            }
            int removed = 0;
            ListTag copy = new ListTag((ListTag)object);
            for (int i = 0; i < copy.size(); ++i) {
                if (!toExclude.contains(CoreUtilities.toLowerCase(copy.get(i)))) continue;
                copy.removeObject(i--);
                if (++removed >= max) break;
            }
            return copy;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "remove", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.remove[#] must have a value.");
                return null;
            }
            ListTag indices = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            ListTag copy = new ListTag((ListTag)object);
            if (indices.size() == 1 && attribute.startsWith("to", 2)) {
                if (!attribute.hasContext(2)) {
                    attribute.echoError("The tag ListTag.remove[#].to[#] must have a to value.");
                    return null;
                }
                int fromIndex = object.parseIndex(indices.get(0), attribute, true);
                int toIndex = object.parseIndex(attribute.getContext(2), attribute, false);
                attribute.fulfill(1);
                if (fromIndex == -1 || toIndex == -1) {
                    return null;
                }
                if (toIndex < fromIndex) {
                    return copy;
                }
                copy.objectForms.subList(fromIndex, toIndex + 1).clear();
                return copy;
            }
            for (String index : indices) {
                int remove = copy.parseIndex(index, attribute, true);
                if (remove == -1) continue;
                copy.set(remove, "\u0000");
            }
            for (int i = 0; i < copy.size(); ++i) {
                if (!copy.get(i).equals("\u0000")) continue;
                copy.removeObject(i--);
            }
            return copy;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "shared_contents", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.shared_contents[...] must have a value.");
                return null;
            }
            ListTag secondList = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            ListTag output = new ListTag();
            for (String val : object) {
                if (!secondList.containsCaseInsensitive(val) || output.containsCaseInsensitive(val)) continue;
                output.add(val);
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "replace", (attribute, object) -> {
            if (!attribute.hasParam()) {
                Debug.echoError("The tag ListTag.replace[...] must have a value.");
                return null;
            }
            String replace = attribute.getParam();
            ObjectTag replacement = null;
            if (attribute.startsWith("with", 2)) {
                attribute.fulfill(1);
                if (attribute.hasParam()) {
                    replacement = attribute.getParamObject();
                } else {
                    Debug.echoError("The tag ListTag.replace[...].with[...] must have a value.");
                    return null;
                }
            }
            ListTag list = new ListTag();
            if (replace.startsWith("regex:")) {
                String regex = replace.substring("regex:".length());
                Pattern tempPat = Pattern.compile(regex);
                for (int i = 0; i < object.size(); ++i) {
                    if (tempPat.matcher(object.get(i)).matches()) {
                        if (replacement == null) continue;
                        list.addObject(replacement);
                        continue;
                    }
                    list.addObject(object.getObject(i));
                }
            } else {
                for (int i = 0; i < object.size(); ++i) {
                    if (CoreUtilities.equalsIgnoreCase(object.get(i), replace)) {
                        if (replacement == null) continue;
                        list.addObject(replacement);
                        continue;
                    }
                    list.addObject(object.getObject(i));
                }
            }
            return list;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "reverse", (attribute, object) -> {
            ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(object.objectForms);
            Collections.reverse(objs);
            return new ListTag((Collection<? extends ObjectTag>)objs);
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "deduplicate", (attribute, object) -> object.deduplicate(), new String[0]);
        TagRunnable.ObjectInterface<ListTag, ObjectTag> getRunnable = (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.get[...] must have a value.");
                return null;
            }
            if (object.isEmpty()) {
                attribute.echoError("Can't get from an empty list.");
                return null;
            }
            try {
                ListTag indices = ListTag.getListFor(attribute.getParamObject(), attribute.context);
                if (indices.size() > 1) {
                    ListTag results = new ListTag();
                    for (String index : indices) {
                        int ind = object.parseIndex(index, attribute, true);
                        if (ind == -1) continue;
                        results.addObject(object.getObject(ind));
                    }
                    return results;
                }
                if (indices.size() > 0) {
                    int index = object.parseIndex(indices.get(0), attribute, true);
                    if (index == -1) {
                        return null;
                    }
                    if (attribute.startsWith("to", 2) && attribute.hasContext(2)) {
                        int index2 = object.parseIndex(attribute.getContext(2), attribute, false);
                        if (index2 == -1) {
                            return null;
                        }
                        ListTag newList = new ListTag();
                        for (int i = index; i <= index2; ++i) {
                            newList.addObject(object.getObject(i));
                        }
                        attribute.fulfill(1);
                        return newList;
                    }
                    return object.getObject(index);
                }
            }
            catch (NumberFormatException ex) {
                attribute.echoError("ListTag.get[...] input invalid - not a valid number: " + ex.getMessage());
            }
            return null;
        };
        tagProcessor.registerTag(ObjectTag.class, "get", getRunnable, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "", getRunnable, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "find_all_partial", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.find_all_partial[...] must have a value.");
                return null;
            }
            String test = CoreUtilities.toLowerCase(attribute.getParam());
            ListTag positions = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                if (!CoreUtilities.toLowerCase(object.get(i)).contains(test)) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "find_all_matches", (attribute, list) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.find_all_matches[...] must have a value.");
                return null;
            }
            ListTag positions = new ListTag();
            String matcher = attribute.getParam();
            for (int i = 0; i < list.size(); ++i) {
                ObjectTag object = list.getObject(i);
                if (object == null || !object.tryAdvancedMatcher(matcher)) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "find_all", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.find_all[...] must have a value.");
                return null;
            }
            ListTag positions = new ListTag();
            String test = CoreUtilities.toLowerCase(attribute.getParam());
            for (int i = 0; i < object.size(); ++i) {
                if (!CoreUtilities.toLowerCase(object.get(i)).equals(test)) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "find_partial", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.find_partial[...] must have a value.");
                return null;
            }
            String test = CoreUtilities.toLowerCase(attribute.getParam());
            for (int i = 0; i < object.size(); ++i) {
                if (!CoreUtilities.toLowerCase(object.get(i)).contains(test)) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "find_match", (attribute, list) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.find_match[...] must have a value.");
                return null;
            }
            String matcher = attribute.getParam();
            for (int i = 0; i < list.size(); ++i) {
                ObjectTag object = list.getObject(i);
                if (object == null || !object.tryAdvancedMatcher(matcher)) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "find", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.find[...] must have a value.");
                return null;
            }
            String test = CoreUtilities.toLowerCase(attribute.getParam());
            for (int i = 0; i < object.size(); ++i) {
                if (!CoreUtilities.toLowerCase(object.get(i)).equals(test)) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "count", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.count[...] must have a value.");
                return null;
            }
            String test = CoreUtilities.toLowerCase(attribute.getParam());
            int count = 0;
            for (String s : object) {
                if (!CoreUtilities.toLowerCase(s).equals(test)) continue;
                ++count;
            }
            return new ElementTag(count);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "count_matches", (attribute, list) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ListTag.count_matches[...] must have a value.");
                return null;
            }
            String matcher = attribute.getParam();
            int count = 0;
            for (ObjectTag object : list.objectForms) {
                if (object == null || !object.tryAdvancedMatcher(matcher)) continue;
                ++count;
            }
            return new ElementTag(count);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "sum", (attribute, object) -> {
            BigDecimal sum = BigDecimal.ZERO;
            for (String entry : object) {
                if (!ArgumentHelper.matchesDouble(entry)) continue;
                sum = sum.add(new ElementTag(entry).asBigDecimal());
            }
            return new ElementTag(sum);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "average", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag(0);
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (String entry : object) {
                if (!ArgumentHelper.matchesDouble(entry)) continue;
                sum = sum.add(new ElementTag(entry).asBigDecimal());
            }
            try {
                return new ElementTag(sum.divide(new BigDecimal(object.size()), 64, RoundingMode.HALF_UP));
            }
            catch (Throwable e) {
                return new ElementTag(sum.doubleValue() / (double)object.size());
            }
        }, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, "first", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            return object.objectForms.get(0);
        }, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, "last", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            return object.objectForms.get(object.size() - 1);
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "lowest", (attribute, object) -> {
            Attribute subAttribute;
            String tag = null;
            if (attribute.hasParam()) {
                tag = attribute.getRawParam();
            }
            try {
                subAttribute = tag == null ? null : new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            if (attribute.startsWith("count", 2) && attribute.hasContext(2)) {
                int count = Math.min(attribute.getIntContext(2), object.size());
                attribute.fulfill(1);
                int[] indices = new int[count];
                BigDecimal[] values = new BigDecimal[count];
                block2: for (int i = 0; i < object.size(); ++i) {
                    String str;
                    ObjectTag obj = object.getObject(i);
                    if (tag != null) {
                        obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    }
                    if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                    BigDecimal val = new ElementTag(str).asBigDecimal();
                    for (int x = 0; x < count; ++x) {
                        if (values[x] != null && values[x].compareTo(val) <= 0) continue;
                        for (int j = count - 1; j > x; --j) {
                            values[j] = values[j - 1];
                            indices[j] = indices[j - 1];
                        }
                        values[x] = val;
                        indices[x] = i;
                        continue block2;
                    }
                }
                ListTag output = new ListTag(count);
                for (int i = 0; i < count; ++i) {
                    if (values[i] == null) continue;
                    output.addObject(object.getObject(indices[i]));
                }
                return output;
            }
            ObjectTag lowestObj = null;
            BigDecimal lowest = null;
            Iterator<ObjectTag> iterator = object.objectForms.iterator();
            while (iterator.hasNext()) {
                String str;
                ObjectTag obj;
                ObjectTag actualObj = obj = iterator.next();
                if (tag != null) {
                    obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                }
                if (obj == null || !ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                BigDecimal val = new ElementTag(str).asBigDecimal();
                if (lowest != null && lowest.compareTo(val) <= 0) continue;
                lowest = val;
                lowestObj = actualObj;
            }
            return lowestObj;
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "highest", (attribute, object) -> {
            Attribute subAttribute;
            String tag = null;
            if (attribute.hasParam()) {
                tag = attribute.getRawParam();
            }
            try {
                subAttribute = tag == null ? null : new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            if (attribute.startsWith("count", 2) && attribute.hasContext(2)) {
                int count = Math.min(attribute.getIntContext(2), object.size());
                attribute.fulfill(1);
                int[] indices = new int[count];
                BigDecimal[] values = new BigDecimal[count];
                block2: for (int i = 0; i < object.size(); ++i) {
                    String str;
                    ObjectTag obj = object.getObject(i);
                    if (tag != null) {
                        obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    }
                    if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                    BigDecimal val = new ElementTag(str).asBigDecimal();
                    for (int x = 0; x < count; ++x) {
                        if (values[x] != null && values[x].compareTo(val) >= 0) continue;
                        for (int j = count - 1; j > x; --j) {
                            values[j] = values[j - 1];
                            indices[j] = indices[j - 1];
                        }
                        values[x] = val;
                        indices[x] = i;
                        continue block2;
                    }
                }
                ListTag output = new ListTag(count);
                for (int i = 0; i < count; ++i) {
                    if (values[i] == null) continue;
                    output.addObject(object.getObject(indices[i]));
                }
                return output;
            }
            ObjectTag highestObj = null;
            BigDecimal highest = null;
            Iterator<ObjectTag> iterator = object.objectForms.iterator();
            while (iterator.hasNext()) {
                String str;
                ObjectTag obj;
                ObjectTag actualObj = obj = iterator.next();
                if (tag != null) {
                    obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                }
                if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                BigDecimal val = new ElementTag(str).asBigDecimal();
                if (highest != null && highest.compareTo(val) >= 0) continue;
                highest = val;
                highestObj = actualObj;
            }
            return highestObj;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "numerical", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            sortable.sort((o1, o2) -> {
                double value = new ElementTag((String)o1).asDouble() - new ElementTag((String)o2).asDouble();
                if (value == 0.0) {
                    return 0;
                }
                if (value > 0.0) {
                    return 1;
                }
                return -1;
            });
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "alphanumeric", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            sortable.sort(new NaturalOrderComparator());
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "alphabetical", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            sortable.sort(String::compareToIgnoreCase);
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "sort_by_value", (attribute, object) -> {
            Attribute subAttribute;
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag newlist = new ListTag((ListTag)object);
            NaturalOrderComparator comparator = new NaturalOrderComparator();
            String tag = attribute.getRawParam();
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                newlist.objectForms.sort((o1, o2) -> {
                    ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    return comparator.compare(or1, or2);
                });
                return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return newlist;
            }
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "sort_by_number", (attribute, object) -> {
            Attribute subAttribute;
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag newlist = new ListTag((ListTag)object);
            String tag = attribute.getRawParam();
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                newlist.objectForms.sort((o1, o2) -> {
                    ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    try {
                        double r1 = Double.parseDouble(or1.toString());
                        double r2 = Double.parseDouble(or2.toString());
                        double value = r1 - r2;
                        if (value == 0.0) {
                            return 0;
                        }
                        if (value > 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (NumberFormatException ex) {
                        attribute.echoError("Invalid non-numerical input to sort_by_number tag: " + or1 + ", " + or2.toString());
                        return 0;
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return newlist;
            }
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "sort", (attribute, object) -> {
            ListTag obj = new ListTag((ListTag)object);
            ProcedureScriptContainer script = (ProcedureScriptContainer)attribute.paramAsType(ScriptTag.class).getContainer();
            if (script == null) {
                attribute.echoError("'" + attribute.getParam() + "' is not a valid procedure script!");
                return obj;
            }
            ScriptEntry entry = attribute.getScriptEntry();
            ListTag context = new ListTag();
            if (attribute.startsWith("context", 2)) {
                attribute.fulfill(1);
                context = attribute.paramAsType(ListTag.class);
            }
            ListTag context_send = context;
            ArrayList<String> list = new ArrayList<String>(obj);
            try {
                list.sort((o1, o2) -> {
                    List<ScriptEntry> entries = script.getBaseEntries(entry == null ? DenizenCore.implementation.getEmptyScriptEntryData() : entry.entryData.clone());
                    if (entries.isEmpty()) {
                        return 0;
                    }
                    InstantQueue queue = new InstantQueue("LISTTAG_SORT");
                    queue.addEntries(entries);
                    int x = 1;
                    ListTag definitions = new ListTag();
                    definitions.add((String)o1);
                    definitions.add((String)o2);
                    definitions.addAll(context_send);
                    String[] definition_names = null;
                    try {
                        definition_names = script.getString("definitions").split("\\|");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (String definition : definitions) {
                        String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                        queue.addDefinition(name, definition);
                        Debug.echoDebug((Debuggable)entries.get(0), "Adding definition '" + name + "' as " + definition);
                        ++x;
                    }
                    queue.start();
                    int res = 0;
                    if (queue.determinations != null && queue.determinations.size() > 0) {
                        res = new ElementTag(queue.determinations.get(0)).asInt();
                    }
                    return Integer.compare(res, 0);
                });
            }
            catch (Exception e) {
                Debug.echoError("list.sort[...] tag failed - procedure returned unreasonable response - internal error: " + e.getMessage());
            }
            return new ListTag((List<String>)list);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "filter", (attribute, object) -> {
            Attribute subAttribute;
            String tag = attribute.getRawParam();
            boolean defaultValue = tag.endsWith("||true");
            if (defaultValue) {
                tag = tag.substring(0, tag.length() - "||true".length());
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            ListTag newlist = new ListTag();
            try {
                for (ObjectTag obj : object.objectForms) {
                    Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
                    tempAttrib.setHadAlternative(true);
                    ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                    if (!(objs == null ? defaultValue : CoreUtilities.equalsIgnoreCase(objs.toString(), "true"))) continue;
                    newlist.addObject(obj);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "parse", (attribute, object) -> {
            Attribute subAttribute;
            ListTag newlist = new ListTag();
            String tag = attribute.getRawParam();
            String defaultValue = "null";
            boolean fallback = false;
            if (tag.contains("||")) {
                int marks = 0;
                int lengthLimit = tag.length() - 1;
                for (int i = 0; i < lengthLimit; ++i) {
                    char c = tag.charAt(i);
                    if (c == '<') {
                        ++marks;
                        continue;
                    }
                    if (c == '>') {
                        --marks;
                        continue;
                    }
                    if (marks != 0 || c != '|' || tag.charAt(i + 1) != '|') continue;
                    fallback = true;
                    defaultValue = tag.substring(i + 2);
                    tag = tag.substring(0, i);
                    break;
                }
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                for (ObjectTag obj : object.objectForms) {
                    Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
                    tempAttrib.setHadAlternative(attribute.hasAlternative() || fallback);
                    ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                    if (objs == null) {
                        objs = new ElementTag(defaultValue);
                    }
                    newlist.addObject(objs);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "filter_tag", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag newlist = new ListTag();
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            try {
                for (ObjectTag obj : object.objectForms) {
                    provider.altDefs.putObject("filter_value", obj);
                    if (!CoreUtilities.equalsIgnoreCase(attribute.parseDynamicParam(provider).toString(), "true")) continue;
                    newlist.addObject(obj);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "parse_tag", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag newlist = new ListTag();
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            try {
                for (ObjectTag obj : object.objectForms) {
                    provider.altDefs.putObject("parse_value", obj);
                    newlist.addObject(attribute.parseDynamicParam(provider));
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "pad_left", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ObjectTag with = new ElementTag("");
            int length = attribute.getIntParam();
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag newList = new ListTag((ListTag)object);
            while (newList.size() < length) {
                newList.addObject(0, with);
            }
            return newList;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "pad_right", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ObjectTag with = new ElementTag("");
            int length = attribute.getIntParam();
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag newList = new ListTag((ListTag)object);
            while (newList.size() < length) {
                newList.addObject(with);
            }
            return newList;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "escape_contents", (attribute, object) -> {
            Deprecations.listEscapeContents.warn(attribute.context);
            ListTag escaped = new ListTag();
            for (String entry : object) {
                escaped.add(EscapeTagBase.escape(entry));
            }
            return escaped;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "unescape_contents", (attribute, object) -> {
            Deprecations.listEscapeContents.warn(attribute.context);
            ListTag escaped = new ListTag();
            for (String entry : object) {
                escaped.add(EscapeTagBase.unEscape(entry));
            }
            return escaped;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "contains_any_case_sensitive", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag list = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            boolean state = false;
            block0: for (String element : object) {
                for (String sub_element : list) {
                    if (!element.equals(sub_element)) continue;
                    state = true;
                    break block0;
                }
            }
            return new ElementTag(state);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "contains_any", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag list = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            boolean state = false;
            block0: for (String element : object) {
                for (String sub_element : list) {
                    if (!CoreUtilities.equalsIgnoreCase(element, sub_element)) continue;
                    state = true;
                    break block0;
                }
            }
            return new ElementTag(state);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "contains_case_sensitive", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            boolean state = false;
            for (String element : object) {
                if (!element.equals(attribute.getParam())) continue;
                state = true;
                break;
            }
            return new ElementTag(state);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "contains", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag needed = ListTag.getListFor(attribute.getParamObject(), attribute.context);
            int gotten = 0;
            block0: for (String check : needed) {
                for (String element : object) {
                    if (!CoreUtilities.equalsIgnoreCase(element, check)) continue;
                    ++gotten;
                    continue block0;
                }
            }
            return new ElementTag(gotten == needed.size() && gotten > 0);
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "random", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            if (attribute.hasParam()) {
                int count = Integer.parseInt(attribute.getParam());
                ArrayList<ObjectTag> available = new ArrayList<ObjectTag>(object.objectForms);
                ListTag toReturn = new ListTag();
                for (int times = 0; !available.isEmpty() && times < count; ++times) {
                    int random = CoreUtilities.getRandom().nextInt(available.size());
                    toReturn.addObject(available.get(random));
                    available.remove(random);
                }
                return toReturn;
            }
            return object.objectForms.get(CoreUtilities.getRandom().nextInt(object.size()));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "closest_to", (attribute, object) -> new ElementTag(CoreUtilities.getClosestOption(object, attribute.getParam())), new String[0]);
    }

    public boolean containsCaseInsensitive(String val) {
        val = CoreUtilities.toLowerCase(val);
        for (String str : this) {
            if (!CoreUtilities.toLowerCase(str).equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag specialTagProcessing(Attribute attribute) {
        int index;
        String attrLow = attribute.getAttributeWithoutParam(1);
        if (CoreConfiguration.debugVerbose) {
            Debug.log("ListTag alternate attribute " + attrLow);
        }
        if (ArgumentHelper.matchesInteger(attrLow) && (index = Integer.parseInt(attrLow)) != 0) {
            attribute.fulfill(1);
            if (index < 1 || index > this.size()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("ListTag index " + index + " is out of range");
                }
                return null;
            }
            return this.getObject(index - 1);
        }
        return null;
    }

    public static class ListTagStringIterator
    implements ListIterator<String> {
        public ListTag list;
        int index;

        public ListTagStringIterator(ListTag list, int index) {
            this.list = list;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public String next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public String previous() {
            return this.list.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.list.remove(this.index--);
        }

        @Override
        public void set(String s) {
            this.list.set(this.index, s);
        }

        @Override
        public void add(String s) {
            this.list.add(this.index++, s);
        }
    }
}

