/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class AreaEnterExitScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static AreaEnterExitScriptEvent instance;
    public EntityTag currentEntity;
    public AreaContainmentObject area;
    public boolean isEntering;
    public Location to;
    public boolean doTrackAll = false;
    public String[] exactTracked = null;
    public String[] flagTracked = null;
    public ScriptEvent.MatchHelper[] matchers = null;
    public boolean onlyTrackPlayers = true;
    public static HashMap<UUID, HashSet<String>> entitiesInArea;

    public AreaEnterExitScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> enters|exits <area>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (this.isEntering && !path.eventArgLowerAt(1).equals("enters")) {
            return false;
        }
        if (!this.isEntering && !path.eventArgLowerAt(1).equals("exits")) {
            return false;
        }
        String areaName = path.eventArgLowerAt(2);
        if (areaName.equals("notable")) {
            areaName = path.eventArgLowerAt(3);
        }
        if (!this.area.tryAdvancedMatcher(areaName)) {
            return false;
        }
        if (!this.currentEntity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "AreaEnterExit";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.currentEntity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("area")) {
            return this.area;
        }
        if (name.equals("cause")) {
            String cause = this.currentEvent instanceof PlayerJoinEvent ? "JOIN" : (this.currentEvent instanceof PlayerQuitEvent ? "QUIT" : (this.currentEvent instanceof PlayerChangedWorldEvent ? "WORLD_CHANGE" : (this.currentEvent instanceof PlayerTeleportEvent ? "TELEPORT" : (this.currentEvent instanceof VehicleMoveEvent ? "VEHICLE" : (this.currentEvent instanceof PlayerMoveEvent ? "WALK" : "UNKNOWN")))));
            return new ElementTag(cause);
        }
        if (name.equals("to") && this.to != null) {
            return new LocationTag(this.to);
        }
        if (name.equals("from")) {
            if (this.currentEvent instanceof PlayerMoveEvent) {
                return new LocationTag(((PlayerMoveEvent)this.currentEvent).getFrom());
            }
            if (this.currentEvent instanceof VehicleMoveEvent) {
                return new LocationTag(((VehicleMoveEvent)this.currentEvent).getFrom());
            }
            return new LocationTag(this.currentEntity.getLocation());
        }
        if (name.equals("entity")) {
            return this.currentEntity.getDenizenObject();
        }
        return super.getContext(name);
    }

    public void registerCorrectClass() {
        this.initListener(new SpigotListeners());
    }

    @Override
    public void init() {
        this.doTrackAll = false;
        boolean needsMatchers = false;
        HashSet<String> exacts = new HashSet<String>();
        ArrayList<ScriptEvent.MatchHelper> matchList = new ArrayList<ScriptEvent.MatchHelper>();
        HashSet<String> flags = new HashSet<String>();
        this.onlyTrackPlayers = true;
        for (ScriptEvent.ScriptPath path : this.eventPaths) {
            ScriptEvent.MatchHelper matcher;
            String area;
            if (!path.eventArgLowerAt(0).equals("player")) {
                this.onlyTrackPlayers = false;
            }
            if ((area = path.eventArgLowerAt(2)).equals("notable")) {
                area = path.eventArgLowerAt(3);
            }
            if (area.equals("cuboid") || area.equals("ellipsoid") || area.equals("polygon")) {
                this.doTrackAll = true;
            }
            if ((matcher = AreaEnterExitScriptEvent.createMatcher(area)) instanceof ScriptEvent.AlwaysMatchHelper) {
                this.doTrackAll = true;
            } else if (!needsMatchers && matcher instanceof ScriptEvent.ExactMatchHelper) {
                exacts.add(area);
            } else {
                needsMatchers = true;
            }
            matchList.add(matcher);
            if (!area.startsWith("area_flagged:")) continue;
            flags.add(CoreUtilities.toLowerCase(area.substring("area_flagged:".length())));
        }
        this.exactTracked = needsMatchers ? null : exacts.toArray(new String[0]);
        this.matchers = needsMatchers ? matchList.toArray(new ScriptEvent.MatchHelper[0]) : null;
        this.flagTracked = flags.size() > 0 ? flags.toArray(new String[0]) : null;
        this.registerCorrectClass();
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled) {
            HashSet<String> inAreas = entitiesInArea.get(this.currentEntity.getUUID());
            if (this.isEntering) {
                inAreas.remove(CoreUtilities.toLowerCase(this.area.getNoteName()));
            } else {
                inAreas.add(CoreUtilities.toLowerCase(this.area.getNoteName()));
            }
        }
        super.cancellationChanged();
    }

    public boolean anyMatch(String name, FlaggableObject flaggable) {
        if (this.doTrackAll) {
            return true;
        }
        if (this.matchers != null) {
            for (ScriptEvent.MatchHelper matcher : this.matchers) {
                if (!matcher.doesMatch(name)) continue;
                return true;
            }
        }
        if (this.flagTracked != null) {
            for (String flag : this.flagTracked) {
                AbstractFlagTracker tracker = flaggable.getFlagTracker();
                if (tracker == null || !tracker.hasFlag(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public void processSingle(AreaContainmentObject obj, EntityTag entity, HashSet<String> inAreas, Location pos, Event eventCause) {
        boolean wasContained;
        boolean containedNow = pos != null && obj.doesContainLocation(pos);
        boolean bl = wasContained = inAreas != null && inAreas.contains(obj.getNoteName());
        if (containedNow == wasContained) {
            return;
        }
        if (inAreas == null) {
            inAreas = new HashSet();
            entitiesInArea.put(entity.getUUID(), inAreas);
        }
        if (containedNow) {
            inAreas.add(obj.getNoteName());
        } else {
            inAreas.remove(obj.getNoteName());
        }
        this.currentEntity = entity;
        this.isEntering = containedNow;
        this.area = obj;
        this.to = pos;
        this.fire(eventCause);
    }

    public void processNewPosition(EntityTag entity, Location pos, Event eventCause) {
        if (this.onlyTrackPlayers && !entity.isPlayer()) {
            return;
        }
        HashSet<String> inAreas = entitiesInArea.get(entity.getUUID());
        if (this.doTrackAll || this.matchers != null || this.flagTracked != null) {
            for (CuboidTag cuboid : NoteManager.getAllType(CuboidTag.class)) {
                if (!this.anyMatch(cuboid.noteName, cuboid)) continue;
                this.processSingle(cuboid, entity, inAreas, pos, eventCause);
            }
            for (EllipsoidTag ellipsoid : NoteManager.getAllType(EllipsoidTag.class)) {
                if (!this.anyMatch(ellipsoid.noteName, ellipsoid)) continue;
                this.processSingle(ellipsoid, entity, inAreas, pos, eventCause);
            }
            for (PolygonTag polygon : NoteManager.getAllType(PolygonTag.class)) {
                if (!this.anyMatch(polygon.noteName, polygon)) continue;
                this.processSingle(polygon, entity, inAreas, pos, eventCause);
            }
        } else {
            for (String name : this.exactTracked) {
                Notable obj = NoteManager.getSavedObject(name);
                if (!(obj instanceof AreaContainmentObject)) {
                    Debug.echoError("Invalid area enter/exit event area '" + name + "'");
                    continue;
                }
                this.processSingle((AreaContainmentObject)((Object)obj), entity, inAreas, pos, eventCause);
            }
        }
        if (inAreas != null && inAreas.isEmpty()) {
            entitiesInArea.remove(entity.getUUID());
        }
    }

    static {
        entitiesInArea = new HashMap();
    }

    public class SpigotListeners
    implements Listener {
        @EventHandler
        public void onQuit(PlayerQuitEvent event) {
            AreaEnterExitScriptEvent.this.processNewPosition(new EntityTag((Entity)event.getPlayer()), null, (Event)event);
            entitiesInArea.remove(event.getPlayer().getUniqueId());
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            AreaEnterExitScriptEvent.this.processNewPosition(new EntityTag((Entity)event.getPlayer()), event.getPlayer().getLocation(), (Event)event);
        }

        @EventHandler
        public void onMove(PlayerMoveEvent event) {
            if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
                return;
            }
            AreaEnterExitScriptEvent.this.processNewPosition(new EntityTag((Entity)event.getPlayer()), event.getTo(), (Event)event);
        }

        @EventHandler
        public void onTeleport(PlayerTeleportEvent event) {
            AreaEnterExitScriptEvent.this.processNewPosition(new EntityTag((Entity)event.getPlayer()), event.getTo(), (Event)event);
        }

        @EventHandler
        public void onWorldChange(PlayerChangedWorldEvent event) {
            AreaEnterExitScriptEvent.this.processNewPosition(new EntityTag((Entity)event.getPlayer()), event.getPlayer().getLocation(), (Event)event);
        }

        @EventHandler
        public void onVehicleMove(VehicleMoveEvent event) {
            if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
                return;
            }
            for (Entity entity : event.getVehicle().getPassengers()) {
                if (AreaEnterExitScriptEvent.this.onlyTrackPlayers && !EntityTag.isPlayer(entity)) continue;
                AreaEnterExitScriptEvent.this.processNewPosition(new EntityTag(entity), event.getTo(), (Event)event);
            }
        }
    }
}

