/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.DefinitionProvider;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Attribute {
    public static HashMap<String, AttributeComponent[]> attribsLookup = new HashMap();
    public AttributeComponent[] attributes;
    public ObjectTag[] contexts;
    public int[] filled;
    ScriptEntry scriptEntry;
    public TagContext context;
    String origin;
    public ArrayList<String> seemingSuccesses = new ArrayList(2);
    public boolean hadManualFulfill = false;
    public ObjectTag lastValid;
    public boolean hasContextFailed = false;
    int fulfilled = 0;
    private boolean hadAlternative = false;
    public static final HashMap<String, TagManager.TagBaseData> fallbackTags = new HashMap();

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static AttributeComponent[] separate_attributes(String attributes) throws TagProcessingException {
        AttributeComponent[] matchesRes = attribsLookup.get(attributes);
        if (matchesRes != null) {
            return matchesRes;
        }
        if (attributes.startsWith(".") || attributes.endsWith(".")) {
            throw new TagProcessingException("The tag '" + attributes + "' is invalid due to a misplaced dot at the start or end of the tag.");
        }
        ObjectTagProcessor<? extends ObjectTag> proc = null;
        ArrayList<AttributeComponent> matches = new ArrayList<AttributeComponent>(attributes.length() / 7);
        int x1 = 0;
        int x2 = -1;
        int braced = 0;
        char[] attrInp = attributes.toCharArray();
        for (int x = 0; x < attrInp.length; ++x) {
            char chr = attrInp[x];
            if (chr == '[') {
                ++braced;
            }
            if (x == attrInp.length - 1) {
                x2 = x + 1;
            }
            if (chr == ']') {
                if (braced > 0) {
                    --braced;
                }
            } else if (!(chr != '.' || x > 0 && Attribute.isNumber(attrInp[x + 1]) && Attribute.isNumber(attrInp[x - 1]) || braced != 0)) {
                x2 = x;
            }
            if (x2 <= -1) continue;
            if (x2 <= x1) {
                throw new TagProcessingException("The tag '" + attributes + "' is invalid, likely due to double dots '..' somewhere. Did you forget a sub-tag, or accidentally double-tap the dot key?");
            }
            AttributeComponent component = new AttributeComponent(attributes.substring(x1, x2));
            if (matches.size() == 0) {
                TagManager.TagBaseData baseTag = TagManager.baseTags.get(component.key);
                if (baseTag != null && baseTag.processor != null) {
                    proc = baseTag.processor;
                }
            } else if (proc != null) {
                component.data = proc.registeredObjectTags.get(component.key);
                proc = component.data == null ? null : component.data.processor;
            }
            matches.add(component);
            x2 = -1;
            x1 = x + 1;
        }
        if (braced != 0) {
            throw new TagProcessingException("The tag '" + attributes + "' is invalid due to misplaced [square brackets]. Did you forget to close some brackets?");
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("attribute splitter: '" + attributes + "' becomes: " + matches);
        }
        matchesRes = new AttributeComponent[matches.size()];
        matchesRes = matches.toArray(matchesRes);
        attribsLookup.put(attributes, matchesRes);
        return matchesRes;
    }

    public void resetErrorTrack() {
        if (CoreConfiguration.debugVerbose) {
            Debug.echoError("(Verbose) Attribute - error track reset");
        }
        if (!this.seemingSuccesses.isEmpty()) {
            this.seemingSuccesses.clear();
        }
        this.hasContextFailed = false;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Attribute(Attribute ref, ScriptEntry scriptEntry, TagContext context) {
        this(ref, scriptEntry, context, 0);
    }

    public Attribute(Attribute ref, ScriptEntry scriptEntry, TagContext context, int skippable) {
        this.origin = ref.origin;
        this.scriptEntry = scriptEntry;
        this.context = context;
        this.attributes = ref.attributes;
        this.contexts = new ObjectTag[this.attributes.length];
        this.setHadAlternative(ref.hadAlternative);
        if (context == null || context.debug) {
            this.filled = new int[this.attributes.length];
            for (int i = 0; i < skippable; ++i) {
                this.filled[i] = 3;
            }
        }
        this.fulfilled = skippable;
    }

    public Attribute(String attributes, ScriptEntry scriptEntry, TagContext context) throws TagProcessingException {
        this.origin = attributes;
        this.scriptEntry = scriptEntry;
        this.context = context;
        this.attributes = Attribute.separate_attributes(attributes);
        this.contexts = new ObjectTag[this.attributes.length];
        if (context == null || context.debug) {
            this.filled = new int[this.attributes.length];
        }
    }

    public final boolean matches(String string) {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        return this.attributes[this.fulfilled].key.equals(string);
    }

    public final boolean startsWith(String string) {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Trying tag startsWith " + string + " on tag " + this);
        }
        if (string.indexOf(46) >= 0) {
            List<String> tmp = CoreUtilities.split(string, '.');
            if (tmp.size() + this.fulfilled > this.attributes.length) {
                return false;
            }
            for (int i = 0; i < tmp.size(); ++i) {
                if (this.attributes[this.fulfilled + i].key.equals(tmp.get(i))) continue;
                return false;
            }
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Chain-Tag found!");
            }
            this.seemingSuccesses.add(string);
            return true;
        }
        if (this.attributes[this.fulfilled].key.equals(string)) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Sub-tag found!");
            }
            this.seemingSuccesses.add(string);
            return true;
        }
        return false;
    }

    public final boolean startsWith(String string, int attribute) {
        return CoreUtilities.toLowerCase(this.getAttributeWithoutParam(attribute)).equals(string);
    }

    public final boolean isComplete() {
        return this.fulfilled >= this.attributes.length;
    }

    public final Attribute fulfill(int attributes) {
        this.hadManualFulfill = true;
        this.resetErrorTrack();
        if (this.filled != null) {
            for (int i = 0; i < attributes; ++i) {
                if (this.fulfilled + i >= this.filled.length) continue;
                this.filled[this.fulfilled + i] = 1;
            }
        }
        this.fulfilled += attributes;
        return this;
    }

    public final void fulfillOne(ObjectTag obj) {
        this.lastValid = obj;
        this.resetErrorTrack();
        if (this.filled != null && this.fulfilled < this.filled.length) {
            this.filled[this.fulfilled] = 1;
        }
        ++this.fulfilled;
    }

    public final void trackLastTagFailure() {
        if (this.fulfilled < this.attributes.length) {
            this.seemingSuccesses.add(this.attributes[this.fulfilled].key);
            if (this.filled != null) {
                this.filled[this.fulfilled] = 2;
            }
        }
    }

    public final boolean hasParam() {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        if (this.attributes[this.fulfilled].rawParam != null) {
            return true;
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Attribute " + this.fulfilled + " is missing param, hasParamFailed");
        }
        this.hasContextFailed = true;
        return false;
    }

    @Deprecated
    public final boolean hasContext(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return false;
        }
        if (this.attributes[attribute].rawParam != null) {
            return true;
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Attribute " + attribute + " is missing context, hasContextFailed");
        }
        this.hasContextFailed = true;
        return false;
    }

    public final String getRawParam() {
        if (this.fulfilled >= this.attributes.length) {
            return null;
        }
        return this.attributes[this.fulfilled].rawParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectTag parseDynamicParam(OverridingDefinitionProvider customProvider) {
        String inp = this.getRawParam();
        if (inp == null) {
            return null;
        }
        DefinitionProvider originalProvider = this.context.definitionProvider;
        this.context.definitionProvider = customProvider;
        try {
            ObjectTag objectTag = TagManager.tagObject(inp, this.context);
            return objectTag;
        }
        finally {
            this.context.definitionProvider = originalProvider;
        }
    }

    public final <T extends ObjectTag> T paramAsType(Class<T> dClass) {
        ObjectTag contextObj = this.getParamObject();
        if (contextObj == null) {
            return null;
        }
        return CoreUtilities.asType(contextObj, dClass, this.context);
    }

    @Deprecated
    public final <T extends ObjectTag> T contextAsType(int attribute, Class<T> dClass) {
        ObjectTag contextObj = this.getContextObject(attribute);
        if (contextObj == null) {
            return null;
        }
        return CoreUtilities.asType(contextObj, dClass, this.context);
    }

    public final ObjectTag getParamObject() {
        return this.getContextObject(1);
    }

    public final ObjectTag getContextObject(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return null;
        }
        ObjectTag tagged = this.contexts[attribute];
        if (tagged != null) {
            return tagged;
        }
        AttributeComponent component = this.attributes[attribute];
        if (component.paramParsed == null) {
            String inp = this.attributes[attribute].rawParam;
            if (inp == null) {
                return null;
            }
            component.paramParsed = TagManager.parseTextToTag(component.rawParam, this.context);
        }
        if (component.paramParsed == null) {
            return null;
        }
        this.contexts[attribute] = tagged = component.paramParsed.parse(this.context);
        return tagged;
    }

    public final String getParam() {
        return CoreUtilities.stringifyNullPass(this.getParamObject());
    }

    @Deprecated
    public final String getContext(int attribute) {
        return CoreUtilities.stringifyNullPass(this.getContextObject(attribute));
    }

    public final ElementTag getParamElement() {
        ObjectTag obj = this.getParamObject();
        if (obj == null) {
            return null;
        }
        return obj.asElement();
    }

    public boolean hasAlternative() {
        if (this.hadAlternative) {
            return true;
        }
        return this.getFallbackTagIndex() != -1;
    }

    public int getFallbackTagIndex() {
        for (int i = this.fulfilled + 1; i < this.attributes.length; ++i) {
            if (!fallbackTags.containsKey(this.attributes[i].key)) continue;
            return i;
        }
        return -1;
    }

    public void setHadAlternative(boolean hadAlternative) {
        this.hadAlternative = hadAlternative;
        if (this.context != null && this.context.debug && hadAlternative) {
            this.context = this.context.clone();
            this.context.debug = false;
        }
    }

    public final long getLongParam() {
        block3: {
            try {
                if (this.hasParam()) {
                    return Long.parseLong(this.getParam());
                }
            }
            catch (Exception ex) {
                if (this.hasAlternative()) break block3;
                Debug.echoError("Tag <" + this + "<W>> has invalid input - expected a (non-decimal) number, got '<A>" + this.getParam() + "<W>'...: " + ex.getMessage());
            }
        }
        return 0L;
    }

    public final int getIntParam() {
        return this.getIntContext(1);
    }

    @Deprecated
    public final int getIntContext(int attribute) {
        block3: {
            try {
                if (this.hasContext(attribute)) {
                    return Integer.parseInt(this.getContext(attribute));
                }
            }
            catch (Exception ex) {
                if (this.hasAlternative()) break block3;
                Debug.echoError("Tag <" + this + "<W>> has invalid input - expected a (non-decimal) number, got '<A>" + this.getContext(attribute) + "<W>'...: " + ex.getMessage());
            }
        }
        return 0;
    }

    public final double getDoubleParam() {
        return this.getDoubleContext(1);
    }

    @Deprecated
    public double getDoubleContext(int attribute) {
        block3: {
            try {
                if (this.hasContext(attribute)) {
                    return Double.parseDouble(this.getContext(attribute));
                }
            }
            catch (NumberFormatException ex) {
                if (this.hasAlternative()) break block3;
                Debug.echoError("Tag <" + this + "<W>> has invalid input - expected a decimal number, got '<A>" + this.getContext(attribute) + "<W>'...: " + ex.getMessage());
            }
        }
        return 0.0;
    }

    public void echoError(Throwable ex) {
        if (!this.hasAlternative()) {
            Debug.echoError(ex);
        }
    }

    public void echoError(String message) {
        if (!this.hasAlternative()) {
            Debug.echoError(this.context, message);
        }
    }

    public String getAttribute(int num) {
        if ((num += this.fulfilled - 1) < 0 || num >= this.attributes.length) {
            return "";
        }
        return this.attributes[num].toString();
    }

    public String getAttributeWithoutParam(int num) {
        if ((num += this.fulfilled - 1) < 0 || num >= this.attributes.length) {
            return "";
        }
        return this.attributes[num].key;
    }

    public String filledString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fulfilled; ++i) {
            if (this.contexts[i] != null) {
                sb.append(this.attributes[i].key).append("[").append(this.contexts[i]).append("].");
                continue;
            }
            sb.append(this.attributes[i].toString()).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public String unfilledString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.fulfilled; i < this.attributes.length; ++i) {
            if (this.contexts[i] != null) {
                sb.append(this.attributes[i].key).append("[").append(this.contexts[i]).append("].");
                continue;
            }
            sb.append(this.attributes[i].toString()).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.filled != null) {
                switch (this.filled[i]) {
                    case 0: {
                        sb.append("<Y>");
                        break;
                    }
                    case 1: {
                        sb.append("<GR>");
                        break;
                    }
                    case 2: {
                        sb.append("<R>");
                        break;
                    }
                    case 3: {
                        sb.append("<LG>");
                    }
                }
            } else {
                sb.append(i < this.fulfilled ? "<GR>" : (i == this.fulfilled ? "<R>" : "<Y>"));
            }
            sb.append(this.attributes[i].key);
            if (this.contexts[i] != null) {
                sb.append("<LG>[<A>").append(this.contexts[i]).append("<LG>].");
                continue;
            }
            if (this.attributes[i].rawParam != null) {
                sb.append("<LG>[").append(this.filled == null || this.filled[i] != 3 ? "<Y>" : "").append(this.attributes[i].rawParam).append("<LG>].");
                continue;
            }
            sb.append("<LG>.");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    static {
        fallbackTags.put("if_null", new TagManager.TagBaseData("if_null", ObjectTag.class, attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return attribute.getParamObject();
        }, false));
        fallbackTags.put("exists", new TagManager.TagBaseData("exists", ElementTag.class, attribute -> new ElementTag(false), false));
        fallbackTags.put("is_truthy", new TagManager.TagBaseData("is_truthy", ElementTag.class, attribute -> new ElementTag(false), false));
    }

    public static class AttributeComponent {
        public final String rawKey;
        public final String key;
        public final String rawParam;
        public ParseableTag paramParsed;
        public ObjectTagProcessor.TagData<? extends ObjectTag, ? extends ObjectTag> data;

        public AttributeComponent(String inp) {
            if (inp.endsWith("]") && CoreUtilities.contains(inp, '[')) {
                int ind = inp.indexOf(91);
                this.rawKey = inp.substring(0, ind);
                this.rawParam = inp.substring(ind + 1, inp.length() - 1);
            } else {
                this.rawKey = inp;
                this.rawParam = null;
            }
            this.key = CoreUtilities.toLowerCase(this.rawKey);
        }

        public String toString() {
            if (this.rawParam != null) {
                return this.key + "[" + this.rawParam + "]";
            }
            return this.key;
        }
    }

    public static class OverridingDefinitionProvider
    implements DefinitionProvider {
        public DefinitionProvider originalProvider;
        public MapTag altDefs = new MapTag();

        public OverridingDefinitionProvider(DefinitionProvider original) {
            this.originalProvider = original;
        }

        @Override
        public void addDefinition(String definition, String value) {
            this.originalProvider.addDefinition(definition, value);
        }

        @Override
        public void addDefinition(String definition, ObjectTag value) {
            this.originalProvider.addDefinition(definition, value);
        }

        @Override
        public MapTag getAllDefinitions() {
            return this.originalProvider.getAllDefinitions();
        }

        @Override
        public ObjectTag getDefinitionObject(String definition) {
            ObjectTag result = this.altDefs.getDeepObject(CoreUtilities.toLowerCase(definition));
            if (result != null) {
                return result;
            }
            return this.originalProvider.getDefinitionObject(definition);
        }

        @Override
        public String getDefinition(String definition) {
            ObjectTag result = this.altDefs.getDeepObject(CoreUtilities.toLowerCase(definition));
            if (result != null) {
                return result.toString();
            }
            return this.originalProvider.getDefinition(definition);
        }

        @Override
        public boolean hasDefinition(String definition) {
            ObjectTag result = this.altDefs.getDeepObject(CoreUtilities.toLowerCase(definition));
            if (result != null) {
                return true;
            }
            return this.originalProvider.hasDefinition(definition);
        }

        @Override
        public void removeDefinition(String definition) {
            this.originalProvider.removeDefinition(definition);
        }
    }
}

