/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAge;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class AgeCommand
extends AbstractCommand {
    public AgeCommand() {
        this.setName("age");
        this.setSyntax("age [<entity>|...] (adult/baby/<age>) (lock)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("agetype") && arg.matchesEnum(AgeType.class)) {
                scriptEntry.addObject("agetype", (Object)AgeType.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("age") && arg.matchesInteger()) {
                scriptEntry.addObject("age", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lock") && arg.matches("lock")) {
                scriptEntry.addObject("lock", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("No valid entities specified.");
        }
        scriptEntry.defaultObject("age", new ElementTag(1));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        AgeType ageType = (AgeType)((Object)scriptEntry.getObject("agetype"));
        int age = scriptEntry.getElement("age").asInt();
        boolean lock = scriptEntry.hasObject("lock");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), lock ? AgeCommand.db("lock", true) : "", ageType != null ? AgeCommand.db("agetype", (Object)ageType) : AgeCommand.db("age", age), AgeCommand.db("entities", entities));
        }
        for (EntityTag entity : entities) {
            if (!entity.isSpawned()) continue;
            if (EntityAge.describes(entity)) {
                EntityAge property = EntityAge.getFrom(entity);
                if (ageType != null) {
                    if (ageType.equals((Object)AgeType.BABY)) {
                        property.setAge(-24000);
                    } else {
                        property.setAge(0);
                    }
                } else {
                    property.setAge(age);
                }
                property.setLock(lock);
                continue;
            }
            Debug.echoError(scriptEntry, entity.identify() + " is not ageable!");
        }
    }

    private static enum AgeType {
        ADULT,
        BABY;

    }
}

