/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class ItemQuantity
implements Property {
    public static final String[] handledTags = new String[]{"quantity", "qty", "max_stack"};
    public static final String[] handledMechs = new String[]{"quantity"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemQuantity getFrom(ObjectTag _item) {
        if (!ItemQuantity.describes(_item)) {
            return null;
        }
        return new ItemQuantity((ItemTag)_item);
    }

    private ItemQuantity(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("qty")) {
            BukkitImplDeprecations.qtyTags.warn(attribute.context);
            return new ElementTag(this.item.getItemStack().getAmount()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("quantity")) {
            return new ElementTag(this.item.getItemStack().getAmount()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_stack")) {
            return new ElementTag(this.item.getItemStack().getMaxStackSize()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.item.getItemStack().getAmount() > 1) {
            return String.valueOf(this.item.getItemStack().getAmount());
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "quantity";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("quantity") && mechanism.requireInteger()) {
            this.item.setAmount(mechanism.getValue().asInt());
        }
    }
}

