/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;

public class PlayerSwapsItemsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerSwapsItemsScriptEvent instance;
    public PlayerTag player;
    public PlayerSwapHandItemsEvent event;

    public PlayerSwapsItemsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player swaps items");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.switches.containsKey("main") && !new ItemTag(this.event.getMainHandItem()).tryAdvancedMatcher(path.switches.get("main"))) {
            return false;
        }
        if (path.switches.containsKey("offhand") && !new ItemTag(this.event.getOffHandItem()).tryAdvancedMatcher(path.switches.get("offhand"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerSwapsItems";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.startsWith("main:")) {
                this.event.setMainHandItem(ItemTag.valueOf(determination.substring("main:".length()), path.container).getItemStack());
                return true;
            }
            if (lower.startsWith("offhand:")) {
                this.event.setOffHandItem(ItemTag.valueOf(determination.substring("offhand:".length()), path.container).getItemStack());
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("main")) {
            return new ItemTag(this.event.getMainHandItem());
        }
        if (name.equals("offhand")) {
            return new ItemTag(this.event.getOffHandItem());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerSwapsItems(PlayerSwapHandItemsEvent event) {
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.event = event;
        this.fire((Event)event);
    }
}

