/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class PlayerThrowsEggScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerThrowsEggScriptEvent instance;
    public EntityTag egg;
    public PlayerEggThrowEvent event;

    public PlayerThrowsEggScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player throws (hatching|non-hatching) egg");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("hatching") && !this.event.isHatching()) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("non-hatching") && this.event.isHatching()) {
            return false;
        }
        if (!this.runInCheck(path, this.egg.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerThrowsEgg";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (EntityTag.matches(determination)) {
            this.event.setHatching(true);
            EntityType type = EntityTag.valueOf(determination, this.getTagContext(path)).getBukkitEntityType();
            this.event.setHatchingType(type);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("is_hatching")) {
            return new ElementTag(this.event.isHatching());
        }
        if (name.equals("egg")) {
            return this.egg;
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        this.event.setHatching(!this.cancelled);
    }

    @EventHandler
    public void onPlayerThrowsEgg(PlayerEggThrowEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Egg eggEntity = event.getEgg();
        EntityTag.rememberEntity((Entity)eggEntity);
        this.egg = new EntityTag((Entity)event.getEgg());
        this.event = event;
        this.cancelled = false;
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)eggEntity);
    }
}

