/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.WebserverWebRequestScriptEvent;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class WebServerCommand
extends AbstractCommand {
    public static HashMap<Integer, WebserverInstance> webservers = new HashMap();

    public WebServerCommand() {
        this.setName("webserver");
        this.setSyntax("webserver [start/stop] (port:<#>) (ignore_errors)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
        this.setPrefixesHandled("port");
        this.setBooleansHandled("ignore_errors");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("mode") && arg.matchesEnum(Mode.class)) {
                scriptEntry.addObject("mode", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("mode")) {
            throw new InvalidArgumentsException("Missing start/stop argument.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (!CoreConfiguration.allowWebserver) {
            Debug.echoError(scriptEntry, "WebServer command disabled in config.yml!");
            return;
        }
        ElementTag port = scriptEntry.argForPrefixAsElement("port", "8080");
        ElementTag mode = scriptEntry.getElement("mode");
        boolean ignoreErrors = scriptEntry.argAsBoolean("ignore_errors");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), mode, port, WebServerCommand.db("ignore_errors", ignoreErrors));
        }
        if (!port.isInt()) {
            throw new InvalidArgumentsRuntimeException("Invalid port, not a number");
        }
        int portNum = port.asInt();
        switch (mode.asEnum(Mode.class)) {
            case START: {
                WebserverInstance instance = webservers.get(portNum);
                if (instance != null) {
                    Debug.echoError("Server already running at port " + portNum + ", cannot start a new one.");
                    return;
                }
                instance = new WebserverInstance();
                instance.port = portNum;
                instance.ignoreErrors = ignoreErrors;
                try {
                    instance.start();
                    webservers.put(portNum, instance);
                    Debug.echoDebug((Debuggable)scriptEntry, "Webserver at port " + portNum + " started.");
                }
                catch (IOException ex) {
                    Debug.echoError("Could not start webserver due to IOException. Is the port correct?");
                    Debug.echoError(ex);
                }
                break;
            }
            case STOP: {
                WebserverInstance instance = webservers.remove(portNum);
                if (instance == null) {
                    Debug.echoDebug((Debuggable)scriptEntry, "No server running at port " + portNum + ", ignoring 'stop' instruction.");
                    return;
                }
                instance.stop();
                Debug.echoDebug((Debuggable)scriptEntry, "Webserver at port " + portNum + " stopped.");
                break;
            }
        }
    }

    public static enum Mode {
        START,
        STOP;

    }

    public static class WebserverInstance {
        public int port;
        public HttpServer server;
        public boolean ignoreErrors;

        public void handleRequest(HttpExchange exchange) {
            WebserverWebRequestScriptEvent.fire(this, exchange);
        }

        public void executor(Runnable command) {
            DenizenCore.schedule(new OneTimeSchedulable(command, 0.0f));
        }

        public void start() throws IOException {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/", this::handleRequest);
            this.server.setExecutor(this::executor);
            this.server.start();
        }

        public void stop() {
            this.server.stop(0);
        }
    }
}

