/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.utilities.DefinitionProvider;
import com.denizenscript.denizencore.utilities.SimpleDefinitionProvider;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public abstract class TagContext
implements Debuggable,
Cloneable {
    public boolean debug;
    public ShowErrorsMethod showErrors = TagContext::defaultShowErrors;
    public ScriptEntry entry;
    public ScriptTag script;
    public DefinitionProvider definitionProvider;
    public ContextSource contextSource;

    private static boolean defaultShowErrors() {
        return true;
    }

    public TagContext clone() {
        try {
            return (TagContext)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public boolean showErrors() {
        return this.debug || this.showErrors != null && this.showErrors.showErrors();
    }

    @Override
    public boolean shouldDebug() {
        return this.debug;
    }

    public TagContext(ScriptEntry entry) {
        if (entry != null) {
            this.entry = entry;
            this.script = entry.getScript();
            this.debug = entry.shouldDebug();
            if (entry.getResidingQueue() != null) {
                this.definitionProvider = entry.getResidingQueue();
                this.contextSource = entry.getResidingQueue().contextSource;
            }
        } else {
            this.debug = true;
        }
    }

    public TagContext(boolean debug, ScriptEntry entry, ScriptTag script) {
        this(debug, entry, script, null);
    }

    public TagContext(boolean debug, ScriptEntry entry, ScriptTag script, DefinitionProvider definitionProvider) {
        this.debug = debug;
        this.entry = entry;
        this.script = script;
        DefinitionProvider definitionProvider2 = definitionProvider != null ? definitionProvider : (this.definitionProvider = entry != null ? entry.getResidingQueue() : new SimpleDefinitionProvider());
        if (entry != null && entry.getResidingQueue() != null) {
            this.contextSource = entry.getResidingQueue().contextSource;
        }
    }

    public abstract ScriptEntryData getScriptEntryData();

    @FunctionalInterface
    public static interface ShowErrorsMethod {
        public boolean showErrors();
    }
}

