/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;

public class PlayerUsesPortalScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerUsesPortalScriptEvent instance;
    public LocationTag to;
    public LocationTag from;
    public PlayerPortalEvent event;

    public PlayerUsesPortalScriptEvent() {
        this.registerCouldMatcher("player uses portal");
        this.registerSwitches("from", "to");
        instance = this;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.to) && !this.runInCheck(path, this.from)) {
            return false;
        }
        if (path.switches.containsKey("from") && !this.from.tryAdvancedMatcher(path.switches.get("from"))) {
            return false;
        }
        if (this.to != null && path.switches.containsKey("to") && !this.to.tryAdvancedMatcher(path.switches.get("to"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerUsesPortal";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = CoreUtilities.toLowerCase(determinationObj.toString());
            if (determination.startsWith("can_create:")) {
                this.event.setCanCreatePortal(new ElementTag(determination.substring("can_create:".length())).asBoolean());
                return true;
            }
            if (determination.startsWith("creation_radius:")) {
                this.event.setCreationRadius(new ElementTag(determination.substring("creation_radius:".length())).asInt());
                return true;
            }
            if (determination.startsWith("search_radius:")) {
                this.event.setSearchRadius(new ElementTag(determination.substring("search_radius:".length())).asInt());
                return true;
            }
        }
        if (determinationObj.canBeType(LocationTag.class)) {
            this.to = determinationObj.asType(LocationTag.class, this.getTagContext(path));
            this.event.setTo((Location)this.to);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "to": {
                return this.to;
            }
            case "from": {
                return this.from;
            }
            case "can_create": {
                return new ElementTag(this.event.getCanCreatePortal());
            }
            case "creation_radius": {
                return new ElementTag(this.event.getCreationRadius());
            }
            case "search_radius": {
                return new ElementTag(this.event.getSearchRadius());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEntersPortal(PlayerPortalEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.to = event.getTo() == null ? null : new LocationTag(event.getTo());
        this.from = new LocationTag(event.getFrom());
        this.event = event;
        this.fire((Event)event);
    }
}

