/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Minecart;

public class EntitySpeed
implements Property {
    public static final String[] handledTags = new String[]{"speed"};
    public static final String[] handledMechs = new String[]{"speed"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        EntityTag ent = (EntityTag)entity;
        if (ent.isLivingEntity()) {
            return true;
        }
        return ent.getBukkitEntity() instanceof Boat || ent.getBukkitEntity() instanceof Minecart;
    }

    public static EntitySpeed getFrom(ObjectTag entity) {
        if (!EntitySpeed.describes(entity)) {
            return null;
        }
        return new EntitySpeed((EntityTag)entity);
    }

    private EntitySpeed(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.getSpeed().asString();
    }

    @Override
    public String getPropertyId() {
        return "speed";
    }

    public ElementTag getSpeed() {
        if (this.entity.isLivingEntity()) {
            return new ElementTag(NMSHandler.entityHelper.getSpeed(this.entity.getBukkitEntity()));
        }
        if (this.entity.getBukkitEntity() instanceof Boat) {
            return new ElementTag(((Boat)this.entity.getBukkitEntity()).getMaxSpeed());
        }
        if (this.entity.getBukkitEntity() instanceof Minecart) {
            return new ElementTag(((Minecart)this.entity.getBukkitEntity()).getMaxSpeed());
        }
        return new ElementTag(0.0);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("speed")) {
            return this.getSpeed().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("speed") && mechanism.requireDouble()) {
            double value = mechanism.getValue().asDouble();
            if (this.entity.isLivingEntity()) {
                NMSHandler.entityHelper.setSpeed(this.entity.getBukkitEntity(), value);
            } else if (this.entity.getBukkitEntity() instanceof Boat) {
                ((Boat)this.entity.getBukkitEntity()).setMaxSpeed(value);
            } else if (this.entity.getBukkitEntity() instanceof Minecart) {
                ((Minecart)this.entity.getBukkitEntity()).setMaxSpeed(value);
            }
        }
    }
}

