/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.EntityType;

public class VanillaTagHelper {
    public static HashMap<Material, HashSet<String>> tagsByMaterial = new HashMap();
    public static HashMap<String, HashSet<Material>> materialTagsByKey = new HashMap();
    public static HashMap<EntityType, HashSet<String>> tagsByEntity = new HashMap();
    public static HashMap<String, HashSet<EntityType>> entityTagsByKey = new HashMap();

    static <T extends Keyed> void add(Tag<T> tag, HashMap<T, HashSet<String>> tagByObj, HashMap<String, HashSet<T>> objByTag) {
        objByTag.computeIfAbsent(tag.getKey().getKey(), k -> new HashSet()).addAll(tag.getValues());
        for (Keyed obj : tag.getValues()) {
            tagByObj.computeIfAbsent(obj, k -> new HashSet()).add(tag.getKey().getKey());
        }
    }

    static void addMaterialTag(Tag<Material> tag) {
        VanillaTagHelper.add(tag, tagsByMaterial, materialTagsByKey);
    }

    static void addEntityTag(Tag<EntityType> tag) {
        VanillaTagHelper.add(tag, tagsByEntity, entityTagsByKey);
    }

    static {
        for (Tag tag : Bukkit.getTags((String)"blocks", Material.class)) {
            VanillaTagHelper.addMaterialTag((Tag<Material>)tag);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
            for (Tag tag : Bukkit.getTags((String)"fluids", Material.class)) {
                VanillaTagHelper.addMaterialTag((Tag<Material>)tag);
            }
            for (Tag tag : Bukkit.getTags((String)"entity_types", EntityType.class)) {
                VanillaTagHelper.addEntityTag((Tag<EntityType>)tag);
            }
        }
        for (Tag tag : Bukkit.getTags((String)"items", Material.class)) {
            VanillaTagHelper.addMaterialTag((Tag<Material>)tag);
        }
    }
}

