/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ChunkLoadCommand
extends AbstractCommand
implements Listener {
    Map<ChunkCoordinate, Long> chunkDelays = new HashMap<ChunkCoordinate, Long>();

    public ChunkLoadCommand() {
        this.setName("chunkload");
        this.setSyntax("chunkload ({add}/remove/removeall) [<chunk>|...] (duration:<value>)");
        this.setRequiredArguments(1, 3);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        if (Depends.citizens != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new ChunkLoadCommandNPCEvents(), (Plugin)Denizen.getInstance());
        }
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesEnum(Action.class) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", new ElementTag(arg.getValue().toUpperCase()));
                if (!arg.getValue().equalsIgnoreCase("removeall")) continue;
                scriptEntry.addObject("location", new ListTag((Collection<? extends ObjectTag>)Collections.singletonList(new LocationTag((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0))));
                continue;
            }
            if (arg.matchesArgumentList(ChunkTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesArgumentList(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", new ElementTag("ADD"));
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new DurationTag(0));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag action = scriptEntry.getElement("action");
        ListTag chunklocs = (ListTag)scriptEntry.getObjectTag("location");
        DurationTag length = (DurationTag)scriptEntry.getObjectTag("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), action, chunklocs, length);
        }
        for (String chunkText : chunklocs) {
            Chunk chunk;
            if (ChunkTag.matches(chunkText)) {
                chunk = ChunkTag.valueOf(chunkText, scriptEntry.context).getChunk();
            } else if (LocationTag.matches(chunkText)) {
                chunk = LocationTag.valueOf(chunkText, scriptEntry.context).getChunk();
            } else {
                Debug.echoError("Chunk input '" + chunkText + "' is invalid.");
                return;
            }
            ChunkCoordinate coord = new ChunkCoordinate(chunk);
            switch (Action.valueOf(action.asString())) {
                case ADD: {
                    if (length.getSeconds() != 0.0) {
                        this.chunkDelays.put(coord, CoreUtilities.monotonicMillis() + length.getMillis());
                    } else {
                        this.chunkDelays.put(coord, 0L);
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "...added chunk " + chunk.getX() + ", " + chunk.getZ() + " with a delay of " + length.getSeconds() + " seconds.");
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    chunk.addPluginChunkTicket((Plugin)Denizen.getInstance());
                    if (!(length.getSeconds() > 0.0)) break;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
                        if (this.chunkDelays.containsKey(coord) && this.chunkDelays.get(coord) <= CoreUtilities.monotonicMillis()) {
                            chunk.removePluginChunkTicket((Plugin)Denizen.getInstance());
                            this.chunkDelays.remove(coord);
                        }
                    }, length.getTicks() + 20L);
                    break;
                }
                case REMOVE: {
                    if (this.chunkDelays.containsKey(coord)) {
                        this.chunkDelays.remove(coord);
                        chunk.removePluginChunkTicket((Plugin)Denizen.getInstance());
                        Debug.echoDebug((Debuggable)scriptEntry, "...allowing unloading of chunk " + chunk.getX() + ", " + chunk.getZ());
                        break;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Chunk '" + coord + "' was not on the load list, ignoring.");
                    break;
                }
                case REMOVEALL: {
                    Debug.echoDebug((Debuggable)scriptEntry, "...allowing unloading of all stored chunks");
                    for (ChunkCoordinate loopCoord : this.chunkDelays.keySet()) {
                        loopCoord.getChunk().getChunk().removePluginChunkTicket((Plugin)Denizen.getInstance());
                    }
                    this.chunkDelays.clear();
                }
            }
        }
    }

    public class ChunkLoadCommandNPCEvents
    implements Listener {
        @EventHandler
        public void stopDespawn(NPCDespawnEvent e) {
            if (e.getNPC() == null || !e.getNPC().isSpawned()) {
                return;
            }
            Chunk chnk = e.getNPC().getEntity().getLocation().getChunk();
            ChunkCoordinate coord = new ChunkCoordinate(chnk);
            if (ChunkLoadCommand.this.chunkDelays.containsKey(coord)) {
                if (ChunkLoadCommand.this.chunkDelays.get(coord) == 0L) {
                    e.setCancelled(true);
                } else if (CoreUtilities.monotonicMillis() < ChunkLoadCommand.this.chunkDelays.get(coord)) {
                    e.setCancelled(true);
                } else {
                    ChunkLoadCommand.this.chunkDelays.remove(coord);
                }
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        REMOVEALL;

    }
}

