/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public interface ObjectTag {
    public String getPrefix();

    default public String debuggable() {
        return this.identify();
    }

    public boolean isUnique();

    public String getObjectType();

    public String identify();

    default public String savable() {
        return this.refreshState().identify();
    }

    public String identifySimple();

    default public ObjectTag duplicate() {
        return this;
    }

    default public ObjectTag fixAfterProperties() {
        return this;
    }

    public ObjectTag setPrefix(String var1);

    default public <T extends ObjectTag> T asType(Class<T> type, TagContext context) {
        if (this.getClass() == type) {
            return (T)this;
        }
        CoreUtilities.TagTypeConverter converter = CoreUtilities.typeConverters.get(type);
        if (converter != null) {
            return (T)converter.convert(this, context);
        }
        return ObjectFetcher.getObjectFrom(type, this.toString(), context);
    }

    default public boolean shouldBeType(Class<? extends ObjectTag> type) {
        if (type == ElementTag.class || type == ObjectTag.class) {
            return true;
        }
        if (this.getClass() == type) {
            return true;
        }
        CoreUtilities.TypeComparisonRunnable comp = CoreUtilities.typeShouldBeCheckers.get(type);
        if (comp != null) {
            return comp.doesCompare(this);
        }
        return false;
    }

    default public boolean canBeType(Class<? extends ObjectTag> type) {
        if (type == ObjectTag.class) {
            return true;
        }
        if (this.getClass() == type) {
            return true;
        }
        CoreUtilities.TypeComparisonRunnable comp = CoreUtilities.typeCheckers.get(type);
        if (comp != null && !comp.doesCompare(this)) {
            return false;
        }
        return ObjectFetcher.checkMatch(type, this.toString());
    }

    default public ElementTag asElement() {
        return new ElementTag(this.toString());
    }

    default public ObjectTag getObjectAttribute(Attribute attribute) {
        return null;
    }

    default public ObjectTag getNextObjectTypeDown() {
        return new ElementTag(this.identify());
    }

    default public ObjectTag specialTagProcessing(Attribute attribute) {
        return null;
    }

    default public boolean isTruthy() {
        return true;
    }

    default public ObjectFetcher.ObjectType<? extends ObjectTag> getDenizenObjectType() {
        return ObjectFetcher.objectsByClass.get(this.getClass());
    }

    default public boolean advancedMatches(String matcher) {
        return ScriptEvent.runGenericCheck(matcher, this.identify());
    }

    default public boolean tryAdvancedMatcher(String matcher) {
        if (matcher == null || matcher.isEmpty()) {
            return false;
        }
        if (matcher.startsWith("!")) {
            return !this.tryAdvancedMatcher(matcher.substring(1));
        }
        ObjectFetcher.ObjectType<? extends ObjectTag> thisType = this.getDenizenObjectType();
        if (thisType != null && thisType.tagProcessor != null) {
            for (ObjectTagProcessor.CustomMatcher<ObjectTag> customMatcher : thisType.tagProcessor.custommatchers) {
                Boolean result = customMatcher.tryMatch(this, matcher);
                if (result == null) continue;
                return result;
            }
        }
        return this.advancedMatches(matcher);
    }

    default public ObjectTag refreshState() {
        return this;
    }
}

