/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class CauldronLevelChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public CauldronLevelChangeEvent event;

    public CauldronLevelChangeScriptEvent() {
        this.registerCouldMatcher("cauldron level changes|raises|lowers");
        this.registerSwitches("cause");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!CauldronLevelChangeScriptEvent.runGenericSwitchCheck(path, "cause", this.event.getReason().name())) {
            return false;
        }
        String changeType = path.eventArgLowerAt(2);
        if (changeType.equals("raises") ? this.event.getNewLevel() <= this.event.getOldLevel() : (changeType.equals("lowers") ? this.event.getNewLevel() >= this.event.getOldLevel() : !changeType.equals("changes"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setNewLevel(((ElementTag)determinationObj).asInt());
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "cause": {
                return new ElementTag(this.event.getReason().name());
            }
            case "old_level": {
                return new ElementTag(this.event.getOldLevel());
            }
            case "new_level": {
                return new ElementTag(this.event.getNewLevel());
            }
            case "entity": {
                if (this.event.getEntity() == null) break;
                return new EntityTag(this.event.getEntity()).getDenizenObject();
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCauldronLevelChange(CauldronLevelChangeEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

