/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class InvisibleCommand
extends AbstractCommand {
    public static HashMap<UUID, HashMap<UUID, Boolean>> invisibleEntities = new HashMap();

    public InvisibleCommand() {
        this.setName("invisible");
        this.setSyntax("invisible (<entity>) (state:true/false/toggle/reset) (for:<player>|...)");
        this.setPrefixesHandled("for");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("state:", Action.values());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("state", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matches("player") && Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryPlayer(scriptEntry).getDenizenEntity());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matches("npc") && Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryNPC(scriptEntry).getDenizenEntity());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("target", arg.asType(EntityTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("state", new ElementTag("true"));
        scriptEntry.defaultObject("target", Utilities.entryDefaultEntity(scriptEntry, true));
    }

    public static void setInvisibleForPlayer(EntityTag target, PlayerTag player, boolean invisible) {
        if (target == null || target.getUUID() == null || player == null) {
            return;
        }
        NetworkInterceptHelper.enable();
        boolean wasModified = !invisibleEntities.containsKey(target.getUUID());
        HashMap playerMap = invisibleEntities.computeIfAbsent(target.getUUID(), k -> new HashMap());
        wasModified = !playerMap.containsKey(player.getUUID()) || (Boolean)playerMap.get(player.getUUID()) != invisible || wasModified;
        playerMap.put(player.getUUID(), invisible);
        if (wasModified && player.isOnline()) {
            NMSHandler.packetHelper.sendEntityMetadataFlagsUpdate(player.getPlayerEntity(), target.getBukkitEntity());
        }
    }

    public void setInvisible(EntityTag entity, boolean invisible) {
        if (entity.isCitizensNPC()) {
            ((InvisibleTrait)entity.getDenizenNPC().getCitizen().getOrAddTrait(InvisibleTrait.class)).setInvisible(invisible);
        } else if (entity.getBukkitEntity() instanceof ArmorStand) {
            ((ArmorStand)entity.getBukkitEntity()).setVisible(!invisible);
        } else if (entity.getBukkitEntity() instanceof ItemFrame) {
            ((ItemFrame)entity.getBukkitEntity()).setVisible(!invisible);
        } else if (entity.isLivingEntity() && !entity.isFake) {
            entity.getLivingEntity().setInvisible(invisible);
            if (!invisible) {
                entity.getLivingEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
            }
        } else {
            NMSHandler.entityHelper.setInvisible(entity.getBukkitEntity(), invisible);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        if (target == null) {
            Debug.echoError(scriptEntry, "Must specify a valid target.");
            return;
        }
        ElementTag state = scriptEntry.getElement("state");
        List<PlayerTag> forPlayers = scriptEntry.argForPrefixList("for", PlayerTag.class, true);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), target, state, InvisibleCommand.db("for", forPlayers));
        }
        switch (state.asEnum(Action.class)) {
            case TRUE: 
            case FALSE: {
                if (forPlayers == null) {
                    this.setInvisible(target, state.asBoolean());
                    break;
                }
                boolean invisible = state.asBoolean();
                for (PlayerTag player : forPlayers) {
                    InvisibleCommand.setInvisibleForPlayer(target, player, invisible);
                }
                break;
            }
            case TOGGLE: {
                if (forPlayers == null) {
                    this.setInvisible(target, InvisibleCommand.isInvisible(target.getBukkitEntity(), null, false) == false);
                    break;
                }
                for (PlayerTag player : forPlayers) {
                    InvisibleCommand.setInvisibleForPlayer(target, player, InvisibleCommand.isInvisible(target.getBukkitEntity(), player.getUUID(), false) == false);
                }
                break;
            }
            case RESET: {
                HashMap<UUID, Boolean> playerMap = invisibleEntities.get(target.getUUID());
                if (playerMap == null) {
                    return;
                }
                HashSet<UUID> playersToUpdate = new HashSet<UUID>();
                if (forPlayers == null) {
                    playersToUpdate.addAll(playerMap.keySet());
                    invisibleEntities.remove(target.getUUID());
                } else {
                    for (PlayerTag playerTag : forPlayers) {
                        playerMap.remove(playerTag.getUUID());
                        playersToUpdate.add(playerTag.getUUID());
                    }
                    if (playerMap.isEmpty()) {
                        invisibleEntities.remove(target.getUUID());
                    }
                }
                if (playersToUpdate.isEmpty()) break;
                for (Player player : NMSHandler.entityHelper.getPlayersThatSee(target.getBukkitEntity())) {
                    if (!playersToUpdate.contains(player.getUniqueId())) continue;
                    NMSHandler.packetHelper.sendEntityMetadataFlagsUpdate(player, target.getBukkitEntity());
                }
                break;
            }
        }
    }

    public static Boolean isInvisible(Entity entity, UUID player, boolean fakeOnly) {
        HashMap<UUID, Boolean> playerMap;
        if (entity == null) {
            return null;
        }
        if (player != null && (playerMap = invisibleEntities.get(entity.getUniqueId())) != null && playerMap.containsKey(player)) {
            return playerMap.get(player);
        }
        if (fakeOnly) {
            return null;
        }
        if (EntityTag.isCitizensNPC(entity)) {
            InvisibleTrait invisibleTrait = (InvisibleTrait)NPCTag.fromEntity(entity).getCitizen().getTraitNullable(InvisibleTrait.class);
            return invisibleTrait != null && invisibleTrait.isInvisible();
        }
        if (entity instanceof ArmorStand) {
            return !((ArmorStand)entity).isVisible();
        }
        if (entity instanceof ItemFrame) {
            return !((ItemFrame)entity).isVisible();
        }
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).isInvisible() || ((LivingEntity)entity).hasPotionEffect(PotionEffectType.INVISIBILITY);
        }
        return NMSHandler.entityHelper.isInvisible(entity);
    }

    static enum Action {
        TRUE,
        FALSE,
        TOGGLE,
        RESET;

    }
}

