/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.SoundLookup;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class PlayerHearsSoundScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerHearsSoundScriptEvent instance;
    public static boolean enabled;
    public Player player;
    public String soundName;
    public String category;
    public boolean isCustom;
    public Entity entity;
    public Location location;
    public float volume;
    public float pitch;

    public PlayerHearsSoundScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player hears sound");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.player);
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        enabled = true;
    }

    @Override
    public void destroy() {
        enabled = false;
        this.entity = null;
        this.player = null;
        this.location = null;
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "sound_key": {
                return new ElementTag(this.soundName);
            }
            case "sound_name": {
                return this.isCustom ? null : new ElementTag(SoundLookup.keyToSound.get(this.soundName).name());
            }
            case "category": {
                return new ElementTag(this.category);
            }
            case "is_custom": {
                return new ElementTag(this.isCustom);
            }
            case "source_entity": {
                return this.entity == null ? null : new EntityTag(this.entity);
            }
            case "location": {
                return new LocationTag(this.location);
            }
            case "volume": {
                return new ElementTag(this.volume);
            }
            case "pitch": {
                return new ElementTag(this.pitch);
            }
        }
        return super.getContext(name);
    }

    public boolean run(Player player, String soundName, String category, boolean isCustom, Entity entity, Location location, float volume, float pitch) {
        this.player = player;
        this.soundName = soundName;
        this.category = category;
        this.isCustom = isCustom;
        this.entity = entity;
        this.location = location == null ? entity.getLocation() : location;
        this.volume = volume;
        this.pitch = pitch;
        ScriptEvent fired = this.fire();
        return fired.cancelled;
    }
}

