/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerStepsOnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public LocationTag previous_location;
    public LocationTag new_location;
    public PlayerMoveEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player steps on")) {
            return false;
        }
        return PlayerStepsOnScriptEvent.couldMatchBlock(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(3);
        MaterialTag material = new MaterialTag(this.location.getBlock());
        if (!material.tryAdvancedMatcher(mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "previous_location": {
                return this.previous_location;
            }
            case "new_location": {
                return this.new_location;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerStepsOn(PlayerMoveEvent event) {
        Location to;
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        Location from = event.getFrom().clone().subtract(0.0, 0.05, 0.0);
        if (LocationTag.isSameBlock(from, to = event.getTo().clone().subtract(0.0, 0.05, 0.0))) {
            return;
        }
        this.location = new LocationTag(to);
        if (!Utilities.isLocationYSafe(this.location)) {
            return;
        }
        this.previous_location = new LocationTag(event.getFrom());
        this.new_location = new LocationTag(event.getTo());
        this.event = event;
        this.fire((Event)event);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.onPlayerStepsOn((PlayerMoveEvent)event);
    }
}

