/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.vehicle;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class VehicleCollidesEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag vehicle;
    public EntityTag entity;
    public VehicleEntityCollisionEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.contains("collides with")) {
            return false;
        }
        if (!VehicleCollidesEntityScriptEvent.couldMatchEntity(path.eventArgLowerAt(3))) {
            return false;
        }
        return VehicleCollidesEntityScriptEvent.exactMatchesVehicle(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.vehicle.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        Argument arg;
        if (determinationObj instanceof ElementTag && (arg = Argument.valueOf(determinationObj.toString())).matchesPrefix("pickup")) {
            this.event.setPickupCancelled(!arg.asElement().asBoolean());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "vehicle": {
                return this.vehicle;
            }
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "pickup": {
                return new ElementTag(!this.event.isPickupCancelled());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleCollidesEntity(VehicleEntityCollisionEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.event = event;
        this.fire((Event)event);
    }
}

