/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Instrument;
import org.bukkit.block.data.type.NoteBlock;

public class MaterialInstrument
implements Property {
    public static final String[] handledMechs = new String[]{"instrument"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof NoteBlock;
    }

    public static MaterialInstrument getFrom(ObjectTag _material) {
        if (!MaterialInstrument.describes(_material)) {
            return null;
        }
        return new MaterialInstrument((MaterialTag)_material);
    }

    private MaterialInstrument(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(MaterialInstrument.class, ElementTag.class, "instrument", (attribute, material) -> new ElementTag(material.getNoteBlock().getInstrument().name()), new String[0]);
    }

    public NoteBlock getNoteBlock() {
        return (NoteBlock)this.material.getModernData();
    }

    public void setInstrument(String instrument) {
        this.getNoteBlock().setInstrument(Instrument.valueOf((String)instrument));
    }

    @Override
    public String getPropertyString() {
        return this.getNoteBlock().getInstrument().name();
    }

    @Override
    public String getPropertyId() {
        return "instrument";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("instrument") && mechanism.requireEnum(Instrument.class)) {
            this.setInstrument(mechanism.getValue().asString().toUpperCase());
        }
    }
}

