/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class EntitySpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public LocationTag location;
    public ElementTag reason;
    public EntitySpawnEvent event;

    public EntitySpawnScriptEvent() {
        this.registerCouldMatcher("<entity> spawns (because <'cause'>)");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return !path.eventLower.startsWith("item") && !path.eventLower.startsWith("spawner") && !path.eventLower.startsWith("npc");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !EntitySpawnScriptEvent.runGenericCheck(path.eventArgLowerAt(3), this.reason.toString())) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("spawner_location") && this.event instanceof SpawnerSpawnEvent) {
            return new LocationTag(((SpawnerSpawnEvent)this.event).getSpawner().getLocation());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        this.entity = new EntityTag(entity);
        this.location = new LocationTag(event.getLocation());
        if (event instanceof CreatureSpawnEvent) {
            CreatureSpawnEvent.SpawnReason creatureReason = ((CreatureSpawnEvent)event).getSpawnReason();
            if (creatureReason == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                return;
            }
            this.reason = new ElementTag(creatureReason.name());
        } else {
            this.reason = event instanceof SpawnerSpawnEvent ? new ElementTag("SPAWNER") : new ElementTag("ENTITY_SPAWN");
        }
        this.event = event;
        EntityTag.rememberEntity(entity);
        this.fire((Event)event);
        EntityTag.forgetEntity(entity);
    }
}

