/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAttributeModifiers;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemAttributeModifiers
implements Property {
    public static final String[] handledMechs = new String[]{"attribute_modifiers", "add_attribute_modifiers", "remove_attribute_modifiers"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemAttributeModifiers getFrom(ObjectTag item) {
        if (!ItemAttributeModifiers.describes(item)) {
            return null;
        }
        return new ItemAttributeModifiers((ItemTag)item);
    }

    private ItemAttributeModifiers(ItemTag item) {
        this.item = item;
    }

    public MapTag getAttributeModifiers() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return null;
        }
        Multimap metaMap = meta.getAttributeModifiers();
        return ItemAttributeModifiers.getAttributeModifiersFor((Multimap<Attribute, AttributeModifier>)metaMap);
    }

    public static MapTag getAttributeModifiersFor(Multimap<Attribute, AttributeModifier> metaMap) {
        MapTag map = new MapTag();
        if (metaMap == null) {
            return map;
        }
        for (Attribute attribute : metaMap.keys()) {
            Collection modifiers = metaMap.get((Object)attribute);
            if (modifiers.isEmpty()) continue;
            ListTag subList = new ListTag();
            for (AttributeModifier modifier : modifiers) {
                subList.addObject(EntityAttributeModifiers.mapify(modifier));
            }
            map.putObject(attribute.name(), subList);
        }
        return map;
    }

    public static void registerTags() {
        PropertyParser.registerTag(ItemAttributeModifiers.class, MapTag.class, "attribute_modifiers", (attribute, object) -> object.getAttributeModifiers(), new String[0]);
        PropertyParser.registerTag(ItemAttributeModifiers.class, MapTag.class, "default_attribute_modifiers", (attribute, object) -> {
            if (!attribute.hasParam() || !NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                return null;
            }
            EquipmentSlot slot = attribute.getParamElement().asEnum(EquipmentSlot.class);
            if (slot == null) {
                attribute.echoError("Invalid slot specified: " + attribute.getParam());
                return null;
            }
            return ItemAttributeModifiers.getAttributeModifiersFor((Multimap<Attribute, AttributeModifier>)object.item.getBukkitMaterial().getDefaultAttributeModifiers(slot));
        }, new String[0]);
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.getAttributeModifiers();
        if (map.map.isEmpty()) {
            return null;
        }
        return map.savable();
    }

    @Override
    public String getPropertyId() {
        return "attribute_modifiers";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        ItemMeta meta;
        Attribute attr;
        if (mechanism.matches("attribute_modifiers") && mechanism.requireObject(MapTag.class)) {
            LinkedHashMultimap metaMap = LinkedHashMultimap.create();
            MapTag map = mechanism.valueAsType(MapTag.class);
            for (Map.Entry<StringHolder, ObjectTag> mapEntry : map.map.entrySet()) {
                attr = Attribute.valueOf((String)mapEntry.getKey().str.toUpperCase());
                for (ObjectTag listValue : CoreUtilities.objectToList(mapEntry.getValue(), mechanism.context)) {
                    metaMap.put((Object)attr, (Object)EntityAttributeModifiers.modiferForMap(attr, (MapTag)listValue));
                }
            }
            ItemMeta meta2 = this.item.getItemMeta();
            meta2.setAttributeModifiers((Multimap)metaMap);
            this.item.setItemMeta(meta2);
        }
        if (mechanism.matches("add_attribute_modifiers") && mechanism.requireObject(MapTag.class)) {
            meta = this.item.getItemMeta();
            MapTag input = mechanism.valueAsType(MapTag.class);
            for (Map.Entry<StringHolder, ObjectTag> subValue : input.map.entrySet()) {
                attr = Attribute.valueOf((String)subValue.getKey().str.toUpperCase());
                for (ObjectTag listValue : CoreUtilities.objectToList(subValue.getValue(), mechanism.context)) {
                    meta.addAttributeModifier(attr, EntityAttributeModifiers.modiferForMap(attr, (MapTag)listValue));
                }
            }
            this.item.setItemMeta(meta);
        }
        if (mechanism.matches("remove_attribute_modifiers") && mechanism.requireObject(ListTag.class)) {
            meta = this.item.getItemMeta();
            ArrayList inputList = new ArrayList(mechanism.valueAsType(ListTag.class));
            for (String toRemove : new ArrayList(inputList)) {
                if (!new ElementTag(toRemove).matchesEnum(Attribute.class)) continue;
                inputList.remove(toRemove);
                attr = Attribute.valueOf((String)toRemove.toUpperCase());
                meta.removeAttributeModifier(attr);
            }
            for (String toRemove : inputList) {
                UUID id = UUID.fromString(toRemove);
                Multimap metaMap = meta.getAttributeModifiers();
                block6: for (Attribute attribute : metaMap.keys()) {
                    for (AttributeModifier modifer : metaMap.get((Object)attribute)) {
                        if (!modifer.getUniqueId().equals(id)) continue;
                        meta.removeAttributeModifier(attribute, modifer);
                        continue block6;
                    }
                }
            }
            this.item.setItemMeta(meta);
        }
    }
}

