/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Hangable;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.Lantern;

public class MaterialAttached
implements Property {
    public static final String[] handledMechs = new String[]{"attached", "attached_to_wall"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData() instanceof Gate || ((MaterialTag)material).getModernData() instanceof Lantern || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && ((MaterialTag)material).getModernData() instanceof Hangable);
    }

    public static MaterialAttached getFrom(ObjectTag _material) {
        if (!MaterialAttached.describes(_material)) {
            return null;
        }
        return new MaterialAttached((MaterialTag)_material);
    }

    private MaterialAttached(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(MaterialAttached.class, ElementTag.class, "attached", (attribute, material) -> {
            if (material.isGate()) {
                return new ElementTag(material.getGate().isInWall());
            }
            if (material.isLantern()) {
                return new ElementTag(material.getLantern().isHanging());
            }
            if (material.isHangable()) {
                return new ElementTag(((Hangable)material.material.getModernData()).isHanging());
            }
            return null;
        }, "attached_to_wall");
    }

    public boolean isGate() {
        return this.material.getModernData() instanceof Gate;
    }

    public boolean isLantern() {
        return this.material.getModernData() instanceof Lantern;
    }

    public boolean isHangable() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && this.material.getModernData() instanceof Hangable;
    }

    public Gate getGate() {
        return (Gate)this.material.getModernData();
    }

    public Lantern getLantern() {
        return (Lantern)this.material.getModernData();
    }

    public boolean isAttached() {
        if (this.isGate()) {
            return this.getGate().isInWall();
        }
        if (this.isLantern()) {
            return this.getLantern().isHanging();
        }
        if (this.isHangable()) {
            return ((Hangable)this.material.getModernData()).isHanging();
        }
        return false;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.isAttached());
    }

    @Override
    public String getPropertyId() {
        return "attached";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("attached") || mechanism.matches("attached_to_wall")) && mechanism.requireBoolean()) {
            if (this.isGate()) {
                this.getGate().setInWall(mechanism.getValue().asBoolean());
            } else if (this.isLantern()) {
                this.getLantern().setHanging(mechanism.getValue().asBoolean());
            } else if (this.isHangable()) {
                ((Hangable)this.material.getModernData()).setHanging(mechanism.getValue().asBoolean());
            }
        }
    }
}

