/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.flags;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerFlagHandler
implements Listener {
    public static long cacheTimeoutSeconds = 300L;
    public static boolean asyncPreload = false;
    public static boolean saveOnlyWhenWorldSaveOn = false;
    public static File dataFolder;
    public static HashMap<UUID, CachedPlayerFlag> playerFlagTrackerCache;
    public static HashMap<UUID, SoftReference<CachedPlayerFlag>> secondaryPlayerFlagTrackerCache;
    private static ArrayList<UUID> toClearCache;
    private static int secondaryCleanTicker;

    public static void cleanSecondaryCache() {
        toClearCache.clear();
        for (Map.Entry<UUID, SoftReference<CachedPlayerFlag>> entry : secondaryPlayerFlagTrackerCache.entrySet()) {
            if (entry.getValue().get() != null) continue;
            toClearCache.add(entry.getKey());
        }
        for (UUID id : toClearCache) {
            secondaryPlayerFlagTrackerCache.remove(id);
        }
    }

    public static void cleanCache() {
        if (cacheTimeoutSeconds == -1L) {
            return;
        }
        if (secondaryCleanTicker++ > 10) {
            PlayerFlagHandler.cleanSecondaryCache();
        }
        long timeNow = CoreUtilities.monotonicMillis();
        for (Map.Entry<UUID, CachedPlayerFlag> entry : playerFlagTrackerCache.entrySet()) {
            if (cacheTimeoutSeconds > 0L && entry.getValue().lastAccessed + cacheTimeoutSeconds * 1000L < timeNow) continue;
            if (Bukkit.getPlayer((UUID)entry.getKey()) != null) {
                entry.getValue().lastAccessed = timeNow;
                continue;
            }
            PlayerFlagHandler.saveThenExpire(entry.getKey(), entry.getValue());
        }
    }

    public static void saveThenExpire(final UUID id, final CachedPlayerFlag cache) {
        if (saveOnlyWhenWorldSaveOn && !((World)Bukkit.getWorlds().get(0)).isAutoSave()) {
            return;
        }
        final BukkitRunnable expireTask = new BukkitRunnable(){

            public void run() {
                if (cache.shouldExpire()) {
                    playerFlagTrackerCache.remove(id);
                    secondaryPlayerFlagTrackerCache.put(id, new SoftReference<CachedPlayerFlag>(cache));
                }
            }
        };
        if (cache.savingNow.get() || cache.loadingNow.get()) {
            new BukkitRunnable(){

                public void run() {
                    CachedPlayerFlag newCache = playerFlagTrackerCache.get(id);
                    if (newCache != null) {
                        PlayerFlagHandler.saveThenExpire(id, newCache);
                    }
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 10L);
            return;
        }
        if (!cache.tracker.modified) {
            expireTask.runTaskLater((Plugin)Denizen.getInstance(), 1L);
            return;
        }
        cache.tracker.modified = false;
        final String text = cache.tracker.toString();
        cache.savingNow.set(true);
        new BukkitRunnable(){

            public void run() {
                try {
                    PlayerFlagHandler.saveFlags(id, text);
                }
                catch (Throwable ex) {
                    Debug.echoError(ex);
                }
                cache.savingNow.set(false);
                expireTask.runTaskLater((Plugin)Denizen.getInstance(), 1L);
            }
        }.runTaskAsynchronously((Plugin)Denizen.getInstance());
    }

    public static void loadFlags(UUID id, CachedPlayerFlag cache) {
        try {
            cache.tracker = SavableMapFlagTracker.loadFlagFile(new File(dataFolder, id.toString()).getPath(), false);
        }
        finally {
            cache.loadingNow.set(false);
        }
    }

    public static AbstractFlagTracker getTrackerFor(UUID id) {
        CachedPlayerFlag cache = playerFlagTrackerCache.get(id);
        if (cache == null) {
            SoftReference<CachedPlayerFlag> softRef = secondaryPlayerFlagTrackerCache.get(id);
            if (softRef != null && (cache = softRef.get()) != null) {
                cache.lastAccessed = CoreUtilities.monotonicMillis();
                if (CoreConfiguration.debugVerbose) {
                    Debug.echoError("Verbose - (getTrackerFor) flag tracker updated from soft to main for " + id);
                }
                playerFlagTrackerCache.put(id, cache);
                secondaryPlayerFlagTrackerCache.remove(id);
                return cache.tracker;
            }
            cache = new CachedPlayerFlag();
            cache.lastAccessed = CoreUtilities.monotonicMillis();
            cache.loadingNow.set(true);
            if (CoreConfiguration.debugVerbose) {
                Debug.echoError("Verbose - (getTrackerFor) flag tracker created for " + id);
            }
            playerFlagTrackerCache.put(id, cache);
            PlayerFlagHandler.loadFlags(id, cache);
            if (cache.tracker != null && !CoreConfiguration.skipAllFlagCleanings) {
                cache.tracker.doTotalClean();
            }
        } else {
            if (CoreConfiguration.debugVerbose) {
                Debug.echoError("Verbose - (getTrackerFor) flag tracker was cached for " + id);
            }
            if (cache.loadingNow.get()) {
                long start = CoreUtilities.monotonicMillis();
                while (cache.loadingNow.get()) {
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoError("Verbose - (getTrackerFor) flag tracker is loading, so waiting, for " + id + " ... at " + (CoreUtilities.monotonicMillis() - start) + "ms");
                    }
                    if (CoreUtilities.monotonicMillis() - start > 15000L) {
                        Debug.echoError("Flag loading timeout, errors may follow");
                        playerFlagTrackerCache.remove(id);
                        return null;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        Debug.echoError(ex);
                        return cache.tracker;
                    }
                }
            }
        }
        return cache.tracker;
    }

    public static Future loadAsync(final UUID id) {
        try {
            CachedPlayerFlag cache = playerFlagTrackerCache.get(id);
            if (cache != null) {
                if (CoreConfiguration.debugVerbose) {
                    Debug.echoError("Verbose - (loadAsync) flag tracker ignored due to cache for " + id);
                }
                return null;
            }
            SoftReference<CachedPlayerFlag> softRef = secondaryPlayerFlagTrackerCache.get(id);
            if (softRef != null && (cache = softRef.get()) != null) {
                cache.lastAccessed = CoreUtilities.monotonicMillis();
                if (CoreConfiguration.debugVerbose) {
                    Debug.echoError("Verbose - (loadAsync) flag tracker updated from softref to main for " + id);
                }
                playerFlagTrackerCache.put(id, cache);
                secondaryPlayerFlagTrackerCache.remove(id);
                return null;
            }
            final CachedPlayerFlag newCache = new CachedPlayerFlag();
            newCache.lastAccessed = CoreUtilities.monotonicMillis();
            newCache.loadingNow.set(true);
            if (CoreConfiguration.debugVerbose) {
                Debug.echoError("Verbose - (loadAsync) flag tracker created " + id);
            }
            playerFlagTrackerCache.put(id, newCache);
            final CompletableFuture future = new CompletableFuture();
            new BukkitRunnable(){

                public void run() {
                    PlayerFlagHandler.loadFlags(id, newCache);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.instance, () -> {
                        if (CoreConfiguration.debugVerbose) {
                            Debug.echoError("Verbose - flag tracker async loaded " + id);
                        }
                        if (newCache2.tracker != null && !CoreConfiguration.skipAllFlagCleanings) {
                            newCache2.tracker.doTotalClean();
                        }
                    });
                    future.complete(null);
                }
            }.runTaskAsynchronously((Plugin)Denizen.getInstance());
            return future;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static void saveAllNow(boolean lockUntilDone) {
        for (Map.Entry<UUID, CachedPlayerFlag> entry : playerFlagTrackerCache.entrySet()) {
            CachedPlayerFlag flags = entry.getValue();
            if (!flags.tracker.modified || !lockUntilDone && flags.savingNow.get() || flags.loadingNow.get()) continue;
            while (flags.savingNow.get() || flags.loadingNow.get()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Debug.echoError(ex);
                }
            }
            flags.tracker.modified = false;
            PlayerFlagHandler.saveFlags(entry.getKey(), flags.tracker.toString());
        }
    }

    public static void saveFlags(UUID id, String flagData) {
        CoreUtilities.journallingFileSave(new File(dataFolder, id.toString() + ".dat").getPath(), flagData);
    }

    @EventHandler
    public void onPlayerLogin(AsyncPlayerPreLoginEvent event) {
        if (!asyncPreload) {
            return;
        }
        if (!Denizen.hasTickedOnce) {
            return;
        }
        UUID id = event.getUniqueId();
        if (!Bukkit.isPrimaryThread()) {
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)Denizen.getInstance(), () -> PlayerFlagHandler.loadAsync(id));
            try {
                Future newFuture = (Future)future.get(15L, TimeUnit.SECONDS);
                if (newFuture != null) {
                    newFuture.get(15L, TimeUnit.SECONDS);
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
    }

    public static void reloadAllFlagsNow() {
        playerFlagTrackerCache.clear();
        secondaryPlayerFlagTrackerCache.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerFlagHandler.getTrackerFor(player.getUniqueId());
        }
    }

    static {
        playerFlagTrackerCache = new HashMap();
        secondaryPlayerFlagTrackerCache = new HashMap();
        toClearCache = new ArrayList();
        secondaryCleanTicker = 0;
    }

    public static class CachedPlayerFlag {
        public long lastAccessed;
        public SavableMapFlagTracker tracker;
        public AtomicBoolean savingNow = new AtomicBoolean(false);
        public AtomicBoolean loadingNow = new AtomicBoolean(false);

        public boolean shouldExpire() {
            if (cacheTimeoutSeconds == -1L) {
                return false;
            }
            if (cacheTimeoutSeconds == 0L) {
                return true;
            }
            return this.lastAccessed + cacheTimeoutSeconds * 1000L < CoreUtilities.monotonicMillis();
        }
    }
}

