/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Map;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;

public class EntityAttributeBaseValues
implements Property {
    public static final String[] handledMechs = new String[]{"attribute_base_values"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Attributable;
    }

    public static EntityAttributeBaseValues getFrom(ObjectTag entity) {
        if (!EntityAttributeBaseValues.describes(entity)) {
            return null;
        }
        return new EntityAttributeBaseValues((EntityTag)entity);
    }

    private EntityAttributeBaseValues(EntityTag entity) {
        this.entity = entity;
    }

    public MapTag attributeBaseValues() {
        MapTag result = new MapTag();
        Attributable ent = this.getAttributable();
        for (Attribute attr : Attribute.values()) {
            AttributeInstance instance = ent.getAttribute(attr);
            if (instance == null) continue;
            result.putObject(attr.name(), new ElementTag(instance.getBaseValue()));
        }
        return result;
    }

    public Attributable getAttributable() {
        return (Attributable)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.attributeBaseValues();
        return map.map.isEmpty() ? null : map.savable();
    }

    @Override
    public String getPropertyId() {
        return "attribute_base_values";
    }

    public static void register() {
        PropertyParser.registerTag(EntityAttributeBaseValues.class, ElementTag.class, "has_attribute", (attribute, object) -> {
            if (!attribute.hasParam() || !attribute.getParamElement().matchesEnum(Attribute.class)) {
                attribute.echoError("Invalid entity.has_attribute[...] input: must be a valid attribute name.");
                return null;
            }
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            return new ElementTag(object.getAttributable().getAttribute(attr) != null);
        }, new String[0]);
        PropertyParser.registerTag(EntityAttributeBaseValues.class, ElementTag.class, "attribute_value", (attribute, object) -> {
            if (!attribute.hasParam() || !attribute.getParamElement().matchesEnum(Attribute.class)) {
                attribute.echoError("Invalid entity.attribute_value[...] input: must be a valid attribute name.");
                return null;
            }
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            AttributeInstance instance = object.getAttributable().getAttribute(attr);
            if (instance == null) {
                attribute.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + object.entity.getBukkitEntityType().name());
                return null;
            }
            return new ElementTag(instance.getValue());
        }, new String[0]);
        PropertyParser.registerTag(EntityAttributeBaseValues.class, ElementTag.class, "attribute_base_value", (attribute, object) -> {
            if (!attribute.hasParam() || !attribute.getParamElement().matchesEnum(Attribute.class)) {
                attribute.echoError("Invalid entity.attribute_base_value[...] input: must be a valid attribute name.");
                return null;
            }
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            AttributeInstance instance = object.getAttributable().getAttribute(attr);
            if (instance == null) {
                attribute.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + object.entity.getBukkitEntityType().name());
                return null;
            }
            return new ElementTag(instance.getBaseValue());
        }, new String[0]);
        PropertyParser.registerTag(EntityAttributeBaseValues.class, ElementTag.class, "attribute_default_value", (attribute, object) -> {
            if (!attribute.hasParam() || !attribute.getParamElement().matchesEnum(Attribute.class)) {
                attribute.echoError("Invalid entity.attribute_default_value[...] input: must be a valid attribute name.");
                return null;
            }
            Attribute attr = Attribute.valueOf((String)attribute.getParam().toUpperCase());
            AttributeInstance instance = object.getAttributable().getAttribute(attr);
            if (instance == null) {
                attribute.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + object.entity.getBukkitEntityType().name());
                return null;
            }
            return new ElementTag(instance.getDefaultValue());
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("attribute_base_values") && mechanism.requireObject(MapTag.class)) {
            MapTag input = mechanism.valueAsType(MapTag.class);
            Attributable ent = this.getAttributable();
            for (Map.Entry<StringHolder, ObjectTag> subValue : input.map.entrySet()) {
                Attribute attr = Attribute.valueOf((String)subValue.getKey().str.toUpperCase());
                AttributeInstance instance = ent.getAttribute(attr);
                if (instance == null) {
                    mechanism.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntityType().name());
                    continue;
                }
                ElementTag value = subValue.getValue().asElement();
                if (!value.isDouble()) {
                    mechanism.echoError("Invalid input '" + value + "': must be a decimal number.");
                    continue;
                }
                instance.setBaseValue(value.asDouble());
            }
        }
    }
}

