/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Vex;
import org.bukkit.entity.WitherSkull;

public class EntityCharged
implements Property {
    public static final String[] handledMechs = new String[]{"charged"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && (((EntityTag)entity).getBukkitEntity() instanceof WitherSkull || ((EntityTag)entity).getBukkitEntity() instanceof Vex);
    }

    public static EntityCharged getFrom(ObjectTag entity) {
        if (!EntityCharged.describes(entity)) {
            return null;
        }
        return new EntityCharged((EntityTag)entity);
    }

    private EntityCharged(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return this.isCharged() ? "true" : "false";
    }

    @Override
    public String getPropertyId() {
        return "charged";
    }

    public static void register() {
        PropertyParser.registerTag(EntityCharged.class, ElementTag.class, "charged", (attribute, object) -> new ElementTag(object.isCharged()), new String[0]);
    }

    public boolean isWitherSkull() {
        return this.entity.getBukkitEntity() instanceof WitherSkull;
    }

    public boolean isVex() {
        return this.entity.getBukkitEntity() instanceof Vex;
    }

    public WitherSkull getWitherSkull() {
        return (WitherSkull)this.entity.getBukkitEntity();
    }

    public Vex getVex() {
        return (Vex)this.entity.getBukkitEntity();
    }

    public boolean isCharged() {
        if (this.isWitherSkull()) {
            return this.getWitherSkull().isCharged();
        }
        if (this.isVex()) {
            return this.getVex().isCharging();
        }
        return false;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("charged") && mechanism.requireBoolean()) {
            if (this.isWitherSkull()) {
                this.getWitherSkull().setCharged(mechanism.getValue().asBoolean());
            } else if (this.isVex()) {
                this.getVex().setCharging(mechanism.getValue().asBoolean());
            }
        }
    }
}

