/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.scripts.commands.world.SignCommand;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class Utilities {
    public static AsciiMatcher namespaceMatcher = new AsciiMatcher("abcdefghijklmnopqrstuvwxyz.-_/0123456789");
    public static HashSet<String> FORBIDDEN_EXTENSIONS = new HashSet<String>(Arrays.asList("jar", "java", "sh", "bash", "bat", "ps1", "vb", "vbs", "vbscript", "batch", "cmd", "com", "msc", "sct", "ws", "wsf", "exe", "scr", "msi", "dll", "bin", "lnk", "reg", "rgs", "secret"));
    private static final String colors = "0123456789abcdefklmnorABCDEFKLMNOR";

    public static NamespacedKey parseNamespacedKey(String input) {
        int colonIndex = (input = CoreUtilities.toLowerCase(input)).indexOf(58);
        if (colonIndex != -1) {
            return new NamespacedKey(input.substring(0, colonIndex), Utilities.cleanseNamespaceID(input.substring(colonIndex + 1)));
        }
        return NamespacedKey.minecraft((String)Utilities.cleanseNamespaceID(input));
    }

    public static boolean matchesNamespacedKey(String input) {
        int colonIndex = input.indexOf(58);
        if (colonIndex == -1) {
            return namespaceMatcher.isOnlyMatches(input);
        }
        return namespaceMatcher.isOnlyMatches(input.substring(0, colonIndex)) && namespaceMatcher.isOnlyMatches(input.substring(colonIndex + 1));
    }

    public static String cleanseNamespaceID(String input) {
        return namespaceMatcher.trimToMatches(CoreUtilities.toLowerCase(input));
    }

    public static String getRecipeType(Recipe recipe) {
        if (recipe == null) {
            return null;
        }
        if (recipe instanceof ShapedRecipe) {
            return "shaped";
        }
        if (recipe instanceof ShapelessRecipe) {
            return "shapeless";
        }
        if (recipe instanceof CookingRecipe) {
            if (recipe instanceof FurnaceRecipe) {
                return "furnace";
            }
            if (recipe instanceof BlastingRecipe) {
                return "blasting";
            }
            if (recipe instanceof CampfireRecipe) {
                return "campfire";
            }
            if (recipe instanceof SmokingRecipe) {
                return "smoking";
            }
        } else {
            if (recipe instanceof StonecuttingRecipe) {
                return "stonecutting";
            }
            if (recipe instanceof SmithingRecipe) {
                return "smithing";
            }
        }
        Debug.echoError("Failed to determine recipe type for " + recipe.getClass().getName() + ": " + recipe);
        return null;
    }

    public static boolean isRecipeOfType(Recipe recipe, String type) {
        return type == null || type.equals("crafting") && (recipe instanceof ShapedRecipe || recipe instanceof ShapelessRecipe) || type.equals("furnace") && recipe instanceof FurnaceRecipe || type.equals("cooking") && recipe instanceof CookingRecipe || type.equals("blasting") && recipe instanceof BlastingRecipe || type.equals("campfire") && recipe instanceof CampfireRecipe || type.equals("shaped") && recipe instanceof ShapedRecipe || type.equals("shapeless") && recipe instanceof ShapelessRecipe || type.equals("smoking") && recipe instanceof SmokingRecipe || type.equals("stonecutting") && recipe instanceof StonecuttingRecipe;
    }

    public static boolean canReadFile(File f) {
        if (Settings.allowStupids()) {
            return true;
        }
        try {
            String lown = CoreUtilities.toLowerCase(f.getCanonicalPath()).replace('\\', '/');
            if (lown.endsWith("/")) {
                lown = lown.substring(0, lown.length() - 1);
            }
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Checking file canRead: " + lown);
            }
            if (lown.contains("denizen/secrets.secret")) {
                return false;
            }
            int dot = lown.lastIndexOf(46);
            if (dot != -1 && lown.substring(dot + 1).equals("secret")) {
                return false;
            }
            if (!CoreConfiguration.allowStrangeFileSaves && !f.getCanonicalPath().startsWith(new File(".").getCanonicalPath())) {
                return false;
            }
            return CoreUtilities.equalsIgnoreCase(Settings.fileLimitPath(), "none") || f.getCanonicalPath().startsWith(new File("./" + Settings.fileLimitPath()).getCanonicalPath());
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            return false;
        }
    }

    public static boolean isFileCanonicalStringSafeToWrite(String lown) {
        if (lown.contains("denizen/config.yml")) {
            return false;
        }
        if (lown.contains("denizen/secrets.secret")) {
            return false;
        }
        if (lown.contains("denizen/scripts/")) {
            return false;
        }
        if (lown.endsWith("plugins/")) {
            return false;
        }
        int dot = lown.lastIndexOf(46);
        return dot == -1 || !FORBIDDEN_EXTENSIONS.contains(lown.substring(dot + 1));
    }

    public static boolean canWriteToFile(File f) {
        if (Settings.allowStupids()) {
            return true;
        }
        try {
            String lown = CoreUtilities.toLowerCase(f.getCanonicalPath()).replace('\\', '/');
            if (lown.endsWith("/")) {
                lown = lown.substring(0, lown.length() - 1);
            }
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Checking file canWrite: " + lown);
            }
            if (!CoreConfiguration.allowStrangeFileSaves && !f.getCanonicalPath().startsWith(new File(".").getCanonicalPath())) {
                return false;
            }
            if (!CoreUtilities.toLowerCase(Settings.fileLimitPath()).equals("none") && !f.getCanonicalPath().startsWith(new File("./" + Settings.fileLimitPath()).getCanonicalPath())) {
                return false;
            }
            return Utilities.isFileCanonicalStringSafeToWrite(lown) && Utilities.isFileCanonicalStringSafeToWrite(lown + "/");
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            return false;
        }
    }

    public static BlockFace faceFor(Vector vec) {
        for (BlockFace face : BlockFace.values()) {
            if (!(face.getDirection().distanceSquared(vec) < 0.01)) continue;
            return face;
        }
        return null;
    }

    public static Location getWalkableLocationNear(Location location, int range) {
        ArrayList<Location> locations = new ArrayList<Location>();
        location = location.getBlock().getLocation();
        for (double x = (double)(-range); x <= (double)range; x += 1.0) {
            for (double y = (double)(-range); y <= (double)range; y += 1.0) {
                for (double z = (double)(-range); z <= (double)range; z += 1.0) {
                    Location loc = location.clone().add(x, y, z);
                    if (!Utilities.checkLocation(location, loc, (double)range) || !Utilities.isWalkable(loc)) continue;
                    locations.add(loc);
                }
            }
        }
        if (locations.isEmpty()) {
            return null;
        }
        return (Location)locations.get(CoreUtilities.getRandom().nextInt(locations.size()));
    }

    public static boolean isWalkable(Location location) {
        if (location.getBlockY() < 1 || location.getBlockY() > 254) {
            return false;
        }
        BlockHelper blockHelper = NMSHandler.blockHelper;
        return location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid() && !location.getBlock().getType().isSolid() && !location.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid();
    }

    public static void talkToNPC(String message, PlayerTag player, NPCTag npc, double range, ScriptTag script) {
        String replacer = String.valueOf('\u0004');
        String talkFormat = Settings.chatToNpcFormat().replaceAll("(?i)<TEXT>", replacer);
        String bystanderFormat = Settings.chatToNpcOverheardFormat().replaceAll("(?i)<TEXT>", replacer);
        talkFormat = TagManager.tag(talkFormat, new BukkitTagContext(player, npc, script)).replace(replacer, message);
        bystanderFormat = TagManager.tag(bystanderFormat, new BukkitTagContext(player, npc, script)).replace(replacer, message);
        player.getPlayerEntity().sendMessage(talkFormat);
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player.getPlayerEntity() || !target.getWorld().equals(player.getPlayerEntity().getWorld()) || !(target.getLocation().distance(player.getPlayerEntity().getLocation()) <= range)) continue;
            target.sendMessage(bystanderFormat);
        }
    }

    public static NPCTag getClosestNPC_ChatTrigger(Location location, int range) {
        NPC closestNPC = null;
        double closestDistance = Math.pow(range, 2.0);
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned()) continue;
            Location loc = npc.getStoredLocation();
            if (!npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getOrAddTrait(TriggerTrait.class)).hasTrigger("CHAT") || !loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getStoredLocation().distanceSquared(location);
        }
        if (closestNPC == null) {
            return null;
        }
        return new NPCTag(closestNPC);
    }

    public static boolean checkLocationWithBoundingBox(Location baseLocation, Entity entity, double theLeeway) {
        double zOff;
        double yOff;
        if (!Utilities.checkLocation(baseLocation, entity.getLocation(), theLeeway + 16.0)) {
            return false;
        }
        BoundingBox box = entity.getBoundingBox();
        double x = Math.max(box.getMinX(), Math.min(baseLocation.getX(), box.getMaxX()));
        double y = Math.max(box.getMinY(), Math.min(baseLocation.getY(), box.getMaxY()));
        double z = Math.max(box.getMinZ(), Math.min(baseLocation.getZ(), box.getMaxZ()));
        double xOff = x - baseLocation.getX();
        return xOff * xOff + (yOff = y - baseLocation.getY()) * yOff + (zOff = z - baseLocation.getZ()) * zOff < theLeeway * theLeeway;
    }

    public static boolean checkLocation(LivingEntity entity, Location theLocation, double theLeeway) {
        return Utilities.checkLocation(entity.getLocation(), theLocation, theLeeway);
    }

    public static boolean checkLocation(Location baseLocation, Location theLocation, double theLeeway) {
        if (baseLocation.getWorld() != theLocation.getWorld()) {
            return false;
        }
        return baseLocation.distanceSquared(theLocation) < theLeeway * theLeeway;
    }

    public static void setSignLines(Sign sign, String[] lines) {
        for (int n = 0; n < 4; ++n) {
            PaperAPITools.instance.setSignLine(sign, n, lines[n]);
        }
        sign.update();
    }

    public static BlockFace chooseSignRotation(Block signBlock) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            Block block = signBlock.getRelative(blockFace);
            Material material = block.getType();
            if (material == Material.AIR || SignCommand.isAnySign(material)) continue;
            return blockFace.getOppositeFace();
        }
        return BlockFace.SOUTH;
    }

    public static BlockFace chooseSignRotation(String direction) {
        String dirUpper = direction.toUpperCase();
        for (BlockFace blockFace : MaterialDirectional.rotatableValidFaces) {
            if (!blockFace.name().equals(dirUpper)) continue;
            return blockFace;
        }
        switch (dirUpper.charAt(0)) {
            case 'N': {
                return BlockFace.NORTH;
            }
            case 'S': {
                return BlockFace.SOUTH;
            }
            case 'E': {
                return BlockFace.EAST;
            }
            case 'W': {
                return BlockFace.WEST;
            }
        }
        return BlockFace.SOUTH;
    }

    public static void setSignRotation(BlockState signState, String direction) {
        BlockFace bf = Utilities.chooseSignRotation(direction);
        MaterialTag signMaterial = new MaterialTag(signState.getBlock());
        MaterialDirectional.getFrom(signMaterial).setFacing(bf);
        signState.getBlock().setBlockData(signMaterial.getModernData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(File jarFile, String fileName, String destDir) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> myEnum = jar.entries();
            while (myEnum.hasMoreElements()) {
                JarEntry file = myEnum.nextElement();
                if (!CoreUtilities.equalsIgnoreCase(file.getName(), fileName)) continue;
                File f = new File(destDir + "/" + file.getName());
                if (file.isDirectory()) continue;
                InputStream is = jar.getInputStream(file);
                FileOutputStream fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
                return;
            }
            Debug.echoError(fileName + " not found in the jar!");
        }
        catch (IOException e) {
            Debug.echoError(e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    Debug.echoError(e);
                }
            }
        }
    }

    public static String generateRandomColors(int count) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            ret.append('\u00a7').append(colors.charAt(CoreUtilities.getRandom().nextInt(colors.length())));
        }
        return ret.toString();
    }

    public static BukkitScriptEntryData getEntryData(ScriptEntry entry) {
        return (BukkitScriptEntryData)entry.entryData;
    }

    public static WorldTag entryDefaultWorld(ScriptEntry entry, boolean playerFirst) {
        EntityTag entity = Utilities.entryDefaultEntity(entry, playerFirst);
        if (entity == null) {
            return new WorldTag((World)Bukkit.getWorlds().get(0));
        }
        return new WorldTag(entity.getWorld());
    }

    public static LocationTag entryDefaultLocation(ScriptEntry entry, boolean playerFirst) {
        EntityTag entity = Utilities.entryDefaultEntity(entry, playerFirst);
        if (entity == null) {
            return null;
        }
        return entity.getLocation();
    }

    public static List<EntityTag> entryDefaultEntityList(ScriptEntry entry, boolean playerFirst) {
        EntityTag entity = Utilities.entryDefaultEntity(entry, playerFirst);
        if (entity == null) {
            return null;
        }
        return Collections.singletonList(entity);
    }

    public static EntityTag entryDefaultEntity(ScriptEntry entry, boolean playerFirst) {
        BukkitScriptEntryData entryData = Utilities.getEntryData(entry);
        if (playerFirst && entryData.hasPlayer() && entryData.getPlayer().isOnline()) {
            return entryData.getPlayer().getDenizenEntity();
        }
        if (entryData.hasNPC() && entryData.getNPC().isSpawned()) {
            return entryData.getNPC().getDenizenEntity();
        }
        if (entryData.hasPlayer() && entryData.getPlayer().isOnline()) {
            return entryData.getPlayer().getDenizenEntity();
        }
        return null;
    }

    public static boolean entryHasPlayer(ScriptEntry entry) {
        return Utilities.getEntryData(entry).hasPlayer();
    }

    public static boolean entryHasNPC(ScriptEntry entry) {
        return Utilities.getEntryData(entry).hasNPC();
    }

    public static PlayerTag getEntryPlayer(ScriptEntry entry) {
        return Utilities.getEntryData(entry).getPlayer();
    }

    public static NPCTag getEntryNPC(ScriptEntry entry) {
        return Utilities.getEntryData(entry).getNPC();
    }

    public static boolean isLocationYSafe(Location loc) {
        return Utilities.isLocationYSafe(loc.getBlockY(), loc.getWorld());
    }

    public static boolean isLocationYSafe(double y, World world) {
        if (world == null) {
            return true;
        }
        return y >= (double)world.getMinHeight() && y <= (double)world.getMaxHeight();
    }

    public static ArrayList<Material> allMaterialsThatMatch(String matcherText) {
        ScriptEvent.MatchHelper matcher = ScriptEvent.createMatcher(matcherText);
        ArrayList<Material> mats = new ArrayList<Material>();
        for (Material material : Material.values()) {
            if (!matcher.doesMatch(material.name()) || material.name().startsWith("LEGACY_")) continue;
            mats.add(material);
        }
        return mats;
    }
}

