/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.tags.core.CustomColorTagBase;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.tags.core.PlayerTagBase;
import com.denizenscript.denizen.tags.core.ServerTagBase;
import com.denizenscript.denizen.tags.core.TextTagBase;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;

public class CommonRegistries {
    public static ObjectType<BiomeTag> TYPE_BIOME;
    public static ObjectType<ChunkTag> TYPE_CHUNK;
    public static ObjectType<ColorTag> TYPE_COLOR;
    public static ObjectType<CuboidTag> TYPE_CUBOID;
    public static ObjectType<EllipsoidTag> TYPE_ELLIPSOID;
    public static ObjectType<EnchantmentTag> TYPE_ENCHANTMENT;
    public static ObjectType<EntityTag> TYPE_ENTITY;
    public static ObjectType<InventoryTag> TYPE_INVENTORY;
    public static ObjectType<ItemTag> TYPE_ITEM;
    public static ObjectType<LocationTag> TYPE_LOCATION;
    public static ObjectType<MaterialTag> TYPE_MATERIAL;
    public static ObjectType<NPCTag> TYPE_NPC;
    public static ObjectType<PlayerTag> TYPE_PLAYER;
    public static ObjectType<PluginTag> TYPE_PLUGIN;
    public static ObjectType<PolygonTag> TYPE_POLYGON;
    public static ObjectType<TradeTag> TYPE_TRADE;
    public static ObjectType<WorldTag> TYPE_WORLD;

    public static void registerMainTagHandlers() {
        if (Depends.citizens != null) {
            new NPCTagBase();
        }
        new PlayerTagBase();
        new CustomColorTagBase();
        new ServerTagBase();
        new TextTagBase();
    }

    public static void registerMainObjects() {
        CommonRegistries.registerObjectTypes();
        CommonRegistries.registerNotables();
        CommonRegistries.registerConversions();
        CommonRegistries.registerSubtypeSets();
        if (CoreConfiguration.debugVerbose) {
            StringBuilder debug = new StringBuilder(256);
            for (ObjectType<? extends ObjectTag> objectType : ObjectFetcher.objectsByPrefix.values()) {
                debug.append(DebugInternals.getClassNameOpti(objectType.clazz)).append(" as ").append(objectType.prefix).append(", ");
            }
            Debug.echoApproval("Loaded core object types: [" + debug.substring(0, debug.length() - 2) + "]");
        }
    }

    private static void registerObjectTypes() {
        TYPE_BIOME = ObjectFetcher.registerWithObjectFetcher(BiomeTag.class, BiomeTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_CHUNK = ObjectFetcher.registerWithObjectFetcher(ChunkTag.class, ChunkTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_COLOR = ObjectFetcher.registerWithObjectFetcher(ColorTag.class, ColorTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_CUBOID = ObjectFetcher.registerWithObjectFetcher(CuboidTag.class, CuboidTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_ELLIPSOID = ObjectFetcher.registerWithObjectFetcher(EllipsoidTag.class, EllipsoidTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_ENCHANTMENT = ObjectFetcher.registerWithObjectFetcher(EnchantmentTag.class, EnchantmentTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_ENTITY = ObjectFetcher.registerWithObjectFetcher(EntityTag.class, EntityTag.tagProcessor).generateBaseTag();
        CommonRegistries.TYPE_ENTITY.typeChecker = inp -> {
            if (inp == null) {
                return false;
            }
            if (inp instanceof PlayerTag || inp instanceof EntityTag || inp instanceof NPCTag) {
                return true;
            }
            if (inp instanceof ElementTag) {
                String code;
                String simple = inp.identifySimple();
                int atIndex = simple.indexOf(64);
                return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("e") || code.equals("p") || code.equals("n") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
            }
            return false;
        };
        CommonRegistries.TYPE_ENTITY.typeConverter = (obj, context) -> {
            if (obj instanceof PlayerTag) {
                if (!((PlayerTag)obj).isOnline()) {
                    if (context.showErrors()) {
                        Debug.echoError("Player '" + obj.debuggable() + "' is offline, cannot convert to EntityTag.");
                    }
                    return null;
                }
                return new EntityTag((Entity)((PlayerTag)obj).getPlayerEntity());
            }
            if (obj instanceof NPCTag) {
                if (!((NPCTag)obj).isSpawned() && !EntityTag.allowDespawnedNpcs) {
                    if (context.showErrors()) {
                        Debug.echoError("NPC '" + obj.debuggable() + "' is unspawned, cannot convert to EntityTag.");
                    }
                    return null;
                }
                return new EntityTag((NPCTag)obj);
            }
            return EntityTag.valueOf(obj.toString(), context);
        };
        CommonRegistries.TYPE_ENTITY.typeShouldBeChecker = obj -> {
            if (obj instanceof EntityFormObject) {
                return true;
            }
            String raw = obj.toString();
            return raw.startsWith("p@") || raw.startsWith("e@") || raw.startsWith("n@");
        };
        TYPE_INVENTORY = ObjectFetcher.registerWithObjectFetcher(InventoryTag.class, InventoryTag.tagProcessor).setAsNOtherCode().generateBaseTag();
        TYPE_ITEM = ObjectFetcher.registerWithObjectFetcher(ItemTag.class, ItemTag.tagProcessor).setAsNOtherCode().generateBaseTag();
        TYPE_LOCATION = ObjectFetcher.registerWithObjectFetcher(LocationTag.class, LocationTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_MATERIAL = ObjectFetcher.registerWithObjectFetcher(MaterialTag.class, MaterialTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        if (Depends.citizens != null) {
            TYPE_NPC = ObjectFetcher.registerWithObjectFetcher(NPCTag.class, NPCTag.tagProcessor);
            CommonRegistries.TYPE_NPC.typeChecker = inp -> {
                if (inp == null) {
                    return false;
                }
                if (inp instanceof NPCTag || inp instanceof EntityTag) {
                    return true;
                }
                if (inp instanceof ElementTag) {
                    String code;
                    String simple = inp.identifySimple();
                    int atIndex = simple.indexOf(64);
                    return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("n") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
                }
                return false;
            };
            CommonRegistries.TYPE_NPC.typeConverter = (obj, context) -> {
                if (obj instanceof EntityTag && ((EntityTag)obj).isCitizensNPC()) {
                    return ((EntityTag)obj).getDenizenNPC();
                }
                return NPCTag.valueOf(obj.toString(), context);
            };
        }
        TYPE_PLAYER = ObjectFetcher.registerWithObjectFetcher(PlayerTag.class, PlayerTag.tagProcessor);
        CommonRegistries.TYPE_PLAYER.typeChecker = inp -> {
            if (inp == null) {
                return false;
            }
            if (inp instanceof PlayerTag || inp instanceof EntityTag) {
                return true;
            }
            if (inp instanceof ElementTag) {
                String code;
                String simple = inp.identifySimple();
                int atIndex = simple.indexOf(64);
                return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("p") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
            }
            return false;
        };
        CommonRegistries.TYPE_PLAYER.typeConverter = (obj, context) -> {
            if (obj instanceof EntityTag && ((EntityTag)obj).isPlayer()) {
                return ((EntityTag)obj).getDenizenPlayer();
            }
            return PlayerTag.valueOf(obj.toString(), context);
        };
        TYPE_PLUGIN = ObjectFetcher.registerWithObjectFetcher(PluginTag.class, PluginTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_POLYGON = ObjectFetcher.registerWithObjectFetcher(PolygonTag.class, PolygonTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_TRADE = ObjectFetcher.registerWithObjectFetcher(TradeTag.class, TradeTag.tagProcessor).setAsNOtherCode().generateBaseTag();
        TYPE_WORLD = ObjectFetcher.registerWithObjectFetcher(WorldTag.class, WorldTag.tagProcessor).setAsNOtherCode().generateBaseTag();
    }

    private static void registerNotables() {
        NoteManager.registerObjectTypeAsNotable(CuboidTag.class);
        NoteManager.registerObjectTypeAsNotable(EllipsoidTag.class);
        NoteManager.registerObjectTypeAsNotable(InventoryTag.class);
        NoteManager.registerObjectTypeAsNotable(ItemTag.class);
        NoteManager.registerObjectTypeAsNotable(LocationTag.class);
        NoteManager.registerObjectTypeAsNotable(PolygonTag.class);
    }

    private static void registerConversions() {
        CoreUtilities.objectConversions.add(obj -> {
            if (obj instanceof Biome) {
                return new BiomeTag((Biome)obj);
            }
            if (obj instanceof Chunk) {
                return new ChunkTag((Chunk)obj);
            }
            if (obj instanceof Color) {
                return new ColorTag((Color)obj);
            }
            if (obj instanceof Enchantment) {
                return new EnchantmentTag((Enchantment)obj);
            }
            if (obj instanceof Entity) {
                return new EntityTag((Entity)obj).getDenizenObject();
            }
            if (obj instanceof Inventory) {
                return InventoryTag.mirrorBukkitInventory((Inventory)obj);
            }
            if (obj instanceof ItemStack) {
                return new ItemTag((ItemStack)obj);
            }
            if (obj instanceof Location) {
                return new LocationTag((Location)obj);
            }
            if (obj instanceof Material) {
                return new MaterialTag((Material)obj);
            }
            if (obj instanceof BlockData) {
                return new MaterialTag((BlockData)obj);
            }
            if (obj instanceof Block) {
                return new LocationTag(((Block)obj).getLocation());
            }
            if (Depends.citizens != null && obj instanceof NPC) {
                return new NPCTag((NPC)obj);
            }
            if (obj instanceof OfflinePlayer) {
                return new PlayerTag((OfflinePlayer)obj);
            }
            if (obj instanceof Plugin) {
                return new PluginTag((Plugin)obj);
            }
            if (obj instanceof MerchantRecipe) {
                return new TradeTag((MerchantRecipe)obj);
            }
            if (obj instanceof World) {
                return new WorldTag((World)obj);
            }
            return null;
        });
    }

    private static void registerSubtypeSets() {
        ObjectFetcher.registerCrossType(EntityTag.class, EntityFormObject.class);
        ObjectFetcher.registerCrossType(PlayerTag.class, EntityTag.class);
        ObjectFetcher.registerCrossType(PlayerTag.class, EntityFormObject.class);
        if (Depends.citizens != null) {
            ObjectFetcher.registerCrossType(NPCTag.class, EntityTag.class);
            ObjectFetcher.registerCrossType(NPCTag.class, EntityFormObject.class);
        }
    }
}

