/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class WebGetCommand
extends AbstractCommand
implements Holdable {
    public static boolean patchAlreadyPatched = false;

    public WebGetCommand() {
        this.setName("webget");
        this.setSyntax("webget [<url>] (data:<data>) (method:<method>) (headers:<map>) (timeout:<duration>/{10s}) (savefile:<path>) (hide_failure)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
        this.autoCompile();
        this.addRemappedPrefixes("data", "post");
        this.addRemappedPrefixes("timeout", "t");
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgLinear @ArgName(value="url") @ArgRaw ElementTag originalUrl, @ArgPrefixed @ArgName(value="data") @ArgDefaultNull ElementTag data, @ArgPrefixed @ArgName(value="method") @ArgDefaultNull Method method, @ArgName(value="hide_failure") boolean hideFailure, @ArgPrefixed @ArgName(value="timeout") @ArgDefaultText(value="10s") DurationTag timeout, @ArgPrefixed @ArgName(value="headers") @ArgDefaultNull ObjectTag headersLegacyCompat, @ArgPrefixed @ArgName(value="savefile") @ArgDefaultNull String saveFile) {
        MapTag headers = null;
        if (headersLegacyCompat != null && headersLegacyCompat.shouldBeType(MapTag.class)) {
            headers = headersLegacyCompat.asType(MapTag.class, scriptEntry.context);
        } else if (headersLegacyCompat != null) {
            headers = new MapTag();
            for (String str : headersLegacyCompat.asType(ListTag.class, scriptEntry.context)) {
                int ind = str.indexOf(47);
                if (ind <= 0) continue;
                headers.putObject(str.substring(0, ind), new ElementTag(str.substring(ind + 1)));
            }
        }
        if (!CoreConfiguration.allowWebget) {
            Debug.echoError(scriptEntry, "WebGet disabled in config.yml!");
            return;
        }
        String urlText = originalUrl.asString();
        boolean urlIsSecret = originalUrl.canBeType(SecretTag.class);
        if (urlIsSecret) {
            SecretTag secret = originalUrl.asType(SecretTag.class, scriptEntry.context);
            if (secret == null) {
                Debug.echoError("Invalid URL SecretTag object '" + originalUrl.asString() + "' - secret not defined in 'secrets.secret'?");
                return;
            }
            urlText = secret.getValue();
        }
        MapTag newHeaders = null;
        if (headers != null) {
            newHeaders = new MapTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : headers.map.entrySet()) {
                ObjectTag value = entry.getValue();
                if (value.canBeType(SecretTag.class)) {
                    SecretTag secret = value.asType(SecretTag.class, scriptEntry.context);
                    if (secret == null) {
                        Debug.echoError("Invalid header SecretTag object '" + value + "' - secret not defined in 'secrets.secret'?");
                        return;
                    }
                    value = new ElementTag(secret.getValue(), true);
                }
                newHeaders.map.put(entry.getKey(), value);
            }
        }
        MapTag headersFinal = newHeaders;
        String urlFinal = urlText;
        if (!urlFinal.startsWith("http://") && !urlFinal.startsWith("https://")) {
            Debug.echoError("Must have a valid (HTTP/HTTPS) URL! Attempted: " + originalUrl.asString());
            return;
        }
        Thread thr = new Thread(() -> WebGetCommand.webGet(scriptEntry, data, method, urlFinal, timeout, headersFinal, saveFile, hideFailure, urlIsSecret));
        thr.start();
    }

    public static void writeToFile(InputStream in, String saveFile) throws Exception {
        int len;
        File file = new File(saveFile);
        if (!DenizenCore.implementation.canWriteToFile(file)) {
            Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
            return;
        }
        FileOutputStream fout = new FileOutputStream(file);
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > 0) {
            fout.write(buffer, 0, len);
        }
        fout.flush();
        fout.close();
    }

    public static void patchPatchMethodMethodsField() {
        if (patchAlreadyPatched) {
            return;
        }
        patchAlreadyPatched = true;
        try {
            ReflectionHelper.giveReflectiveAccess(HttpURLConnection.class, WebGetCommand.class);
            String[] methods = (String[])ReflectionHelper.getFieldValue(HttpURLConnection.class, "methods", null);
            String[] outMethods = new String[methods.length + 1];
            System.arraycopy(methods, 0, outMethods, 0, methods.length);
            outMethods[methods.length] = "PATCH";
            ReflectionHelper.getFinalSetter(HttpURLConnection.class, "methods").invoke(outMethods);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public static void webGet(final ScriptEntry scriptEntry, ElementTag data, Method method, String urlText, DurationTag timeout, MapTag headers, final String saveFile, boolean hideFailure, boolean urlIsSecret) {
        HttpURLConnection uc = null;
        try {
            Object buffer;
            final long timeStart = CoreUtilities.monotonicMillis();
            URL url = new URL(urlText.replace(" ", "%20"));
            uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            if (method != null) {
                if (method == Method.PATCH) {
                    WebGetCommand.patchPatchMethodMethodsField();
                }
                uc.setRequestMethod(method.name());
            } else if (data != null) {
                uc.setRequestMethod("POST");
            }
            if (headers != null) {
                for (Map.Entry<StringHolder, ObjectTag> pair : headers.map.entrySet()) {
                    uc.setRequestProperty(pair.getKey().str, pair.getValue().toString());
                }
            }
            uc.setConnectTimeout((int)timeout.getMillis());
            uc.connect();
            if (data != null) {
                uc.getOutputStream().write(data.asString().getBytes(StandardCharsets.UTF_8));
            }
            final int status = uc.getResponseCode();
            byte[] result = null;
            if (saveFile != null) {
                WebGetCommand.writeToFile(uc.getInputStream(), saveFile);
            } else {
                int len;
                InputStream stream = uc.getInputStream();
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                buffer = new byte[1024];
                while ((len = stream.read((byte[])buffer, 0, 1024)) != -1) {
                    bytesOut.write((byte[])buffer, 0, len);
                }
                result = bytesOut.toByteArray();
                bytesOut.close();
                stream.close();
            }
            final byte[] outResult = result;
            final MapTag resultHeaders = new MapTag();
            buffer = uc.getHeaderFields().entrySet().iterator();
            while (buffer.hasNext()) {
                Map.Entry header = (Map.Entry)buffer.next();
                String key = (String)header.getKey();
                if (key == null) {
                    key = "null";
                }
                resultHeaders.putObject(key, new ListTag((List)header.getValue()));
            }
            final long timeDone = CoreUtilities.monotonicMillis();
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    scriptEntry.addObject("status", new ElementTag(status));
                    scriptEntry.addObject("failed", new ElementTag(status >= 200 && status < 400 ? "false" : "true"));
                    if (saveFile == null) {
                        if (outResult != null) {
                            scriptEntry.addObject("result", new ElementTag(new String(outResult, StandardCharsets.UTF_8)));
                            scriptEntry.addObject("result_binary", new BinaryTag(outResult));
                        }
                        scriptEntry.addObject("result_headers", resultHeaders);
                    }
                    scriptEntry.addObject("time_ran", new DurationTag((double)(timeDone - timeStart) / 1000.0));
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        catch (Exception e) {
            byte[] result;
            int tempStatus;
            block25: {
                if (!hideFailure || uc == null) {
                    if (urlIsSecret) {
                        Debug.echoError("WebGet encountered an exception of type '" + e.getClass().getCanonicalName() + "' but hid the exception text due to secret URL presence.");
                    } else {
                        Debug.echoError(e);
                    }
                }
                tempStatus = -1;
                result = null;
                if (uc != null) {
                    try {
                        tempStatus = uc.getResponseCode();
                        InputStream errorStream = uc.getErrorStream();
                        if (errorStream != null) {
                            if (saveFile != null) {
                                WebGetCommand.writeToFile(errorStream, saveFile);
                            } else {
                                int len;
                                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                byte[] buffer = new byte[1024];
                                while ((len = errorStream.read(buffer, 0, 1024)) != -1) {
                                    bytesOut.write(buffer, 0, len);
                                }
                                result = bytesOut.toByteArray();
                                bytesOut.close();
                                errorStream.close();
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (hideFailure) break block25;
                        if (urlIsSecret) {
                            Debug.echoError("WebGet encountered an exception of type '" + e2.getClass().getCanonicalName() + "' but hid the exception text due to secret URL presence.");
                            break block25;
                        }
                        Debug.echoError(e2);
                    }
                }
            }
            final byte[] outResult = result;
            final int status = tempStatus;
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    scriptEntry.addObject("failed", new ElementTag("true"));
                    if (status != -1) {
                        scriptEntry.addObject("status", new ElementTag(status));
                        if (saveFile == null && outResult != null) {
                            scriptEntry.addObject("result", new ElementTag(new String(outResult, StandardCharsets.UTF_8)));
                            scriptEntry.addObject("result_binary", new BinaryTag(outResult));
                        }
                    }
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
    }

    public static enum Method {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE,
        PATCH;

    }
}

