/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.utilities.maps.MapImage;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.block.banner.Pattern;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;

public interface PacketHelper {
    public void setFakeAbsorption(Player var1, float var2);

    default public void resetWorldBorder(Player player) {
        player.setWorldBorder(null);
    }

    default public void setWorldBorder(Player player, Location center, double size, double currSize, long time, int warningDistance, int warningTime) {
        WorldBorder border = Bukkit.createWorldBorder();
        border.setCenter(center);
        if (time > 0L) {
            border.setSize(currSize);
            border.setSize(size, time / 1000L);
        } else {
            border.setSize(size);
        }
        border.setWarningDistance(warningDistance);
        border.setWarningTime(warningTime);
        player.setWorldBorder(border);
    }

    public void setSlot(Player var1, int var2, ItemStack var3, boolean var4);

    public void setFieldOfView(Player var1, float var2);

    public void respawn(Player var1);

    public void setVision(Player var1, EntityType var2);

    default public void showDemoScreen(Player player) {
        player.showDemoScreen();
    }

    public void showBlockAction(Player var1, Location var2, int var3, int var4);

    public void showBlockCrack(Player var1, int var2, Location var3, int var4);

    public void showTileEntityData(Player var1, Location var2, int var3, CompoundTag var4);

    public void showBannerUpdate(Player var1, Location var2, DyeColor var3, List<Pattern> var4);

    public void showTabListHeaderFooter(Player var1, String var2, String var3);

    public void showTitle(Player var1, String var2, String var3, int var4, int var5, int var6);

    default public void showEquipment(Player player, LivingEntity entity, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        player.sendEquipmentChange(entity, equipmentSlot, itemStack);
    }

    public void resetEquipment(Player var1, LivingEntity var2);

    public void showHealth(Player var1, float var2, int var3, float var4);

    default public void showMobHealth(Player player, LivingEntity mob, double health, double maxHealth) {
        throw new UnsupportedOperationException();
    }

    public void resetHealth(Player var1);

    public void showSignEditor(Player var1, Location var2);

    public void forceSpectate(Player var1, Entity var2);

    public void setNetworkManagerFor(Player var1);

    default public void enableNetworkManager() {
    }

    default public void sendRename(Player player, Entity entity, String name, boolean listMode) {
        throw new UnsupportedOperationException();
    }

    default public void generateNoCollideTeam(Player player, UUID noCollide) {
        throw new UnsupportedOperationException();
    }

    default public void removeNoCollideTeam(Player player, UUID noCollide) {
        throw new UnsupportedOperationException();
    }

    default public void sendEntityMetadataFlagsUpdate(Player player, Entity entity) {
    }

    default public void sendEntityEffect(Player player, Entity entity, byte effectId) {
        throw new UnsupportedOperationException();
    }

    default public int getPacketStats(Player player, boolean sent) {
        throw new UnsupportedOperationException();
    }

    default public void setMapData(MapCanvas canvas, byte[] bytes, int x, int y, MapImage image) {
        int width = image.width;
        int height = image.height;
        for (int x2 = 0; x2 < width; ++x2) {
            for (int y2 = 0; y2 < height; ++y2) {
                byte p = bytes[y2 * width + x2];
                if (p == 0) continue;
                canvas.setPixel(x + x2, y + y2, p);
            }
        }
    }

    default public void showDebugTestMarker(Player player, Location location, ColorTag color, String name, int time) {
        throw new UnsupportedOperationException();
    }

    default public void clearDebugTestMarker(Player player) {
        throw new UnsupportedOperationException();
    }

    default public void sendBrand(Player player, String brand) {
        throw new UnsupportedOperationException();
    }

    default public void sendCollectItemEntity(Player player, Entity taker, Entity item, int amount) {
        throw new UnsupportedOperationException();
    }

    default public void sendRelativeLookPacket(Player player, float yaw, float pitch) {
        throw new UnsupportedOperationException();
    }
}

