/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.scripts.commands.npc.EngageCommand;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class DisengageCommand
extends AbstractCommand {
    public DisengageCommand() {
        this.setName("disengage");
        this.setSyntax("disengage (player)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
        this.setBooleansHandled("player");
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        boolean linkedPlayer = scriptEntry.argAsBoolean("player");
        if (Utilities.getEntryNPC(scriptEntry) == null) {
            throw new InvalidArgumentsRuntimeException("This command requires a linked NPC!");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), Utilities.getEntryNPC(scriptEntry), DisengageCommand.db("player", linkedPlayer));
        }
        EngageCommand.setEngaged(Utilities.getEntryNPC(scriptEntry).getCitizen(), linkedPlayer ? Utilities.getEntryPlayer(scriptEntry) : null, false);
    }
}

