/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityDisplayEntityData
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        EntityTag ent;
        return entity instanceof EntityTag && (ent = (EntityTag)entity).getBukkitEntity() instanceof Display;
    }

    public static EntityDisplayEntityData getFrom(ObjectTag entity) {
        if (!EntityDisplayEntityData.describes(entity)) {
            return null;
        }
        return new EntityDisplayEntityData((EntityTag)entity);
    }

    private EntityDisplayEntityData(EntityTag ent) {
        this.entity = ent;
    }

    public Display getDisplay() {
        return (Display)this.entity.getBukkitEntity();
    }

    public static LocationTag convertVector(Vector3f vector) {
        return new LocationTag(null, (double)vector.x, (double)vector.y, vector.z);
    }

    public static ListTag convertQuaternion(Quaternionf quat) {
        return new ListTag((Collection<? extends ObjectTag>)Arrays.asList(new ElementTag(quat.x), new ElementTag(quat.y), new ElementTag(quat.z), new ElementTag(quat.w)));
    }

    public static Vector3f toVector(LocationTag loc) {
        return new Vector3f((float)loc.getX(), (float)loc.getY(), (float)loc.getZ());
    }

    public static Quaternionf toQuaternion(ListTag list) {
        return new Quaternionf(list.getObject(0).asElement().asFloat(), list.getObject(1).asElement().asFloat(), list.getObject(2).asElement().asFloat(), list.getObject(3).asElement().asFloat());
    }

    public MapTag getData() {
        Display display = this.getDisplay();
        MapTag map = new MapTag();
        map.putObject("billboard", new ElementTag((Enum<?>)display.getBillboard()));
        if (display.getBrightness() != null) {
            map.putObject("brightness_block", new ElementTag(display.getBrightness().getBlockLight()));
            map.putObject("brightness_sky", new ElementTag(display.getBrightness().getSkyLight()));
        }
        map.putObject("width", new ElementTag(display.getDisplayWidth()));
        map.putObject("height", new ElementTag(display.getDisplayHeight()));
        if (display.getGlowColorOverride() != null) {
            map.putObject("glow_color", BukkitColorExtensions.fromColor(display.getGlowColorOverride()));
        }
        map.putObject("interpolation_delay", new DurationTag((long)display.getInterpolationDelay()));
        map.putObject("interpolation_duration", new DurationTag((long)display.getInterpolationDuration()));
        map.putObject("shadow_radius", new ElementTag(display.getShadowRadius()));
        map.putObject("shadow_strength", new ElementTag(display.getShadowStrength()));
        Transformation trans = display.getTransformation();
        map.putObject("transformation_left_rotation", EntityDisplayEntityData.convertQuaternion(trans.getLeftRotation()));
        map.putObject("transformation_right_rotation", EntityDisplayEntityData.convertQuaternion(trans.getRightRotation()));
        map.putObject("transformation_scale", EntityDisplayEntityData.convertVector(trans.getScale()));
        map.putObject("transformation_translation", EntityDisplayEntityData.convertVector(trans.getTranslation()));
        map.putObject("view_range", new ElementTag(display.getViewRange()));
        if (display instanceof BlockDisplay) {
            BlockDisplay block = (BlockDisplay)display;
            map.putObject("block_display", new MaterialTag(block.getBlock()));
        } else if (display instanceof ItemDisplay) {
            ItemDisplay item = (ItemDisplay)display;
            map.putObject("item_transform", new ElementTag((Enum<?>)item.getItemDisplayTransform()));
        } else if (display instanceof TextDisplay) {
            TextDisplay text = (TextDisplay)display;
            map.putObject("text_alignment", new ElementTag((Enum<?>)text.getAlignment()));
            map.putObject("text_line_width", new ElementTag(text.getLineWidth()));
            map.putObject("text", new ElementTag(text.getText()));
            map.putObject("text_opacity", new ElementTag(text.getTextOpacity()));
            map.putObject("text_is_default_background", new ElementTag(text.isDefaultBackground()));
            map.putObject("text_is_see_through", new ElementTag(text.isSeeThrough()));
            map.putObject("text_is_shadowed", new ElementTag(text.isShadowed()));
        }
        return map;
    }

    @Override
    public String getPropertyString() {
        return this.getData().savable();
    }

    @Override
    public String getPropertyId() {
        return "display_entity_data";
    }

    public static void register() {
        PropertyParser.registerTag(EntityDisplayEntityData.class, MapTag.class, "display_entity_data", (attribute, object) -> object.getData(), new String[0]);
        PropertyParser.registerMechanism(EntityDisplayEntityData.class, MapTag.class, "display_entity_data", (object, mechanism, map) -> {
            Display display = object.getDisplay();
            display.setBillboard(map.getElement("billboard", display.getBillboard().name()).asEnum(Display.Billboard.class));
            if (map.getObject("brightness_block") != null) {
                display.setBrightness(new Display.Brightness(map.getElement("brightness_block").asInt(), map.getElement("brightness_sky").asInt()));
            }
            display.setDisplayWidth(map.getElement("width", String.valueOf(display.getWidth())).asFloat());
            display.setDisplayHeight(map.getElement("height", String.valueOf(display.getHeight())).asFloat());
            if (map.getObject("glow_color") != null) {
                display.setGlowColorOverride(BukkitColorExtensions.getColor(map.getObjectAs("glow_color", ColorTag.class, mechanism.context)));
            } else {
                display.setGlowColorOverride(null);
            }
            if (map.getObject("interpolation_delay") != null) {
                display.setInterpolationDelay(map.getObjectAs("interpolation_delay", DurationTag.class, mechanism.context).getTicksAsInt());
                display.setInterpolationDuration(map.getObjectAs("interpolation_duration", DurationTag.class, mechanism.context).getTicksAsInt());
            }
            display.setShadowRadius(map.getElement("shadow_radius", String.valueOf(display.getShadowRadius())).asFloat());
            display.setShadowStrength(map.getElement("shadow_strength", String.valueOf(display.getShadowStrength())).asFloat());
            if (map.getObject("transformation_translation") != null) {
                Vector3f translation = EntityDisplayEntityData.toVector(map.getObjectAs("transformation_translation", LocationTag.class, mechanism.context));
                Vector3f scale = EntityDisplayEntityData.toVector(map.getObjectAs("transformation_scale", LocationTag.class, mechanism.context));
                Quaternionf leftRot = EntityDisplayEntityData.toQuaternion(map.getObjectAs("transformation_left_rotation", ListTag.class, mechanism.context));
                Quaternionf rightRot = EntityDisplayEntityData.toQuaternion(map.getObjectAs("transformation_right_rotation", ListTag.class, mechanism.context));
                display.setTransformation(new Transformation(translation, leftRot, scale, rightRot));
            }
            display.setViewRange(map.getElement("view_range", String.valueOf(display.getViewRange())).asFloat());
            if (display instanceof BlockDisplay) {
                BlockDisplay block = (BlockDisplay)display;
                block.setBlock(map.getObjectAs("block_display", MaterialTag.class, mechanism.context).getModernData());
            } else if (display instanceof ItemDisplay) {
                ItemDisplay item = (ItemDisplay)display;
                item.setItemDisplayTransform(map.getElement("item_transform").asEnum(ItemDisplay.ItemDisplayTransform.class));
            } else if (display instanceof TextDisplay) {
                TextDisplay text = (TextDisplay)display;
                text.setAlignment(map.getElement("text_alignment", text.getAlignment().name()).asEnum(TextDisplay.TextAligment.class));
                if (map.getObject("text_background_color") != null) {
                    // empty if block
                }
                text.setLineWidth(map.getElement("text_line_width", String.valueOf(text.getLineWidth())).asInt());
                text.setText(map.getElement("text", text.getText()).asString());
                text.setTextOpacity((byte)map.getElement("text_opacity", String.valueOf(text.getTextOpacity())).asInt());
                text.setDefaultBackground(map.getElement("text_is_default_background", String.valueOf(text.isDefaultBackground())).asBoolean());
                text.setSeeThrough(map.getElement("text_is_see_through", String.valueOf(text.isSeeThrough())).asBoolean());
                text.setShadowed(map.getElement("text_is_shadowed", String.valueOf(text.isShadowed())).asBoolean());
            }
        }, new String[0]);
    }
}

