/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.inventory.meta.Damageable;

public class ItemDurability
implements Property {
    public static final String[] handledTags = new String[]{"durability", "max_durability"};
    public static final String[] handledMechs = new String[]{"durability"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).isRepairable();
    }

    public static ItemDurability getFrom(ObjectTag _item) {
        if (!ItemDurability.describes(_item)) {
            return null;
        }
        return new ItemDurability((ItemTag)_item);
    }

    private ItemDurability(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("durability")) {
            return new ElementTag(((Damageable)this.item.getItemMeta()).getDamage()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_durability")) {
            return new ElementTag(this.item.getMaterial().getMaterial().getMaxDurability()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        int durability = ((Damageable)this.item.getItemMeta()).getDamage();
        if (durability != 0) {
            return String.valueOf(durability);
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "durability";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("durability") && mechanism.requireInteger()) {
            this.item.setDurability((short)mechanism.getValue().asInt());
        }
    }
}

