/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ExCommandHelper {
    public static final Map<Object, TimedQueue> sustainedQueues = new HashMap<Object, TimedQueue>();

    public static ScriptQueue runString(String id, String command, ScriptEntryData data, Consumer<ScriptQueue> configure) {
        if (data == null) {
            data = DenizenCore.implementation.getEmptyScriptEntryData();
        }
        InstantQueue queue = new InstantQueue(id);
        queue.addEntries(ScriptBuilder.buildScriptEntries(Collections.singletonList(command), null, data));
        if (configure != null) {
            configure.accept(queue);
        }
        queue.start(true);
        return queue;
    }

    public static ScriptQueue runStringSustained(Object source, String id, String command, ScriptEntryData data, Consumer<ScriptQueue> configure) {
        TimedQueue queue;
        if (data == null) {
            data = DenizenCore.implementation.getEmptyScriptEntryData();
        }
        if ((queue = sustainedQueues.get(source)) == null || queue.isStopped) {
            queue = new TimedQueue(id);
            queue.waitWhenEmpty = true;
            sustainedQueues.put(source, queue);
        }
        queue.addEntries(ScriptBuilder.buildScriptEntries(Collections.singletonList(command), null, data));
        if (configure != null) {
            configure.accept(queue);
        }
        if (!queue.is_started) {
            queue.start(true);
        } else {
            queue.onStart();
        }
        return queue;
    }

    public static boolean removeSustainedQueue(Object source) {
        ScriptQueue queue = sustainedQueues.remove(source);
        return queue != null && !queue.isStopped;
    }

    public static List<String> buildTabCompletions(String[] rawArgs, TagContext context) {
        AbstractCommand.TabCompletionsBuilder completionsBuilder;
        String[] args;
        block28: {
            ObjectType typeData;
            boolean isCommandArg;
            boolean isNewArg;
            String entry = String.join((CharSequence)" ", rawArgs);
            if (entry.length() > 3 && entry.startsWith("-q ")) {
                entry = entry.substring("-q ".length());
            }
            args = ArgumentHelper.buildArgs(entry, true);
            boolean bl = isNewArg = rawArgs.length == 0 || rawArgs[rawArgs.length - 1].isEmpty();
            boolean bl2 = args.length == 0 || args.length == 1 && !isNewArg || args[args.length - (isNewArg ? 1 : 2)].equals("-") ? true : (isCommandArg = false);
            if (isCommandArg) {
                if (isNewArg || args.length == 0) {
                    return new ArrayList<String>(DenizenCore.commandRegistry.instances.keySet());
                }
                ArrayList<String> output = new ArrayList<String>();
                String startOfName = CoreUtilities.toLowerCase(args[args.length - 1]);
                for (String command : DenizenCore.commandRegistry.instances.keySet()) {
                    if (!command.startsWith(startOfName)) continue;
                    output.add(command);
                }
                return output;
            }
            String lowArg = CoreUtilities.toLowerCase(rawArgs[rawArgs.length - 1]);
            completionsBuilder = new AbstractCommand.TabCompletionsBuilder();
            completionsBuilder.arg = lowArg;
            completionsBuilder.context = context;
            if (isNewArg) break block28;
            String lastArg = rawArgs[rawArgs.length - 1];
            int argStart = 0;
            for (int i = 0; i < lastArg.length(); ++i) {
                if (lastArg.charAt(i) == '\"' || lastArg.charAt(i) == '\'') {
                    char quote = lastArg.charAt(i++);
                    while (i < lastArg.length() && lastArg.charAt(i) != quote) {
                        ++i;
                    }
                    continue;
                }
                if (lastArg.charAt(i) != ' ') continue;
                argStart = i + 1;
            }
            String arg = lastArg.substring(argStart);
            if (!CoreUtilities.contains(arg, '<')) break block28;
            int tagBits = 0;
            int relevantTagStart = -1;
            for (int i = arg.length() - 1; i >= 0; --i) {
                if (arg.charAt(i) == '>') {
                    ++tagBits;
                    continue;
                }
                if (arg.charAt(i) != '<') continue;
                if (tagBits == 0) {
                    relevantTagStart = i + 1;
                    break;
                }
                --tagBits;
            }
            if (relevantTagStart == -1) break block28;
            String fullTag = CoreUtilities.toLowerCase(arg.substring(relevantTagStart));
            int components = 0;
            int subTags = 0;
            int squareBrackets = 0;
            int lastDot = 0;
            int bracketStart = -1;
            Collection<Class<? extends ObjectTag>> typesApplicable = null;
            for (int i = 0; i < fullTag.length(); ++i) {
                Class type;
                block30: {
                    String part;
                    block29: {
                        char c = fullTag.charAt(i);
                        if (c == '<') {
                            ++subTags;
                            continue;
                        }
                        if (c == '>') {
                            --subTags;
                            continue;
                        }
                        if (c == '[' && subTags == 0) {
                            ++squareBrackets;
                            bracketStart = i;
                            continue;
                        }
                        if (c == ']' && subTags == 0) {
                            --squareBrackets;
                            continue;
                        }
                        if (c != '.' || subTags != 0 || squareBrackets != 0) continue;
                        type = null;
                        part = fullTag.substring(lastDot, bracketStart == -1 ? i : bracketStart);
                        if (components != 0) break block29;
                        TagManager.TagBaseData baseType = TagManager.baseTags.get(part);
                        if (baseType == null) break block30;
                        type = baseType.returnType;
                        break block30;
                    }
                    if (typesApplicable != null) {
                        for (Class clazz : typesApplicable) {
                            ObjectTagProcessor.TagData data;
                            typeData = ObjectFetcher.getType(clazz);
                            if (typeData == null || typeData.tagProcessor == null || (data = typeData.tagProcessor.registeredObjectTags.get(part)) == null || data.returnType == null) continue;
                            type = data.returnType;
                            break;
                        }
                    }
                }
                typesApplicable = type != null ? ObjectFetcher.getAllApplicableSubTypesFor(type) : ObjectFetcher.objectsByClass.keySet();
                ++components;
                lastDot = i + 1;
                bracketStart = -1;
            }
            String beforeDot = arg.substring(0, relevantTagStart) + fullTag.substring(0, lastDot);
            if (components == 0 && !CoreUtilities.contains(fullTag, '[')) {
                ArrayList<String> output = new ArrayList<String>();
                for (String tagBase : TagManager.baseTags.keySet()) {
                    if (!tagBase.startsWith(fullTag)) continue;
                    output.add(beforeDot + tagBase);
                }
                return output;
            }
            String subComponent = fullTag.substring(lastDot);
            if (lastDot > 0) {
                int squareBracket = subComponent.indexOf(91);
                if (squareBracket == -1) {
                    ArrayList<String> output = new ArrayList<String>();
                    for (Class clazz : typesApplicable) {
                        typeData = ObjectFetcher.getType(clazz);
                        if (typeData == null || typeData.tagProcessor == null) continue;
                        for (String tag : typeData.tagProcessor.registeredObjectTags.keySet()) {
                            if (!tag.startsWith(subComponent)) continue;
                            output.add(beforeDot + tag);
                        }
                    }
                    return output;
                }
                String tagPiece = subComponent.substring(0, squareBracket);
                if (tagPiece.startsWith("flag") || tagPiece.equals("has_flag")) {
                    completionsBuilder.arg = subComponent.substring(squareBracket + 1);
                    FlagCommand.tabCompleteFlag(completionsBuilder);
                    return completionsBuilder.completions;
                }
            }
        }
        AbstractCommand dcmd = DenizenCore.commandRegistry.get(args[0]);
        for (int i = args.length - 2; i >= 0; --i) {
            if (!args[i].equals("-")) continue;
            dcmd = DenizenCore.commandRegistry.get(args[i + 1]);
        }
        if (dcmd == null) {
            return null;
        }
        for (String flat : dcmd.docFlagArgs) {
            completionsBuilder.add(flat);
        }
        for (String prefix : dcmd.docPrefixes) {
            completionsBuilder.add(prefix + ":");
        }
        dcmd.addCustomTabCompletions(completionsBuilder);
        return completionsBuilder.completions;
    }
}

