/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;

public class EntityArmorPose
implements Property {
    public static final String[] handledMechs = new String[]{"armor_pose"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof ArmorStand;
    }

    public static EntityArmorPose getFrom(ObjectTag entity) {
        if (!EntityArmorPose.describes(entity)) {
            return null;
        }
        return new EntityArmorPose((EntityTag)entity);
    }

    public EntityArmorPose(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.getPoseMap().identify();
    }

    @Override
    public String getPropertyId() {
        return "armor_pose";
    }

    public ListTag getPoseList() {
        ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
        ListTag list = new ListTag();
        for (PosePart posePart : PosePart.values()) {
            list.add(CoreUtilities.toLowerCase(posePart.name()));
            list.addObject(EntityArmorPose.fromEulerAngle(posePart.getAngle(armorStand)));
        }
        return list;
    }

    public MapTag getPoseMap() {
        ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
        MapTag map = new MapTag();
        for (PosePart posePart : PosePart.values()) {
            map.putObject(CoreUtilities.toLowerCase(posePart.name()), EntityArmorPose.fromEulerAngle(posePart.getAngle(armorStand)));
        }
        return map;
    }

    public static void register() {
        PropertyParser.registerTag(EntityArmorPose.class, MapTag.class, "armor_pose_map", (attribute, entity) -> entity.getPoseMap(), new String[0]);
        PropertyParser.registerTag(EntityArmorPose.class, ListTag.class, "armor_pose_list", (attribute, entity) -> {
            BukkitImplDeprecations.entityArmorPose.warn(attribute.context);
            return entity.getPoseList();
        }, new String[0]);
        PropertyParser.registerTag(EntityArmorPose.class, LocationTag.class, "armor_pose", (attribute, entity) -> {
            BukkitImplDeprecations.entityArmorPose.warn(attribute.context);
            if (!attribute.hasParam()) {
                return null;
            }
            String name = attribute.getParam();
            PosePart posePart = PosePart.fromName(name);
            if (posePart == null) {
                attribute.echoError("Invalid pose part specified: " + name);
                return null;
            }
            return EntityArmorPose.fromEulerAngle(posePart.getAngle((ArmorStand)entity.entity.getBukkitEntity()));
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        block6: {
            if (!mechanism.matches("armor_pose")) break block6;
            ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
            if (mechanism.getValue().asString().contains("|")) {
                ListTag list = mechanism.valueAsType(ListTag.class);
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String name = iterator.next();
                    String angle = iterator.next();
                    PosePart posePart = PosePart.fromName(name);
                    if (posePart == null) {
                        mechanism.echoError("Invalid pose part specified: " + name + "; ignoring next: " + angle);
                        continue;
                    }
                    posePart.setAngle(armorStand, EntityArmorPose.toEulerAngle(LocationTag.valueOf(angle, mechanism.context)));
                }
            } else {
                MapTag map = mechanism.valueAsType(MapTag.class);
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    PosePart posePart = PosePart.fromName(entry.getKey().str);
                    if (posePart == null) {
                        mechanism.echoError("Invalid pose part specified: " + entry.getKey().str);
                        continue;
                    }
                    posePart.setAngle(armorStand, EntityArmorPose.toEulerAngle(entry.getValue().asType(LocationTag.class, mechanism.context)));
                }
            }
        }
    }

    public static LocationTag fromEulerAngle(EulerAngle eulerAngle) {
        return new LocationTag(null, eulerAngle.getX(), eulerAngle.getY(), eulerAngle.getZ());
    }

    public static EulerAngle toEulerAngle(LocationTag location) {
        return new EulerAngle(location.getX(), location.getY(), location.getZ());
    }

    public static enum PosePart {
        HEAD{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getHeadPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setHeadPose(eulerAngle);
            }
        }
        ,
        BODY{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getBodyPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setBodyPose(eulerAngle);
            }
        }
        ,
        LEFT_ARM{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getLeftArmPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setLeftArmPose(eulerAngle);
            }
        }
        ,
        RIGHT_ARM{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getRightArmPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setRightArmPose(eulerAngle);
            }
        }
        ,
        LEFT_LEG{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getLeftLegPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setLeftLegPose(eulerAngle);
            }
        }
        ,
        RIGHT_LEG{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getRightLegPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setRightLegPose(eulerAngle);
            }
        };


        abstract EulerAngle getAngle(ArmorStand var1);

        abstract void setAngle(ArmorStand var1, EulerAngle var2);

        static PosePart fromName(String name) {
            for (PosePart posePart : PosePart.values()) {
                if (!posePart.name().equalsIgnoreCase(name)) continue;
                return posePart;
            }
            return null;
        }
    }
}

