/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.CoreObjectTags;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ObjectFetcher {
    public static Map<String, ObjectType<? extends ObjectTag>> objectsByPrefix = new HashMap<String, ObjectType<? extends ObjectTag>>();
    public static Map<String, ObjectType<? extends ObjectTag>> objectsByName = new HashMap<String, ObjectType<? extends ObjectTag>>();
    public static Map<Class<? extends ObjectTag>, ObjectType<? extends ObjectTag>> objectsByClass = new HashMap<Class<? extends ObjectTag>, ObjectType<? extends ObjectTag>>();
    public static Map<Class<? extends ObjectTag>, List<Class<? extends ObjectTag>>> customSubtypeList = new HashMap<Class<? extends ObjectTag>, List<Class<? extends ObjectTag>>>();
    public static HashSet<Class<? extends ObjectTag>> realObjectClassSet = new HashSet();
    public static ObjectType<BinaryTag> TYPE_BINARY;
    public static ObjectType<ColorTag> TYPE_COLOR;
    public static ObjectType<CustomObjectTag> TYPE_CUSTOM;
    public static ObjectType<DurationTag> TYPE_DURATION;
    public static ObjectType<ElementTag> TYPE_ELEMENT;
    public static ObjectType<JavaReflectedObjectTag> TYPE_REFLECTEDOBJECT;
    public static ObjectType<ListTag> TYPE_LIST;
    public static ObjectType<MapTag> TYPE_MAP;
    public static ObjectType<QueueTag> TYPE_QUEUE;
    public static ObjectType<ScriptTag> TYPE_SCRIPT;
    public static ObjectType<SecretTag> TYPE_SECRET;
    public static ObjectType<TimeTag> TYPE_TIME;

    public static <T extends ObjectTag> ObjectType<T> getType(Class<T> type) {
        return objectsByClass.get(type);
    }

    private static ArrayList<Class<? extends ObjectTag>> createList(Class<? extends ObjectTag> clazz) {
        ArrayList<Class<? extends ObjectTag>> classes = new ArrayList<Class<? extends ObjectTag>>();
        classes.add(clazz);
        classes.add(ElementTag.class);
        return classes;
    }

    public static void registerCrossType(Class<? extends ObjectTag> a, Class<? extends ObjectTag> b) {
        List listA = customSubtypeList.computeIfAbsent(a, ObjectFetcher::createList);
        List listB = customSubtypeList.computeIfAbsent(b, ObjectFetcher::createList);
        listA.add(b);
        listB.add(a);
    }

    public static Collection<Class<? extends ObjectTag>> getAllApplicableSubTypesFor(Class<? extends ObjectTag> type) {
        if (type == ObjectTag.class) {
            return realObjectClassSet;
        }
        List<Class<? extends ObjectTag>> customSet = customSubtypeList.get(type);
        if (customSet != null) {
            return customSet;
        }
        if (type == ElementTag.class) {
            return Collections.singleton(ElementTag.class);
        }
        return Arrays.asList(type, ElementTag.class);
    }

    public static void registerCoreObjects() {
        TYPE_BINARY = ObjectFetcher.registerWithObjectFetcher(BinaryTag.class, BinaryTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_COLOR = ObjectFetcher.registerWithObjectFetcher(ColorTag.class, ColorTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_CUSTOM = ObjectFetcher.registerWithObjectFetcher(CustomObjectTag.class, CustomObjectTag.tagProcessor).setAsNOtherCode().generateBaseTag();
        TYPE_DURATION = ObjectFetcher.registerWithObjectFetcher(DurationTag.class, DurationTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_ELEMENT = ObjectFetcher.registerWithObjectFetcher(ElementTag.class, ElementTag.tagProcessor).setCanConvertStatic().generateBaseTag();
        ObjectFetcher.TYPE_ELEMENT.typeChecker = ObjectType.TypeComparisonRunnable.trueAlways;
        ObjectFetcher.TYPE_ELEMENT.typeConverter = (obj, c) -> obj.asElement();
        TYPE_REFLECTEDOBJECT = ObjectFetcher.registerWithObjectFetcher(JavaReflectedObjectTag.class, JavaReflectedObjectTag.tagProcessor).generateBaseTag();
        TYPE_LIST = ObjectFetcher.registerWithObjectFetcher(ListTag.class, ListTag.tagProcessor).setCanConvertStatic();
        ObjectFetcher.TYPE_LIST.typeChecker = ObjectType.TypeComparisonRunnable.trueAlways;
        ObjectFetcher.TYPE_LIST.typeConverter = ListTag::getListFor;
        TYPE_MAP = ObjectFetcher.registerWithObjectFetcher(MapTag.class, MapTag.tagProcessor).setCanConvertStatic();
        ObjectFetcher.TYPE_MAP.typeConverter = MapTag::getMapFor;
        ObjectFetcher.TYPE_MAP.typeChecker = inp -> {
            if (inp == null) {
                return false;
            }
            if (inp instanceof MapTag) {
                return true;
            }
            if (!(inp instanceof ElementTag)) {
                return false;
            }
            String simple = inp.toString();
            if (simple.startsWith("map@")) {
                return true;
            }
            return simple.startsWith("[") && simple.endsWith("]") && simple.contains("=");
        };
        TYPE_QUEUE = ObjectFetcher.registerWithObjectFetcher(QueueTag.class, QueueTag.tagProcessor).setAsNOtherCode();
        TYPE_SCRIPT = ObjectFetcher.registerWithObjectFetcher(ScriptTag.class, ScriptTag.tagProcessor).setAsNOtherCode();
        TYPE_SECRET = ObjectFetcher.registerWithObjectFetcher(SecretTag.class, SecretTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
        TYPE_TIME = ObjectFetcher.registerWithObjectFetcher(TimeTag.class, TimeTag.tagProcessor).setAsNOtherCode().setCanConvertStatic().generateBaseTag();
    }

    public static <T extends ObjectTag> ObjectType.MatchesInterface getMatchesFor(Class<T> clazz) {
        try {
            ObjectType.MatchesInterface result = ReflectionHelper.getStaticLambda(ObjectType.MatchesInterface.class, "matches", clazz, "matches", clazz.getDeclaredMethod("matches", String.class));
            if (result == null) {
                ReflectionHelper.echoError("Failed to get matches for " + clazz.getCanonicalName());
            }
            return result;
        }
        catch (Throwable ex) {
            ReflectionHelper.echoError(ex);
            return null;
        }
    }

    public static <T extends ObjectTag> ObjectType.ValueOfInterface<T> getValueOfFor(Class<T> clazz) {
        try {
            ObjectType.ValueOfInterface result = ReflectionHelper.getStaticLambda(ObjectType.ValueOfInterface.class, "valueOf", clazz, "valueOf", clazz.getDeclaredMethod("valueOf", String.class, TagContext.class));
            if (result == null) {
                ReflectionHelper.echoError("Failed to get valueOf for " + clazz.getCanonicalName());
            }
            return result;
        }
        catch (Throwable ex) {
            ReflectionHelper.echoError(ex);
            return null;
        }
    }

    @Deprecated
    public static void registerWithObjectFetcher(Class<? extends ObjectTag> objectTag) {
        ObjectFetcher.registerWithObjectFetcher(objectTag, null);
    }

    public static <T extends ObjectTag> ObjectType<T> registerWithObjectFetcher(Class<T> objectTag, ObjectTagProcessor<T> processor) {
        String className = DebugInternals.getClassNameOpti(objectTag);
        String shortName = null;
        if (className.endsWith("Tag")) {
            shortName = className.substring(0, className.length() - "Tag".length());
        }
        return ObjectFetcher.registerWithObjectFetcher(objectTag, processor, shortName, className);
    }

    public static <T extends ObjectTag> ObjectType<T> registerWithObjectFetcher(Class<T> objectTag, ObjectTagProcessor<T> processor, String shortName, String longName) {
        ObjectType newType = new ObjectType();
        newType.clazz = objectTag;
        if (processor != null) {
            processor.type = objectTag;
            CoreObjectTags.generateCoreTags(processor);
            newType.tagProcessor = processor;
        }
        newType.longName = longName;
        newType.shortName = shortName;
        newType.isAdjustable = Adjustable.class.isAssignableFrom(objectTag);
        objectsByClass.put(objectTag, newType);
        realObjectClassSet.add(objectTag);
        try {
            Method valueOfMethod = objectTag.getMethod("valueOf", String.class, TagContext.class);
            if (valueOfMethod.isAnnotationPresent(Fetchable.class)) {
                String identifier = valueOfMethod.getAnnotation(Fetchable.class).value();
                objectsByPrefix.put(CoreUtilities.toLowerCase(identifier.trim()), newType);
                objectsByName.put(CoreUtilities.toLowerCase(longName), newType);
                if (shortName != null) {
                    objectsByName.put(CoreUtilities.toLowerCase(shortName), newType);
                }
                newType.prefix = identifier;
            } else {
                Debug.echoError("Type '" + DebugInternals.getClassNameOpti(objectTag) + "' registered as an object type, but doesn't have a fetcher prefix.");
            }
            newType.matches = ObjectFetcher.getMatchesFor(objectTag);
            newType.valueOf = ObjectFetcher.getValueOfFor(objectTag);
            for (Method registerMethod : objectTag.getDeclaredMethods()) {
                if (!registerMethod.getName().equals("register") && !registerMethod.getName().equals("registerTags") || registerMethod.getParameterCount() != 0) continue;
                registerMethod.invoke(null, new Object[0]);
                break;
            }
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to initialize an object type(" + DebugInternals.getClassNameOpti(objectTag) + "): ");
            Debug.echoError(ex);
        }
        return newType;
    }

    public static boolean canFetch(String id) {
        return objectsByPrefix.containsKey(CoreUtilities.toLowerCase(id));
    }

    public static boolean isObjectWithProperties(String input) {
        return input.indexOf(91) != -1 && input.lastIndexOf(93) == input.length() - 1;
    }

    public static boolean checkMatch(Class<? extends ObjectTag> dClass, String value) {
        return ObjectFetcher.checkMatch(ObjectFetcher.getType(dClass), value);
    }

    public static boolean checkMatch(ObjectType<? extends ObjectTag> objType, String value) {
        if (value == null || objType == null) {
            return false;
        }
        int firstBracket = value.indexOf(91);
        if (firstBracket != -1 && value.lastIndexOf(93) == value.length() - 1) {
            value = value.substring(0, firstBracket);
        }
        try {
            return objType.matches.matches(value);
        }
        catch (Exception e) {
            Debug.echoError(e);
            return false;
        }
    }

    public static List<String> separateProperties(String input) {
        if (!ObjectFetcher.isObjectWithProperties(input)) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>(input.length() / 7);
        int start = 0;
        boolean needObject = true;
        int brackets = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '[' && needObject) {
                needObject = false;
                output.add(input.substring(start, i));
                start = i + 1;
                continue;
            }
            if (input.charAt(i) == '[') {
                ++brackets;
                continue;
            }
            if (input.charAt(i) == ']' && brackets > 0) {
                --brackets;
                continue;
            }
            if (input.charAt(i) != ';' && input.charAt(i) != ']' || brackets != 0) continue;
            output.add(input.substring(start, i));
            start = i + 1;
        }
        return output;
    }

    public static <T extends ObjectTag> T getObjectFrom(Class<T> dClass, String value, TagContext context) {
        if (dClass == ObjectTag.class) {
            return (T)ObjectFetcher.pickObjectFor(value, context);
        }
        return ObjectFetcher.getObjectFrom(ObjectFetcher.getType(dClass), value, context);
    }

    public static <T extends ObjectTag> T getObjectFromWithProperties(Class<T> dClass, String value, TagContext context) {
        return ObjectFetcher.getObjectFromWithProperties(ObjectFetcher.getType(dClass), value, context);
    }

    public static String partialUnescape(String description) {
        if (description.indexOf(38) != -1) {
            description = CoreUtilities.replace(description, "&sc", ";");
            description = CoreUtilities.replace(description, "&lb", "[");
            description = CoreUtilities.replace(description, "&rb", "]");
            description = CoreUtilities.replace(description, "&eq", "=");
            description = CoreUtilities.replace(description, "&amp", "&");
        }
        return description;
    }

    public static String unescapeProperty(String description) {
        if (description.indexOf(38) == -1) {
            return description;
        }
        int openBracket = description.indexOf(91);
        if (openBracket == -1) {
            return ObjectFetcher.partialUnescape(description);
        }
        int length = description.length();
        StringBuilder result = new StringBuilder(length);
        int start = 0;
        int brackets = 0;
        for (int i = openBracket; i < length; ++i) {
            char c = description.charAt(i);
            if (c == '[') {
                if (++brackets != 1) continue;
                result.append(ObjectFetcher.partialUnescape(description.substring(start, i)));
                start = i;
                continue;
            }
            if (c != ']' || --brackets != 0) continue;
            result.append(description, start, i);
            start = i;
            i = description.indexOf(91, start) - 1;
            if (i < 0) break;
        }
        result.append(ObjectFetcher.partialUnescape(description.substring(start)));
        return result.toString();
    }

    public static void applyPropertySet(Adjustable object, TagContext context, List<String> properties) {
        for (int i = 1; i < properties.size(); ++i) {
            List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
            if (data.size() != 2) {
                Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                continue;
            }
            String description = ObjectFetcher.unescapeProperty(data.get(1));
            object.safeApplyProperty(new Mechanism(data.get(0), new ElementTag(description), context));
        }
    }

    public static <T extends ObjectTag> T getObjectFrom(ObjectType<T> type, String value, TagContext context) {
        try {
            return type.valueOf.valueOf(value, context);
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public static <T extends ObjectTag> T getObjectFromWithProperties(ObjectType<T> type, String value, TagContext context) {
        try {
            List<String> matches = ObjectFetcher.separateProperties(value);
            boolean matched = matches != null && type.isAdjustable;
            Object gotten = type.valueOf.valueOf(matched ? matches.get(0) : value, context);
            if (gotten != null && matched) {
                ObjectFetcher.applyPropertySet((Adjustable)gotten, context, matches);
                gotten = gotten.fixAfterProperties();
            }
            return gotten;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public static ObjectTag pickObjectFor(String value, TagContext context) {
        ObjectTag fetched;
        String type;
        ObjectType<? extends ObjectTag> toFetch;
        if (value == null) {
            return null;
        }
        if (CoreUtilities.contains(value, '@') && (toFetch = objectsByPrefix.get(type = value.split("@", 2)[0])) != null && (toFetch.canConvertStatic || !TagManager.isStaticParsing) && (fetched = ObjectFetcher.getObjectFrom(toFetch, value, context)) != null) {
            return fetched;
        }
        return new ElementTag(value);
    }
}

