/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.core.EscapeTagUtil;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;

public class EntityAttributeModifiers
implements Property {
    public static final String[] handledMechs = new String[]{"attributes", "attribute_modifiers", "add_attribute_modifiers", "remove_attribute_modifiers"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Attributable;
    }

    public static EntityAttributeModifiers getFrom(ObjectTag entity) {
        if (!EntityAttributeModifiers.describes(entity)) {
            return null;
        }
        return new EntityAttributeModifiers((EntityTag)entity);
    }

    public EntityAttributeModifiers(EntityTag entity) {
        this.entity = entity;
    }

    @Deprecated
    public static String stringify(AttributeModifier modifier) {
        return EscapeTagUtil.escape(modifier.getName()) + "/" + modifier.getAmount() + "/" + modifier.getOperation().name() + "/" + (modifier.getSlot() == null ? "any" : modifier.getSlot().name());
    }

    @Deprecated
    public ListTag getAttributes() {
        ListTag list = new ListTag();
        for (Attribute attribute : Attribute.values()) {
            AttributeInstance instance = this.getAttributable().getAttribute(attribute);
            if (instance == null) continue;
            StringBuilder modifiers = new StringBuilder();
            for (AttributeModifier modifier : instance.getModifiers()) {
                modifiers.append("/").append(EntityAttributeModifiers.stringify(modifier));
            }
            list.add(EscapeTagUtil.escape(attribute.name()) + "/" + instance.getBaseValue() + modifiers);
        }
        return list;
    }

    public static MapTag mapify(AttributeModifier modifier) {
        MapTag result = new MapTag();
        result.putObject("name", new ElementTag(modifier.getName()));
        result.putObject("amount", new ElementTag(modifier.getAmount()));
        result.putObject("operation", new ElementTag((Enum<?>)modifier.getOperation()));
        result.putObject("slot", new ElementTag(modifier.getSlot() == null ? "any" : modifier.getSlot().name()));
        result.putObject("id", new ElementTag(modifier.getUniqueId().toString()));
        return result;
    }

    public static AttributeModifier modiferForMap(Attribute attr, MapTag map) {
        double amountValue;
        UUID idValue;
        ElementTag name = map.getElement("name");
        ElementTag amount = map.getElement("amount");
        ElementTag operation = map.getElement("operation");
        ElementTag slot = map.getElement("slot", "any");
        ElementTag id = map.getElement("id");
        AttributeModifier.Operation operationValue = operation.asEnum(AttributeModifier.Operation.class);
        if (operationValue == null) {
            Debug.echoError("Attribute modifier operation '" + operation + "' does not exist.");
            return null;
        }
        try {
            idValue = id == null ? UUID.randomUUID() : UUID.fromString(id.toString());
        }
        catch (IllegalArgumentException ex) {
            Debug.echoError("Attribute modifier ID '" + id + "' is not a valid UUID.");
            return null;
        }
        EquipmentSlot slotValue = CoreUtilities.equalsIgnoreCase(slot.toString(), "any") ? null : slot.asEnum(EquipmentSlot.class);
        try {
            amountValue = Double.parseDouble(amount.toString());
        }
        catch (NumberFormatException ex) {
            Debug.echoError("Attribute modifier amount '" + amount + "' is not a valid decimal number.");
            return null;
        }
        return new AttributeModifier(idValue, name == null ? attr.name() : name.toString(), amountValue, operationValue, slotValue);
    }

    public ListTag getAttributeModifierList(AttributeInstance instance) {
        if (instance == null) {
            return null;
        }
        ListTag result = new ListTag();
        for (AttributeModifier modifier : instance.getModifiers()) {
            result.addObject(EntityAttributeModifiers.mapify(modifier));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public MapTag getAttributeModifiers() {
        MapTag map = new MapTag();
        for (Attribute attribute : Attribute.values()) {
            ListTag list = this.getAttributeModifierList(this.getAttributable().getAttribute(attribute));
            if (list == null) continue;
            map.putObject(attribute.name(), list);
        }
        return map;
    }

    public Attributable getAttributable() {
        return (Attributable)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.getAttributeModifiers();
        return map.map.isEmpty() ? null : map.savable();
    }

    @Override
    public String getPropertyId() {
        return "attribute_modifiers";
    }

    public static void register() {
        PropertyParser.registerTag(EntityAttributeModifiers.class, MapTag.class, "attribute_modifiers", (attribute, object) -> object.getAttributeModifiers(), new String[0]);
        PropertyParser.registerTag(EntityAttributeModifiers.class, ListTag.class, "attributes", (attribute, object) -> {
            BukkitImplDeprecations.legacyAttributeProperties.warn(attribute.context);
            return object.getAttributes();
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        AttributeInstance instance;
        Attribute attr;
        Attributable ent;
        MapTag input;
        if (mechanism.matches("attribute_modifiers") && mechanism.requireObject(MapTag.class)) {
            try {
                input = mechanism.valueAsType(MapTag.class);
                ent = this.getAttributable();
                for (Map.Entry<StringHolder, ObjectTag> subValue : input.map.entrySet()) {
                    attr = Attribute.valueOf((String)subValue.getKey().str.toUpperCase());
                    instance = ent.getAttribute(attr);
                    if (instance == null) {
                        mechanism.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntityType().name());
                        continue;
                    }
                    for (AttributeModifier modifier : instance.getModifiers()) {
                        instance.removeModifier(modifier);
                    }
                    for (ObjectTag listValue : CoreUtilities.objectToList(subValue.getValue(), mechanism.context)) {
                        instance.addModifier(EntityAttributeModifiers.modiferForMap(attr, listValue.asType(MapTag.class, mechanism.context)));
                    }
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        if (mechanism.matches("add_attribute_modifiers") && mechanism.requireObject(MapTag.class)) {
            try {
                input = mechanism.valueAsType(MapTag.class);
                ent = this.getAttributable();
                for (Map.Entry<StringHolder, ObjectTag> subValue : input.map.entrySet()) {
                    attr = Attribute.valueOf((String)subValue.getKey().str.toUpperCase());
                    instance = ent.getAttribute(attr);
                    if (instance == null) {
                        mechanism.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntityType().name());
                        continue;
                    }
                    for (ObjectTag listValue : CoreUtilities.objectToList(subValue.getValue(), mechanism.context)) {
                        instance.addModifier(EntityAttributeModifiers.modiferForMap(attr, listValue.asType(MapTag.class, mechanism.context)));
                    }
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        if (mechanism.matches("remove_attribute_modifiers") && mechanism.requireObject(ListTag.class)) {
            ArrayList inputList = new ArrayList(mechanism.valueAsType(ListTag.class));
            ent = this.getAttributable();
            for (String toRemove : new ArrayList(inputList)) {
                if (!new ElementTag(toRemove).matchesEnum(Attribute.class)) continue;
                inputList.remove(toRemove);
                attr = Attribute.valueOf((String)toRemove.toUpperCase());
                instance = ent.getAttribute(attr);
                if (instance == null) {
                    mechanism.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntityType().name());
                    continue;
                }
                for (AttributeModifier modifier : instance.getModifiers()) {
                    instance.removeModifier(modifier);
                }
            }
            for (String toRemove : inputList) {
                UUID id = UUID.fromString(toRemove);
                block12: for (AttributeInstance attr2 : Attribute.values()) {
                    AttributeInstance instance2 = ent.getAttribute((Attribute)attr2);
                    if (instance2 == null) continue;
                    for (AttributeModifier modifer : instance2.getModifiers()) {
                        if (!modifer.getUniqueId().equals(id)) continue;
                        instance2.removeModifier(modifer);
                        continue block12;
                    }
                }
            }
        }
        if (mechanism.matches("attributes") && mechanism.hasValue()) {
            BukkitImplDeprecations.legacyAttributeProperties.warn(mechanism.context);
            Attributable ent2 = this.getAttributable();
            ListTag list = mechanism.valueAsType(ListTag.class);
            for (String str : list) {
                List<String> subList = CoreUtilities.split(str, '/');
                Attribute attr3 = Attribute.valueOf((String)EscapeTagUtil.unEscape(subList.get(0)).toUpperCase());
                AttributeInstance instance3 = ent2.getAttribute(attr3);
                if (instance3 == null) {
                    mechanism.echoError("Attribute " + attr3.name() + " is not applicable to entity of type " + this.entity.getBukkitEntityType().name());
                    continue;
                }
                instance3.setBaseValue(Double.parseDouble(subList.get(1)));
                for (AttributeModifier modifier : instance3.getModifiers()) {
                    instance3.removeModifier(modifier);
                }
                for (int x = 2; x < subList.size(); x += 4) {
                    String slot = subList.get(x + 3).toUpperCase();
                    AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), EscapeTagUtil.unEscape(subList.get(x)), Double.parseDouble(subList.get(x + 1)), AttributeModifier.Operation.valueOf((String)subList.get(x + 2).toUpperCase()), slot.equals("ANY") ? null : EquipmentSlot.valueOf((String)slot));
                    instance3.addModifier(modifier);
                }
            }
        }
    }
}

