/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;

public class ServerGeneratesExceptionScriptEvent
extends ScriptEvent {
    public static ServerGeneratesExceptionScriptEvent instance;
    public Throwable exception;
    public ScriptQueue queue;
    public String fullTrace;
    public int line;
    public ScriptTag script;
    public static boolean cancelledTracker;

    public ServerGeneratesExceptionScriptEvent() {
        instance = this;
        this.registerCouldMatcher("server generates exception");
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        if (this.queue != null && this.queue.getLastEntryExecuted() != null) {
            return this.queue.getLastEntryExecuted().entryData;
        }
        return super.getScriptEntryData();
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "message": {
                return new ElementTag(this.exception.getMessage());
            }
            case "full_trace": {
                return new ElementTag(this.fullTrace);
            }
            case "type": {
                return new ElementTag(DebugInternals.getClassNameOpti(this.exception.getClass()));
            }
            case "queue": {
                if (this.queue == null) break;
                return new QueueTag(this.queue);
            }
            case "script": {
                return this.script;
            }
            case "line": {
                if (this.line == -1) break;
                return new ElementTag(this.line);
            }
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        cancelledTracker = this.cancelled;
        super.cancellationChanged();
    }

    public boolean handle(Throwable ex, String trace, ScriptQueue queue, ScriptTag script, int line) {
        this.queue = queue;
        this.fullTrace = trace;
        this.exception = ex;
        this.line = line;
        this.script = script;
        cancelledTracker = false;
        this.fire();
        return cancelledTracker;
    }

    static {
        cancelledTracker = false;
    }
}

