/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.json.JSONObject;

public class MapTag
implements ObjectTag {
    public LinkedHashMap<StringHolder, ObjectTag> map;
    String prefix = "Map";
    public static ObjectTagProcessor<MapTag> tagProcessor = new ObjectTagProcessor();

    public static String unescapeLegacyEntry(String value) {
        if (value.indexOf(38) == -1) {
            return value;
        }
        value = CoreUtilities.replace(value, "&fs", "/");
        value = CoreUtilities.replace(value, "&pipe", "|");
        value = CoreUtilities.replace(value, "&amp", "&");
        return value;
    }

    @Fetchable(value="map")
    public static MapTag valueOf(String string, TagContext context) {
        return MapTag.valueOf(string, context, true);
    }

    public static MapTag valueOf(String string, TagContext context, boolean processValues) {
        boolean hasBrackets;
        if (string == null) {
            return null;
        }
        if (((String)string).startsWith("map@")) {
            string = ((String)string).substring("map@".length());
        }
        MapTag result = new MapTag();
        if (((String)string).length() == 0) {
            return result;
        }
        if (((String)string).endsWith("|")) {
            int pipe = ((String)string).indexOf(124);
            int lastPipe = 0;
            while (pipe != -1) {
                int slash = ((String)string).indexOf(47, lastPipe);
                if (slash == -1 || slash > pipe) {
                    return null;
                }
                String key = ((String)string).substring(lastPipe, slash);
                String value = ((String)string).substring(slash + 1, pipe);
                result.putObject(MapTag.unescapeLegacyEntry(key), ObjectFetcher.pickObjectFor(MapTag.unescapeLegacyEntry(value), context));
                lastPipe = pipe + 1;
                pipe = ((String)string).indexOf(124, lastPipe);
            }
            return result;
        }
        boolean bl = hasBrackets = ((String)string).startsWith("[") && ((String)string).endsWith("]");
        if (!hasBrackets && ((String)string).contains("=")) {
            string = "[" + (String)string + "]";
            hasBrackets = true;
        }
        if (hasBrackets) {
            if (((String)string).equals("[]")) {
                return result;
            }
            List<String> properties = ObjectFetcher.separateProperties((String)string);
            for (int i = 1; i < properties.size(); ++i) {
                List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
                if (data.size() != 2) {
                    if (context == null || context.showErrors()) {
                        Debug.echoError("Invalid map key=value pair string '" + properties.get(i) + "' for map input '" + (String)string + "'!");
                    }
                    return null;
                }
                String rawVal = ObjectFetcher.unescapeProperty(data.get(1));
                ObjectTag val = processValues ? ObjectFetcher.pickObjectFor(rawVal, context) : new ElementTag(rawVal);
                result.putObject(ObjectFetcher.unescapeProperty(data.get(0)), val);
            }
            return result;
        }
        return null;
    }

    public static MapTag getMapFor(ObjectTag inp, TagContext context) {
        return inp instanceof MapTag ? (MapTag)inp : MapTag.valueOf(inp.toString(), context);
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("map@")) {
            return true;
        }
        return MapTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public MapTag() {
        this.map = new LinkedHashMap();
    }

    public MapTag(Map<StringHolder, ObjectTag> map) {
        this.map = new LinkedHashMap<StringHolder, ObjectTag>(map);
    }

    @Override
    public MapTag duplicate() {
        MapTag newMap = new MapTag();
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            newMap.map.put(entry.getKey(), entry.getValue().duplicate());
        }
        return newMap;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public MapTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public boolean isTruthy() {
        return !this.map.isEmpty();
    }

    @Override
    public String debuggable() {
        if (this.map.isEmpty()) {
            return "map@";
        }
        StringBuilder debugText = new StringBuilder();
        debugText.append("<LG>map@[<Y>");
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            debugText.append(entry.getKey().str).append(" <LG>=<Y> ").append(entry.getValue().debuggable()).append("<LG>;<Y> ");
        }
        debugText.setLength(debugText.length() - "<LG>;<Y> ".length());
        debugText.append("<LG>]");
        return debugText.toString();
    }

    @Override
    public String identify() {
        if (this.map.isEmpty()) {
            return "map@[]";
        }
        StringBuilder output = new StringBuilder();
        output.append("map@[");
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            output.append(PropertyParser.escapePropertyKey(entry.getKey().str)).append("=").append(PropertyParser.escapePropertyValue(entry.getValue().savable())).append(";");
        }
        output.setLength(output.length() - 1);
        output.append(']');
        return output.toString();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<StringHolder, ObjectTag> pair : this.map.entrySet()) {
            result.put(pair.getKey().str, pair.getValue().getJavaObject());
        }
        return result;
    }

    public ObjectTag getDeepObject(String key) {
        if (!CoreUtilities.contains(key, '.')) {
            return this.getObject(key);
        }
        MapTag current = this;
        List<String> subkeys = CoreUtilities.split(key, '.');
        for (int i = 0; i < subkeys.size() - 1; ++i) {
            ObjectTag subValue = current.getObject(subkeys.get(i));
            if (!(subValue instanceof MapTag)) {
                return null;
            }
            current = (MapTag)subValue;
        }
        return current.getObject(subkeys.get(subkeys.size() - 1));
    }

    public ObjectTag getObject(String key, Supplier<ObjectTag> defaultGetter) {
        ObjectTag object = this.getDeepObject(key);
        if (object == null) {
            return defaultGetter == null ? null : defaultGetter.get();
        }
        return object.refreshState();
    }

    public <T extends ObjectTag> T getObjectAs(String key, Class<T> type, TagContext context) {
        return this.getObjectAs(key, type, context, null);
    }

    public <T extends ObjectTag> T getRequiredObjectAs(String key, Class<T> type, Attribute attribute) {
        T result = this.getObjectAs(key, type, attribute.context, null);
        if (result == null) {
            attribute.echoError("Invalid tag input - missing required key '" + key + "'");
        }
        return result;
    }

    public <T extends ObjectTag> T getObjectAs(String key, Class<T> type, TagContext context, Supplier<T> defaultGetter) {
        ObjectTag object = this.getDeepObject(key);
        if (object == null) {
            return (T)(defaultGetter == null ? null : (ObjectTag)defaultGetter.get());
        }
        return object.asType(type, context);
    }

    public ElementTag getElement(String key) {
        return this.getElement(key, null);
    }

    public ElementTag getElement(String key, String defaultValue) {
        ObjectTag object = this.getDeepObject(key);
        if (object == null) {
            return defaultValue == null ? null : new ElementTag(defaultValue);
        }
        return object.asElement();
    }

    public ObjectTag getObject(String key) {
        return this.map.get(new StringHolder(key));
    }

    public void putDeepObject(String key, ObjectTag value) {
        if (!CoreUtilities.contains(key, '.')) {
            this.putObject(key, value);
            return;
        }
        MapTag current = this;
        List<String> subkeys = CoreUtilities.split(key, '.');
        for (int i = 0; i < subkeys.size() - 1; ++i) {
            ObjectTag subValue = current.getObject(subkeys.get(i));
            if (!(subValue instanceof MapTag)) {
                if (value == null) {
                    return;
                }
                subValue = new MapTag();
                current.putObject(subkeys.get(i), subValue);
            }
            current = (MapTag)subValue;
        }
        current.putObject(subkeys.get(subkeys.size() - 1), value);
    }

    public void putObject(String key, ObjectTag value) {
        if (value == null) {
            this.map.remove(new StringHolder(key));
        } else {
            this.map.put(new StringHolder(key), value);
        }
    }

    public ListTag keys() {
        return new ListTag(this.map.keySet(), stringHolder -> new ElementTag(stringHolder.str, true));
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "size", (attribute, object) -> new ElementTag(object.map.size()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "is_empty", (attribute, object) -> new ElementTag(object.map.isEmpty()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "any", (attribute, object) -> new ElementTag(!object.map.isEmpty()), new String[0]);
        tagProcessor.registerTag(MapTag.class, "sort_by_value", (attribute, object) -> {
            Attribute subAttribute;
            ArrayList<Map.Entry<StringHolder, ObjectTag>> entryList = new ArrayList<Map.Entry<StringHolder, ObjectTag>>(object.map.entrySet());
            NaturalOrderComparator comparator = new NaturalOrderComparator();
            String tag = attribute.hasParam() ? attribute.getRawParam() : null;
            try {
                subAttribute = tag == null ? null : new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                entryList.sort((e1, e2) -> {
                    ObjectTag o1 = (ObjectTag)e1.getValue();
                    ObjectTag o2 = (ObjectTag)e2.getValue();
                    if (tag != null) {
                        o1 = CoreUtilities.autoAttribTyped(o1, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                        o2 = CoreUtilities.autoAttribTyped(o2, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    }
                    return comparator.compare(o1, o2);
                });
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            MapTag output = new MapTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : entryList) {
                output.map.put(entry.getKey(), entry.getValue());
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(MapTag.class, "filter_tag", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("Must have input to filter_tag[...]");
                return null;
            }
            MapTag newMap = new MapTag();
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            try {
                for (Map.Entry<StringHolder, ObjectTag> entry : object.map.entrySet()) {
                    provider.altDefs.putObject("filter_key", new ElementTag(entry.getKey().str));
                    provider.altDefs.putObject("filter_value", entry.getValue());
                    if (!CoreUtilities.equalsIgnoreCase(attribute.parseDynamicParam(provider).toString(), "true")) continue;
                    newMap.map.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newMap;
        }, new String[0]);
        tagProcessor.registerTag(MapTag.class, "parse_value_tag", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("Must have input to parse_value_tag[...]");
                return null;
            }
            MapTag newMap = new MapTag();
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            try {
                for (Map.Entry<StringHolder, ObjectTag> entry : object.map.entrySet()) {
                    provider.altDefs.putObject("parse_key", new ElementTag(entry.getKey().str));
                    provider.altDefs.putObject("parse_value", entry.getValue());
                    newMap.map.put(entry.getKey(), attribute.parseDynamicParam(provider));
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newMap;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "contains", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.contains' must have an input value.");
                return null;
            }
            if (attribute.getParam().contains("|")) {
                ListTag keyList = attribute.getParamObject().asType(ListTag.class, attribute.context);
                boolean contains = true;
                for (String key : keyList) {
                    if (object.getObject(key) != null) continue;
                    contains = false;
                    break;
                }
                return new ElementTag(contains);
            }
            return new ElementTag(object.getObject(attribute.getParam()) != null);
        }, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, "get", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.get' must have an input value.");
                return null;
            }
            if (attribute.getParam().contains("|")) {
                return new ListTag(attribute.paramAsType(ListTag.class), object::getObject);
            }
            return object.getObject(attribute.getParam());
        }, new String[0]);
        TagRunnable.ObjectInterface<MapTag, ObjectTag> deepGetRunnable = (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.deep_get' must have an input value.");
                return null;
            }
            if (attribute.getParam().contains("|")) {
                return new ListTag(attribute.paramAsType(ListTag.class), object::getDeepObject);
            }
            return object.getDeepObject(attribute.getParam());
        };
        tagProcessor.registerStaticTag(ObjectTag.class, "deep_get", deepGetRunnable, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, "", deepGetRunnable, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, ListTag.class, "get_subset", (attribute, object, keys) -> {
            MapTag output = new MapTag();
            for (String key : keys) {
                StringHolder keyHolder = new StringHolder(key);
                ObjectTag value = object.map.get(keyHolder);
                if (value == null) continue;
                output.map.put(keyHolder, value);
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(MapTag.class, "default", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.default' must have an input value.");
                return null;
            }
            String key = attribute.getParam();
            attribute.fulfill(1);
            if (!attribute.matches("as")) {
                attribute.echoError("The tag 'MapTag.default' must be followed by '.as'.");
                return null;
            }
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.default.as' must have an input value for 'as'.");
                return null;
            }
            if (object.map.containsKey(new StringHolder(key))) {
                return object;
            }
            ObjectTag value = attribute.getParamObject();
            MapTag result = object.duplicate();
            result.putObject(key, value);
            return result;
        }, new String[0]);
        tagProcessor.registerTag(MapTag.class, "deep_with", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.deep_with' must have an input value.");
                return null;
            }
            String key = attribute.getParam();
            attribute.fulfill(1);
            if (!attribute.matches("as")) {
                attribute.echoError("The tag 'MapTag.deep_with' must be followed by '.as'.");
                return null;
            }
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.deep_with.as' must have an input value for 'as'.");
                return null;
            }
            ObjectTag value = attribute.getParamObject();
            MapTag result = object.duplicate();
            result.putDeepObject(key, value);
            return result;
        }, new String[0]);
        tagProcessor.registerTag(MapTag.class, "with", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.with' must have an input value.");
                return null;
            }
            String key = attribute.getParam();
            attribute.fulfill(1);
            if (!attribute.matches("as")) {
                attribute.echoError("The tag 'MapTag.with' must be followed by '.as'.");
                return null;
            }
            if (!attribute.hasParam()) {
                attribute.echoError("The tag 'MapTag.with.as' must have an input value for 'as'.");
                return null;
            }
            ObjectTag value = attribute.getParamObject();
            MapTag result = object.duplicate();
            result.putObject(key, value);
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "invert", (attribute, object) -> {
            MapTag result = new MapTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : object.map.entrySet()) {
                result.map.put(new StringHolder(entry.getValue().identify()), new ElementTag(entry.getKey().str));
            }
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "reverse", (attribute, object) -> {
            ArrayList<Map.Entry<StringHolder, ObjectTag>> entries = new ArrayList<Map.Entry<StringHolder, ObjectTag>>(object.map.entrySet());
            Collections.reverse(entries);
            MapTag result = new MapTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : entries) {
                result.map.put(entry.getKey(), entry.getValue());
            }
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, ListTag.class, "deep_exclude", (attribute, object, list) -> {
            MapTag result = object.duplicate();
            for (String key : list) {
                result.putDeepObject(key, null);
            }
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, ListTag.class, "exclude", (attribute, object, list) -> {
            MapTag result = object.duplicate();
            for (String key : list) {
                result.map.remove(new StringHolder(key));
            }
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, MapTag.class, "include", (attribute, object, second) -> {
            MapTag result = object.duplicate();
            result.map.putAll(second.duplicate().map);
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "deep_keys", (attribute, object) -> {
            ListTag result = new ListTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : object.map.entrySet()) {
                if (entry.getValue() instanceof MapTag) {
                    ((MapTag)entry.getValue()).appendDeepKeys(entry.getKey().str, result);
                    continue;
                }
                result.add(entry.getKey().str);
            }
            return result;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "keys", (attribute, object) -> object.keys(), "list_keys");
        tagProcessor.registerStaticTag(ListTag.class, "values", (attribute, object) -> new ListTag(object.map.values()), "list_values");
        tagProcessor.registerStaticTag(ListTag.class, "to_pair_lists", (attribute, object) -> new ListTag(object.map.entrySet(), entry -> {
            ListTag pair = new ListTag(2);
            pair.addObject(new ElementTag(((StringHolder)entry.getKey()).str, true));
            pair.addObject((ObjectTag)entry.getValue());
            return pair;
        }), new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "to_list", (attribute, object) -> {
            String separator = attribute.hasParam() ? attribute.getParam() : "/";
            return new ListTag(object.map.entrySet(), entry -> new ElementTag(((StringHolder)entry.getKey()).str + separator + ((ObjectTag)entry.getValue()).identify(), true));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_json", (attribute, object) -> {
            MapTag input = attribute.paramAsType(MapTag.class);
            boolean nativeTypes = input != null && input.getElement("native_types", "false").asBoolean();
            int indent = input == null ? 0 : input.getElement("indent", "0").asInt();
            return new ElementTag(new JSONObject((Map)CoreUtilities.objectTagToJavaForm(object.duplicate(), false, nativeTypes)).toString(indent));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_yaml", (attribute, object) -> {
            YamlConfiguration output = new YamlConfiguration();
            output.contents = (Map)CoreUtilities.objectTagToJavaForm(object.duplicate(), true, false);
            return new ElementTag(output.saveToString(false));
        }, new String[0]);
    }

    public void appendDeepKeys(String path, ListTag result) {
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            if (entry.getValue() instanceof MapTag) {
                ((MapTag)entry.getValue()).appendDeepKeys(path + "." + entry.getKey().str, result);
                continue;
            }
            result.add(path + "." + entry.getKey().str);
        }
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

